/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.internal;

import java.io.File;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.wst.server.preview.internal.Module;
import org.eclipse.wst.server.preview.internal.ServerConfig;
import org.eclipse.wst.server.preview.internal.WTPErrorPageHandler;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.Server;

public class PreviewStarter {
    private static final String[] AVERTED_LOGS = new String[]{"org.mortbay.util.Container", "org.mortbay.http.HttpServer", "org.mortbay.util.Credential", "org.mortbay.http.SocketListener", "org.mortbay.http.HttpServer", "org.mortbay.jetty.Server"};
    protected String configPath;
    protected Server server;

    public PreviewStarter(String configPath) {
        this.configPath = configPath;
    }

    public static void main(String[] args) {
        PreviewStarter app = new PreviewStarter(args[0]);
        app.run();
    }

    protected void run() {
        System.out.println("Starting preview server");
        System.out.println();
        try {
            int n;
            int n2;
            Object[] objectArray;
            ServerConfig config = new ServerConfig(this.configPath);
            System.out.println("Port " + config.getPort());
            Module[] m = config.getModules();
            int size = m.length;
            if (size > 0) {
                System.out.println("Modules:");
                objectArray = m;
                n2 = m.length;
                n = 0;
                while (n < n2) {
                    Object mm = objectArray[n];
                    System.out.println("  " + ((Module)mm).getName());
                    ++n;
                }
                System.out.println();
            }
            objectArray = AVERTED_LOGS;
            n2 = AVERTED_LOGS.length;
            n = 0;
            while (n < n2) {
                Object log = objectArray[n];
                Logger logger = Logger.getLogger((String)log);
                logger.setFilter(new Filter(){

                    public boolean isLoggable(LogRecord record) {
                        return false;
                    }
                });
                ++n;
            }
            this.server = new Server();
            this.server.addListener(":" + config.getPort());
            this.server.setTrace(false);
            this.server.setStatsOn(false);
            HttpContext context2 = new HttpContext();
            context2.setContextPath("/");
            context2.addHandler((HttpHandler)new WTPErrorPageHandler());
            context2.setAttribute("org.mortbay.http.ErrorHandler", (Object)new WTPErrorPageHandler());
            this.server.addContext(context2);
            this.server.setRootWebApp("/");
            Module[] moduleArray = m;
            int n3 = m.length;
            n2 = 0;
            while (n2 < n3) {
                HttpContext context;
                Module module = moduleArray[n2];
                if (module.isStaticWeb()) {
                    context = new HttpContext();
                    context.setContextPath(module.getContext());
                    context.setResourceBase(module.getPath());
                    context.addHandler((HttpHandler)new ResourceHandler());
                    context.addHandler((HttpHandler)new WTPErrorPageHandler());
                    context.setAttribute("org.mortbay.http.ErrorHandler", (Object)new WTPErrorPageHandler());
                    this.server.addContext(context);
                } else {
                    context = this.server.addWebApplication(module.getContext(), module.getPath());
                    context.setAttribute("org.mortbay.http.ErrorHandler", (Object)new WTPErrorPageHandler());
                }
                ++n2;
            }
            try {
                this.server.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            System.out.println("Stop!");
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean deleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files;
            File[] fileArray = files = directory.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    PreviewStarter.deleteDirectory(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        return directory.delete();
    }
}

