/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class AutoActivationTrigger
implements ISelectionChangedListener {
    private StructuredTextViewer textViewer;

    private AutoActivationTrigger(StructuredTextViewer textViewer) {
        this.textViewer = textViewer;
    }

    public static void register(IDocument document) {
        IEditorPart editor;
        StructuredTextViewer textViewer = null;
        IWorkbenchPage page = PHPUiPlugin.getActivePage();
        if (page != null && (editor = page.getActiveEditor()) instanceof PHPStructuredEditor) {
            textViewer = ((PHPStructuredEditor)editor).getTextViewer();
        }
        if (textViewer != null && textViewer.getDocument() == document) {
            textViewer.addSelectionChangedListener((ISelectionChangedListener)new AutoActivationTrigger(textViewer));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.textViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        long delay = PHPCorePlugin.getDefault().getPluginPreferences().getLong("contentAssistAutoactivationDelay");
        new Timer("Temporary Completion Delay").schedule(new TimerTask(){

            public void run() {
                AutoActivationTrigger.this.textViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        BusyIndicator.showWhile((Display)AutoActivationTrigger.this.textViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                            public void run() {
                                AutoActivationTrigger.this.textViewer.doOperation(13);
                            }
                        });
                    }
                });
            }
        }, delay);
    }
}

