/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.ui.IEditorPart;

public class BestMatchHover
extends AbstractScriptEditorTextHover
implements IPHPTextHover,
ITextHoverExtension,
IInformationProviderExtension2 {
    private List<PHPEditorTextHoverDescriptor> fTextHoverSpecifications;
    private List<ITextHover> fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
        this(PHPUiPlugin.getActivePage() == null ? null : PHPUiPlugin.getActivePage().getActiveEditor(), PHPUiPlugin.getDefault().getPreferenceStore());
    }

    public BestMatchHover(IEditorPart editor, IPreferenceStore store) {
        this.setEditor(editor);
        this.setPreferenceStore(store);
        this.installTextHovers();
    }

    private void installTextHovers() {
        this.fTextHoverSpecifications = new ArrayList<PHPEditorTextHoverDescriptor>(2);
        this.fInstantiatedTextHovers = new ArrayList<ITextHover>(2);
        PHPEditorTextHoverDescriptor[] hoverDescs = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (!"org.eclipse.php.ui.editor.hover.BestMatchHover".equals(hoverDescs[i].getId())) {
                this.fTextHoverSpecifications.add(hoverDescs[i]);
            }
            ++i;
        }
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications.size() == 0) {
            return;
        }
        for (PHPEditorTextHoverDescriptor spec : new ArrayList<PHPEditorTextHoverDescriptor>(this.fTextHoverSpecifications)) {
            IPHPTextHover hover = spec.createTextHover();
            if (hover == null) continue;
            hover.setEditor(this.getEditor());
            hover.setPreferenceStore(this.getPreferenceStore());
            this.addTextHover((ITextHover)hover);
            this.fTextHoverSpecifications.remove(spec);
        }
    }

    protected void addTextHover(ITextHover hover) {
        if (!this.fInstantiatedTextHovers.contains(hover)) {
            this.fInstantiatedTextHovers.add(hover);
        }
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        for (ITextHover hover : this.fInstantiatedTextHovers) {
            String s = hover.getHoverInfo(textViewer, hoverRegion);
            if (s == null || s.trim().length() <= 0) continue;
            this.fBestHover = hover;
            return s;
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fBestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fBestHover).getInformationPresenterControlCreator();
        }
        return null;
    }

    public IHoverMessageDecorator getMessageDecorator() {
        if (this.fBestHover instanceof IPHPTextHover) {
            return ((IPHPTextHover)this.fBestHover).getMessageDecorator();
        }
        return null;
    }
}

