/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.functions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.functions.PHPFunctionsContentProvider;
import org.eclipse.php.internal.ui.functions.PHPFunctionsLabelProvider;
import org.eclipse.php.internal.ui.functions.PHPFunctionsSorter;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.util.PHPManualFactory;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPFunctionsPart
extends ViewPart
implements IPartListener {
    protected IPreferenceStore fStore = PHPUiPlugin.getDefault().getPreferenceStore();
    private TreeViewer fViewer;
    private PHPFunctionsContentProvider fContentProvider;
    private PHPFunctionsLabelProvider fLabelProvider;
    private Menu fContextMenu;
    private String fWorkingSetName;
    private ShowFunctionHelpAction showFunctionHelpAction;
    private boolean shouldRefresh = true;

    public void createPartControl(Composite parent) {
        this.fViewer = this.createViewer(parent);
        this.fViewer.setUseHashlookup(true);
        this.fViewer.setSorter((ViewerSorter)new PHPFunctionsSorter());
        this.setProviders();
        this.fViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !PHPFunctionsPart.isMethodVariable(parentElement, element);
            }
        });
        this.setUpPopupMenu();
        this.addDoubleClickListener();
        this.addMouseTrackListener();
        this.getSite().getPage().addPartListener((IPartListener)this);
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)new StatusBarUpdater(slManager));
        this.fViewer.getTree().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        if (!PHPFunctionsPart.this.fViewer.getTree().isDisposed() && (PHPFunctionsPart.this.shouldRefresh || PHPFunctionsPart.this.fViewer.getTree().getItems().length == 0)) {
                            PHPFunctionsPart.this.fViewer.refresh();
                            PHPFunctionsPart.this.shouldRefresh = false;
                        }
                    }
                });
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.updateTitle();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.php_functions_view");
    }

    public static boolean isMethodVariable(Object parentElement, Object element) {
        if (parentElement instanceof IModelElement && element instanceof IModelElement) {
            return ((IModelElement)parentElement).getElementType() == 9 && ((IModelElement)element).getElementType() == 8;
        }
        return false;
    }

    private void setUpPopupMenu() {
        this.showFunctionHelpAction = new ShowFunctionHelpAction();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fViewer.getTree());
        menuMgr.add((IAction)this.showFunctionHelpAction);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ISelection selection = PHPFunctionsPart.this.fViewer.getSelection();
                if (!selection.isEmpty()) {
                    IStructuredSelection s = (IStructuredSelection)selection;
                    String url = PHPManualFactory.getManual().getURLForManual((IModelElement)s.getFirstElement());
                    if (url != null) {
                        PHPFunctionsPart.this.showFunctionHelpAction.setEnabled(true);
                        PHPFunctionsPart.this.showFunctionHelpAction.setURL(url);
                    } else {
                        PHPFunctionsPart.this.showFunctionHelpAction.setEnabled(false);
                    }
                } else {
                    PHPFunctionsPart.this.showFunctionHelpAction.setEnabled(false);
                }
            }
        });
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void updateInputForCurrentEditor(final IEditorPart editorPart) {
        UIJob updateInput = new UIJob("Loading functions"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask(this.getName(), 1);
                try {
                    IScriptProject project = this.getCurrentScriptProject();
                    if (project == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    Object currentInput = PHPFunctionsPart.this.fViewer.getInput();
                    IProjectFragment[] projectFragments = project.getProjectFragments();
                    if (projectFragments == null || projectFragments.length == 0) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IProjectFragment newInput = projectFragments[1];
                    if (!newInput.equals(currentInput) && PHPFunctionsPart.this.fViewer.getContentProvider() != null) {
                        PHPFunctionsPart.this.fViewer.setInput((Object)newInput);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    Logger.logException(e);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }

            private final IScriptProject getCurrentScriptProject() throws CoreException {
                IProject[] projects;
                PHPStructuredEditor phpEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)editorPart);
                if (phpEditor != null) {
                    return phpEditor.getProject();
                }
                IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (PHPModelUtil.isPhpProject((IProject)project)) {
                        return DLTKCore.create((IProject)project);
                    }
                    ++n2;
                }
                return null;
            }
        };
        updateInput.schedule();
    }

    private TreeViewer createViewer(Composite composite) {
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filteredTree = new FilteredTree(composite, 2820, patternFilter);
        return filteredTree.getViewer();
    }

    private void addMouseTrackListener() {
        final Tree tree = this.fViewer.getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Object o;
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null && (o = item.getData()) instanceof IModelElement) {
                    tree.setToolTipText(PHPFunctionsPart.this.fLabelProvider.getText(o));
                }
            }
        });
    }

    private void addDoubleClickListener() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PHPStructuredEditor editor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)PHPFunctionsPart.this.getViewSite().getPage().getActiveEditor());
                StructuredSelection selection = (StructuredSelection)PHPFunctionsPart.this.fViewer.getSelection();
                if (editor != null && editor instanceof ITextEditor && selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IModelElement) {
                    IModelElement codeData = (IModelElement)selection.getFirstElement();
                    ITextEditor textEditor = (ITextEditor)editor;
                    int caretPosition = ((ITextSelection)textEditor.getSelectionProvider().getSelection()).getOffset();
                    IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                    try {
                        document.replace(caretPosition, 0, codeData.getElementName());
                    }
                    catch (BadLocationException e) {
                        Logger.logException(e);
                    }
                    textEditor.setFocus();
                    textEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(document, caretPosition + codeData.getElementName().length(), 0));
                }
            }
        });
    }

    public void setFocus() {
        if (this.fViewer != null && !this.fViewer.getTree().isDisposed()) {
            this.fViewer.getTree().setFocus();
        }
    }

    private void setProviders() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new PHPFunctionsContentProvider();
            this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        }
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new PHPFunctionsLabelProvider();
            this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        }
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this);
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        super.dispose();
    }

    public void partActivated(IWorkbenchPart part) {
        if (part.equals((Object)this)) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    PHPFunctionsPart.this.setFocus();
                }
            });
        }
        part = EditorUtility.getPHPStructuredEditor(part);
        if (this.getViewer().getTree().getVisible() && part != null) {
            this.updateInputForCurrentEditor((IEditorPart)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part.equals((Object)this) && this.getViewer().getInput() == null) {
            this.updateInputForCurrentEditor(null);
            this.setFocus();
        }
    }

    public TreeViewer getViewer() {
        return this.fViewer;
    }

    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    String getFrameName(Object element) {
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getElementName();
        }
        return this.fLabelProvider.getText(element);
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? this.fLabelProvider.getText(element) : ((path = ((IResource)element).getFullPath()).isRoot() ? PHPUIMessages.getString("PHPExplorer_title") : path.makeRelative().toString());
        if (this.fWorkingSetName == null) {
            return result;
        }
        String wsstr = NLS.bind((String)PHPUIMessages.getString("PHPExplorer_toolTip"), (Object[])new String[]{this.fWorkingSetName});
        if (result.length() == 0) {
            return wsstr;
        }
        return NLS.bind((String)PHPUIMessages.getString("PHPExplorer_toolTip2"), (Object[])new String[]{result, this.fWorkingSetName});
    }

    void updateTitle() {
        Object input = this.fViewer.getInput();
        if (input == null) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String inputText = this.fLabelProvider.getText(input);
            this.setContentDescription(inputText);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    class ShowFunctionHelpAction
    extends Action {
        private String url;

        public ShowFunctionHelpAction() {
            super(PHPUIMessages.getString("PHPFunctionsPart.0"));
        }

        public void setURL(String url) {
            this.url = url;
        }

        public void run() {
            if (this.url != null) {
                PHPManualFactory.getManual().showFunctionHelp(this.url);
            }
        }
    }
}

