/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.viewers.PartPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.provisional.AsynchronousLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.ILabelRequestMonitor;
import org.eclipse.debug.internal.ui.views.launch.DebugElementHelper;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbenchPart;

public class AsynchronousDebugLabelAdapter
extends AsynchronousLabelAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeLabels(Object element, IPresentationContext context, ILabelRequestMonitor monitor) {
        DelegatingModelPresentation presentation = DebugElementHelper.getPresentation();
        if (context instanceof PartPresentationContext) {
            IWorkbenchPart part;
            PartPresentationContext ppc = (PartPresentationContext)context;
            if (element instanceof IDebugElement && ppc.getPart() instanceof IDebugView && (part = ppc.getPart()) instanceof IDebugView) {
                IDebugModelPresentation pres = ((IDebugView)part).getPresentation(((IDebugElement)element).getModelIdentifier());
                Map settings = null;
                DelegatingModelPresentation delegatingModelPresentation = presentation;
                synchronized (delegatingModelPresentation) {
                    if (pres instanceof DelegatingModelPresentation) {
                        settings = ((DelegatingModelPresentation)pres).getAttributes();
                    } else if (pres instanceof LazyModelPresentation) {
                        settings = ((LazyModelPresentation)pres).getAttributes();
                    }
                    if (settings != null) {
                        Iterator iterator = settings.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            presentation.setAttribute((String)entry.getKey(), entry.getValue());
                        }
                        super.computeLabels(element, context, monitor);
                        return;
                    }
                }
            }
        }
        super.computeLabels(element, context, monitor);
    }

    protected String[] getLabels(Object element, IPresentationContext context) throws CoreException {
        return new String[]{DebugElementHelper.getLabel(element)};
    }

    protected ImageDescriptor[] getImageDescriptors(Object element, IPresentationContext context) throws CoreException {
        return new ImageDescriptor[]{DebugElementHelper.getImageDescriptor(element)};
    }

    protected FontData[] getFontDatas(Object element, IPresentationContext context) throws CoreException {
        Object[] datas = new FontData[this.getNumElements(context)];
        Arrays.fill(datas, DebugElementHelper.getFont(element));
        return datas;
    }

    protected RGB[] getForegrounds(Object element, IPresentationContext context) throws CoreException {
        Object[] rgbs = new RGB[this.getNumElements(context)];
        Arrays.fill(rgbs, DebugElementHelper.getForeground(element));
        return rgbs;
    }

    protected RGB[] getBackgrounds(Object element, IPresentationContext context) throws CoreException {
        Object[] rgbs = new RGB[this.getNumElements(context)];
        Arrays.fill(rgbs, DebugElementHelper.getBackground(element));
        return rgbs;
    }

    protected int getNumElements(IPresentationContext context) {
        String[] columns = context.getColumns();
        if (columns == null) {
            return 1;
        }
        return columns.length;
    }
}

