/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.memory.provisional.MemoryViewPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.update.DebugTargetProxy;
import org.eclipse.debug.internal.ui.viewers.update.DefaultExpressionModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DefaultVariableViewModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DefaultWatchExpressionModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.ExpressionManagerModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.LaunchManagerProxy;
import org.eclipse.debug.internal.ui.viewers.update.LaunchProxy;
import org.eclipse.debug.internal.ui.viewers.update.MemoryBlockProxy;
import org.eclipse.debug.internal.ui.viewers.update.MemoryRetrievalProxy;
import org.eclipse.debug.internal.ui.viewers.update.ProcessProxy;

public class DefaultModelProxyFactory
implements IModelProxyFactory {
    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        String id = context.getId();
        if ("org.eclipse.debug.ui.DebugView".equals(id)) {
            if (element instanceof IDebugTarget) {
                return new DebugTargetProxy((IDebugTarget)element);
            }
            if (element instanceof ILaunchManager) {
                return new LaunchManagerProxy();
            }
            if (element instanceof ILaunch) {
                return new LaunchProxy((ILaunch)element);
            }
            if (element instanceof IProcess) {
                return new ProcessProxy((IProcess)element);
            }
        }
        if ("org.eclipse.debug.ui.VariableView".equals(id) && element instanceof IStackFrame) {
            return new DefaultVariableViewModelProxy((IStackFrame)element);
        }
        if ("org.eclipse.debug.ui.ExpressionView".equals(id)) {
            if (element instanceof IExpressionManager) {
                return new ExpressionManagerModelProxy();
            }
            if (element instanceof IWatchExpression) {
                return new DefaultWatchExpressionModelProxy((IWatchExpression)element);
            }
            if (element instanceof IExpression) {
                return new DefaultExpressionModelProxy((IExpression)element);
            }
        }
        if ("org.eclipse.debug.ui.RegisterView".equals(id) && element instanceof IStackFrame) {
            return new DefaultVariableViewModelProxy((IStackFrame)element);
        }
        if ("org.eclipse.debug.ui.MemoryView".equals(id) && element instanceof IMemoryBlockRetrieval) {
            return new MemoryRetrievalProxy((IMemoryBlockRetrieval)element);
        }
        if (context instanceof MemoryViewPresentationContext && ((MemoryViewPresentationContext)context).getRendering() instanceof AbstractAsyncTableRendering && element instanceof IMemoryBlock) {
            return new MemoryBlockProxy((IMemoryBlock)element);
        }
        return null;
    }
}

