/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.statements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;

public class Block
extends Expression {
    private List statements;

    public Block() {
        this.statements = new ArrayList();
    }

    public Block(int start, int end) {
        this(start, end, null);
    }

    public Block(int start, int end, List statems) {
        super(start, end);
        this.statements = statems != null ? new ArrayList(statems) : new ArrayList();
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            Iterator it = this.statements.iterator();
            while (it.hasNext()) {
                ASTNode node = (ASTNode)it.next();
                node.traverse(visitor);
            }
            visitor.endvisit(this);
        }
    }

    public int getKind() {
        return 2008;
    }

    public void acceptStatements(List statems) {
        if (statems == null) {
            throw new IllegalArgumentException();
        }
        this.statements.addAll(statems);
    }

    public List getStatements() {
        return this.statements;
    }

    public void addStatement(ASTNode statem) {
        if (statem == null) {
            throw new IllegalArgumentException();
        }
        this.statements.add(statem);
    }

    public void printNode(CorePrinter output) {
        output.indent();
        Iterator it = this.statements.iterator();
        while (it.hasNext()) {
            ((ASTNode)it.next()).printNode(output);
            output.formatPrint("");
        }
        output.formatPrint("");
        output.dedent();
    }

    public void removeStatement(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.statements.remove(node);
    }
}

