/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.indexing.AbstractIndexer;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.internal.core.ModelManager;

public class SourceIndexer
extends AbstractIndexer {
    static long maxWorkTime = 0L;

    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    public void indexDocument() {
        ISourceElementParser parser;
        ISourceModuleInfoCache.ISourceModuleInfo info;
        long started;
        block16: {
            started = System.currentTimeMillis();
            ISourceModule module = null;
            info = null;
            SourceIndexerRequestor requestor = this.document.requestor;
            Path path = new Path(this.document.getPath());
            parser = this.document.parser;
            if (!this.document.isExternal()) {
                IProject project = this.document.getProject();
                if (project == null) {
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                }
                IScriptProject scriptProject = DLTKCore.create(project);
                if (requestor == null) {
                    requestor = ModelManager.getModelManager().indexManager.getSourceRequestor(scriptProject);
                }
                requestor.setIndexer(this);
                if (parser == null) {
                    parser = ModelManager.getModelManager().indexManager.getSourceElementParser(scriptProject);
                }
                parser.setRequestor(requestor);
                String pkgName = "";
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                if (file.exists() && (module = (ISourceModule)DLTKCore.create(file)) != null) {
                    IScriptFolder folder = (IScriptFolder)module.getParent();
                    pkgName = folder.getElementName();
                }
                requestor.setPackageName(pkgName);
                if (module != null) {
                    ISourceModuleInfoCache cache = ModelManager.getModelManager().getSourceModuleInfoCache();
                    info = cache.get(module);
                }
            } else {
                if (parser == null || requestor == null) {
                    return;
                }
                parser.setRequestor(requestor);
                requestor.setIndexer(this);
                String ppath = path.toString();
                if (DLTKCore.DEBUG) {
                    System.err.println("TODO: Correct me please...");
                }
                String pkgName = new Path(ppath.substring(ppath.indexOf("|") + 1)).removeLastSegments(1).toString();
                requestor.setPackageName(pkgName);
                if (this.document.getProject() != null) {
                    IProject project = this.document.getProject();
                    IScriptProject scriptProject = DLTKCore.create(project);
                    try {
                        IPath fragmentRelativePath;
                        IScriptFolder folder;
                        IProjectFragment[] fragments = scriptProject.getProjectFragments();
                        IModelElement frag = null;
                        int i = 0;
                        while (i < fragments.length) {
                            IPath fragmentPath = EnvironmentPathUtils.getLocalPath(fragments[i].getPath());
                            if (fragments[i].isExternal() && fragmentPath.isPrefixOf(this.document.fullPath)) {
                                frag = fragments[i];
                            }
                            ++i;
                        }
                        if (frag != null && (module = (folder = frag.getScriptFolder((fragmentRelativePath = this.document.fullPath.removeFirstSegments(frag.getPath().segmentCount())).removeLastSegments(1))).getSourceModule(this.document.fullPath.lastSegment())).exists()) {
                            info = ModelManager.getModelManager().getSourceModuleInfoCache().get(module);
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block16;
                        e.printStackTrace();
                    }
                }
            }
        }
        parser.parseSourceModule(new ParserInput(this.document), info);
        long ended = System.currentTimeMillis();
        if (ended - started > maxWorkTime) {
            maxWorkTime = ended - started;
        }
    }

    private static class ParserInput
    implements org.eclipse.dltk.compiler.env.ISourceModule {
        private final SearchDocument document;

        public ParserInput(SearchDocument document) {
            this.document = document;
        }

        public char[] getContentsAsCharArray() {
            return this.document.getCharContents();
        }

        public IModelElement getModelElement() {
            return null;
        }

        public IPath getScriptFolder() {
            return new Path(this.document.getPath()).removeLastSegments(1);
        }

        public String getSourceContents() {
            return this.document.getContents();
        }

        public char[] getFileName() {
            return this.document.getPath().toCharArray();
        }
    }
}

