/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.utils.TextUtils;

public abstract class AbstractBuildContext
implements IBuildContext {
    private final Map attributes = new HashMap();
    private final int buildType;
    protected final ISourceModule module;
    private char[] contents;
    private ISourceLineTracker lineTracker = null;

    public Object get(String attribute) {
        return this.attributes.get(attribute);
    }

    public void set(String attribute, Object value) {
        if (value == null) {
            this.attributes.remove(attribute);
        } else {
            this.attributes.put(attribute, value);
        }
    }

    protected AbstractBuildContext(ISourceModule module, int buildType) {
        this.module = module;
        this.buildType = buildType;
    }

    public int getBuildType() {
        return this.buildType;
    }

    public final char[] getContents() {
        if (this.contents == null) {
            try {
                this.contents = this.module.getSourceAsCharArray();
            }
            catch (ModelException e) {
                DLTKCore.error("Error retrieving contents of " + this.module.getElementName(), (Throwable)((Object)e));
                this.contents = CharOperation.NO_CHAR;
            }
        }
        return this.contents;
    }

    public ISourceLineTracker getLineTracker() {
        if (this.lineTracker == null) {
            this.lineTracker = TextUtils.createLineTracker(this.getContents());
        }
        return this.lineTracker;
    }

    public final ISourceModule getSourceModule() {
        return this.module;
    }

    public final IFile getFile() {
        return (IFile)this.module.getResource();
    }
}

