/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.internal.core.search.processing.IJob;
import org.eclipse.dltk.internal.core.util.Util;

public abstract class AbstractJob
implements IJob {
    protected static final boolean DEBUG = false;
    protected boolean isCancelled = false;
    private String savedName;

    public boolean belongsTo(String jobFamily) {
        return false;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public void ensureReadyToRun() {
    }

    protected abstract String getName();

    protected void log(Object message) {
        System.out.println(String.valueOf('[') + this.toString() + "] " + message);
    }

    private final String getShortClassName() {
        String name = this.getClass().getName();
        int pos = name.lastIndexOf(46);
        return pos >= 0 ? name.substring(pos + 1) : name;
    }

    public String toString() {
        String shortClassName = this.getShortClassName();
        if (this.savedName == null) {
            try {
                this.savedName = this.getName();
            }
            catch (Exception e) {
                this.savedName = "<Unknown>";
                Util.log(e, String.valueOf(this.getShortClassName()) + " getName() error");
            }
        }
        return String.valueOf(shortClassName) + '|' + this.savedName;
    }

    public final boolean execute(IProgressMonitor monitor) {
        try {
            this.run();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected abstract void run() throws CoreException, IOException;
}

