/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.mixin.AbstractJob;
import org.eclipse.dltk.internal.core.mixin.MixinIndexer;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;

abstract class MixinIndexRequest
extends AbstractJob {
    MixinIndexRequest() {
    }

    protected final IndexManager getIndexManager() {
        return ModelManager.getModelManager().getIndexManager();
    }

    protected Index getProjectMixinIndex(IScriptProject project) {
        return this.getProjectMixinIndex(project.getProject().getFullPath());
    }

    protected Index getProjectMixinIndex(IPath path) {
        String containerPath = path.getDevice() == null ? path.toString() : path.toOSString();
        return this.getIndexManager().getSpecialIndex("#special#mixin#", path.toString(), containerPath);
    }

    protected Index getProjectFragmentIndex(IProjectFragment fragment) {
        String path = fragment.getPath().toString();
        return this.getIndexManager().getSpecialIndex("#special#mixin#", path, path);
    }

    protected String[] queryDocumentNames(Index index) throws IOException {
        ReadWriteMonitor monitor = index.monitor;
        monitor.enterRead();
        try {
            String[] stringArray = index.queryDocumentNames(null);
            Object var3_4 = null;
            monitor.exitRead();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            monitor.exitRead();
            throw throwable;
        }
    }

    protected void indexSourceModule(Index index, IDLTKLanguageToolkit toolkit, ISourceModule module, IPath containerPath) {
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        IPath path = module.getPath();
        DLTKSearchDocument document = new DLTKSearchDocument(path.toString(), containerPath, null, participant, module instanceof ExternalSourceModule, module.getScriptProject().getProject());
        document.toolkit = toolkit;
        String relativePath = this.containerRelativePath(containerPath, module, path);
        document.setContainerRelativePath(relativePath);
        index.remove(relativePath);
        document.setIndex(index);
        new MixinIndexer(document, module).indexDocument();
    }

    protected Map collectSourceModulePaths(Collection modules, IPath containerPath) {
        HashMap<String, ISourceModule> paths = new HashMap<String, ISourceModule>();
        Iterator i = modules.iterator();
        while (i.hasNext()) {
            ISourceModule module = (ISourceModule)i.next();
            paths.put(this.containerRelativePath(containerPath, module), module);
        }
        return paths;
    }

    protected String containerRelativePath(IPath containerPath, ISourceModule module) {
        return this.containerRelativePath(containerPath, module, module.getPath());
    }

    protected String containerRelativePath(IPath containerPath, ISourceModule module, IPath path) {
        if (module instanceof ExternalSourceModule || module instanceof BuiltinSourceModule) {
            return path.removeFirstSegments(containerPath.segmentCount()).setDevice(null).toString();
        }
        if (module instanceof SourceModule) {
            return path.removeFirstSegments(1).toString();
        }
        return path.toString();
    }

    protected List checkChanges(Index index, Collection modules, IPath containerPath, IEnvironment environment) throws ModelException, IOException {
        String[] documents = this.queryDocumentNames(index);
        if (documents != null && documents.length != 0) {
            long indexLastModified = index.getIndexFile().lastModified();
            ArrayList<Object> changes = new ArrayList<Object>();
            Map m = this.collectSourceModulePaths(modules, containerPath);
            int i = 0;
            while (i < documents.length) {
                IFileHandle handle;
                String document = documents[i];
                ISourceModule module = (ISourceModule)m.remove(document);
                if (module == null) {
                    changes.add(document);
                } else if (environment != null && (handle = environment.getFile(EnvironmentPathUtils.getLocalPath(module.getPath()))) != null && handle.lastModified() > indexLastModified) {
                    changes.add(module);
                }
                ++i;
            }
            if (!m.isEmpty()) {
                changes.addAll(m.values());
            }
            return changes;
        }
        return new ArrayList(modules);
    }
}

