/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.navigator.dnd.NavigatorContentServiceTransfer;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.part.IDropActionDelegate;
import org.eclipse.ui.part.PluginTransferData;

public class NavigatorPluginDropAction
implements IDropActionDelegate {
    private static final boolean DEBUG = false;
    private static final String CN_PLUGIN_ACTION_ID = "org.eclipse.ui.navigator.PluginDropAction";

    public boolean run(Object sourceData, Object target) {
        String sourceViewerId = new String((byte[])sourceData);
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        INavigatorContentService contentService = NavigatorContentServiceTransfer.getInstance().findService(sourceViewerId);
        if (contentService == null) {
            return false;
        }
        try {
            CommonDropAdapterAssistant[] assistants = contentService.getDnDService().findCommonDropAdapterAssistants(target, selection);
            IStatus valid = null;
            int i = 0;
            while (i < assistants.length) {
                valid = assistants[i].validatePluginTransferDrop(selection, target);
                if (valid != null && valid.isOK()) {
                    valid = assistants[i].handlePluginTransferDrop(selection, target);
                    boolean bl = valid != null && valid.isOK();
                    return bl;
                }
                ++i;
            }
        }
        finally {
            NavigatorContentServiceTransfer.getInstance().unregisterContentService(contentService);
        }
        return false;
    }

    public static PluginTransferData createTransferData(INavigatorContentService aContentService) {
        NavigatorContentServiceTransfer.getInstance().registerContentService(aContentService);
        return new PluginTransferData(CN_PLUGIN_ACTION_ID, aContentService.getViewerId().getBytes());
    }
}

