/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.filters.CommonFiltersTab;
import org.eclipse.ui.internal.navigator.filters.ContentExtensionsTab;
import org.eclipse.ui.internal.navigator.filters.FilterDialogSelectionListener;
import org.eclipse.ui.internal.navigator.filters.UpdateActiveExtensionsOperation;
import org.eclipse.ui.internal.navigator.filters.UpdateActiveFiltersOperation;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class CommonFilterSelectionDialog
extends Dialog {
    private static final String FILTER_ICON = "icons/full/elcl16/filter_ps.gif";
    private static final String CONTENT_ICON = "icons/full/elcl16/content.gif";
    private static final int TAB_WIDTH_IN_DLUS = 300;
    private static final int TAB_HEIGHT_IN_DLUS = 150;
    private final CommonViewer commonViewer;
    private final INavigatorContentService contentService;
    private CTabFolder customizationsTabFolder;
    private CommonFiltersTab commonFiltersTab;
    private ContentExtensionsTab contentExtensionsTab;
    private Text descriptionText;
    private ISelectionChangedListener updateDescriptionSelectionListener;

    public CommonFilterSelectionDialog(CommonViewer aCommonViewer) {
        super(aCommonViewer.getControl().getShell());
        this.setShellStyle(0x10 | this.getShellStyle());
        this.commonViewer = aCommonViewer;
        this.contentService = this.commonViewer.getNavigatorContentService();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CommonNavigatorMessages.CommonFilterSelectionDialog_Available_customization_);
        Composite superComposite = (Composite)super.createDialogArea(parent);
        this.createCustomizationsTabFolder(superComposite);
        this.commonFiltersTab = new CommonFiltersTab((Composite)this.customizationsTabFolder, this.contentService);
        this.createTabItem(this.customizationsTabFolder, CommonNavigatorMessages.CommonFilterSelectionDialog_Available_Filters, this.commonFiltersTab, FILTER_ICON);
        boolean hideExtensionsTab = this.contentService.getViewerDescriptor().getBooleanConfigProperty("org.eclipse.ui.navigator.hideAvailableExtensionsTab");
        if (!hideExtensionsTab) {
            this.contentExtensionsTab = new ContentExtensionsTab((Composite)this.customizationsTabFolder, this.contentService);
            this.createTabItem(this.customizationsTabFolder, CommonNavigatorMessages.CommonFilterSelectionDialog_Available_Content, this.contentExtensionsTab, CONTENT_ICON);
        }
        this.createDescriptionText(superComposite);
        if (this.commonFiltersTab != null) {
            this.commonFiltersTab.addSelectionChangedListener(this.getSelectionListener());
        }
        if (this.contentExtensionsTab != null) {
            this.contentExtensionsTab.addSelectionChangedListener(this.getSelectionListener());
        }
        return this.customizationsTabFolder;
    }

    private void createCustomizationsTabFolder(Composite superComposite) {
        this.customizationsTabFolder = new CTabFolder(superComposite, 2064);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertVerticalDLUsToPixels(150);
        this.customizationsTabFolder.setLayout((Layout)new GridLayout());
        this.customizationsTabFolder.setLayoutData((Object)gd);
        this.customizationsTabFolder.setFont(superComposite.getFont());
        this.customizationsTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CommonFilterSelectionDialog.this.descriptionText != null) {
                    CommonFilterSelectionDialog.this.descriptionText.setText("");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.customize();
    }

    private void customize() {
        ColorRegistry reg = JFaceResources.getColorRegistry();
        Color c1 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
        Color c2 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        this.customizationsTabFolder.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
        this.customizationsTabFolder.setSelectionForeground(reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
        this.customizationsTabFolder.setSimple(true);
    }

    private CTabItem createTabItem(CTabFolder aTabFolder, String label, Composite composite, String imageKey) {
        CTabItem extensionsTabItem = new CTabItem(aTabFolder, 2048);
        extensionsTabItem.setText(label);
        extensionsTabItem.setControl((Control)composite);
        extensionsTabItem.setImage(NavigatorPlugin.getDefault().getImage(imageKey));
        return extensionsTabItem;
    }

    private void createDescriptionText(Composite composite) {
        this.descriptionText = new Text(composite, 2624);
        this.descriptionText.setFont(composite.getFont());
        this.descriptionText.setBackground(composite.getBackground());
        GridData descriptionTextGridData = new GridData(768);
        descriptionTextGridData.heightHint = this.convertHeightInCharsToPixels(3);
        this.descriptionText.setLayoutData((Object)descriptionTextGridData);
    }

    private ISelectionChangedListener getSelectionListener() {
        if (this.updateDescriptionSelectionListener == null) {
            this.updateDescriptionSelectionListener = new FilterDialogSelectionListener(this.descriptionText);
        }
        return this.updateDescriptionSelectionListener;
    }

    protected void okPressed() {
        if (this.contentExtensionsTab != null) {
            ArrayList<String> checkedExtensions = new ArrayList<String>();
            TableItem[] tableItems = this.contentExtensionsTab.getTable().getItems();
            int i = 0;
            while (i < tableItems.length) {
                INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)tableItems[i].getData();
                if (tableItems[i].getChecked()) {
                    checkedExtensions.add(descriptor.getId());
                }
                ++i;
            }
            String[] contentExtensionIdsToActivate = checkedExtensions.toArray(new String[checkedExtensions.size()]);
            UpdateActiveExtensionsOperation updateExtensions = new UpdateActiveExtensionsOperation(this.commonViewer, contentExtensionIdsToActivate);
            updateExtensions.execute(null, null);
        }
        if (this.commonFiltersTab != null) {
            Set checkedFilters = this.commonFiltersTab.getCheckedItems();
            String[] filterIdsToActivate = new String[checkedFilters.size()];
            int indx = 0;
            Iterator iterator = checkedFilters.iterator();
            while (iterator.hasNext()) {
                ICommonFilterDescriptor descriptor = (ICommonFilterDescriptor)iterator.next();
                filterIdsToActivate[indx++] = descriptor.getId();
            }
            UpdateActiveFiltersOperation updateFilters = new UpdateActiveFiltersOperation(this.commonViewer, filterIdsToActivate, true);
            updateFilters.execute(null, null);
        }
        super.okPressed();
    }
}

