/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.commands.IDbgpContextCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IRefreshableScriptVariable;
import org.eclipse.dltk.debug.core.model.IScriptStack;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.core.model.ISourceOffsetLookup;
import org.eclipse.dltk.internal.debug.core.model.Messages;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.ScriptVariableWrapper;

public class ScriptStackFrame
extends ScriptDebugElement
implements IScriptStackFrame {
    private static final String STACK_FRAME_LABEL = Messages.ScriptStackFrame_stackFrame;
    private final IScriptThread thread;
    private IDbgpStackLevel level;
    private final IScriptStack stack;
    private ScriptVariableContainer variables = null;
    private boolean needRefreshVariables = false;

    protected static IScriptVariable[] readVariables(ScriptStackFrame parentFrame, int contextId, IDbgpContextCommands commands) throws DbgpException {
        try {
            IDbgpProperty[] properties = commands.getContextProperties(parentFrame.getLevel(), contextId);
            IScriptVariable[] variables = new IScriptVariable[properties.length];
            Set duplicates = ScriptStackFrame.findDuplicateNames(properties);
            int i = 0;
            while (i < properties.length) {
                IDbgpProperty property = properties[i];
                String name = property.getName();
                if (duplicates.contains(name)) {
                    name = property.getEvalName();
                }
                variables[i] = new ScriptVariable(parentFrame, name, property);
                ++i;
            }
            return variables;
        }
        catch (DbgpDebuggingEngineException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return new IScriptVariable[0];
        }
    }

    private static Set findDuplicateNames(IDbgpProperty[] properties) {
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> alreadyExsisting = new HashSet<String>();
        int i = 0;
        while (i < properties.length) {
            IDbgpProperty property = properties[i];
            String name = property.getName();
            if (!alreadyExsisting.add(name)) {
                duplicates.add(name);
            }
            ++i;
        }
        return duplicates;
    }

    protected ScriptVariableContainer readAllVariables() throws DbgpException {
        IDbgpCoreCommands commands = this.thread.getDbgpSession().getCoreCommands();
        Map names = commands.getContextNames(this.getLevel());
        ScriptVariableContainer result = new ScriptVariableContainer();
        if (this.thread.retrieveLocalVariables() && names.containsKey(new Integer(0))) {
            result.locals = ScriptStackFrame.readVariables(this, 0, commands);
        }
        if (this.thread.retrieveGlobalVariables() && names.containsKey(new Integer(1))) {
            result.globals = ScriptStackFrame.readVariables(this, 1, commands);
        }
        if (this.thread.retrieveClassVariables() && names.containsKey(new Integer(2))) {
            result.classes = ScriptStackFrame.readVariables(this, 2, commands);
        }
        return result;
    }

    public ScriptStackFrame(IScriptStack stack, IDbgpStackLevel stackLevel) {
        this.stack = stack;
        this.thread = stack.getThread();
        this.level = stackLevel;
    }

    public void updateVariables() {
        this.variables = null;
    }

    public IScriptStack getStack() {
        return this.stack;
    }

    public URI getFileName() {
        return this.level.getFileURI();
    }

    public int getCharStart() throws DebugException {
        ISourceOffsetLookup offsetLookup;
        int endLine;
        int beginLine = this.level.getBeginLine();
        if (beginLine > 0 && (endLine = this.level.getEndLine()) > 0 && (endLine == beginLine || endLine == beginLine + 1) && (offsetLookup = DLTKDebugPlugin.getSourceOffsetLookup()) != null) {
            return offsetLookup.calculateOffset(this, beginLine, this.level.getBeginColumn(), false);
        }
        return -1;
    }

    public int getCharEnd() throws DebugException {
        int offset;
        ISourceOffsetLookup offsetLookup;
        int beginLine;
        int endLine = this.level.getEndLine();
        if (endLine > 0 && (beginLine = this.level.getBeginLine()) > 0 && (endLine == beginLine || endLine == beginLine + 1) && (offsetLookup = DLTKDebugPlugin.getSourceOffsetLookup()) != null && (offset = offsetLookup.calculateOffset(this, endLine, this.level.getEndColumn(), true)) >= 0) {
            return offset + 1;
        }
        return -1;
    }

    public int getLineNumber() throws DebugException {
        return this.level.getLineNumber();
    }

    public int getBeginLine() {
        return this.level.getBeginLine();
    }

    public int getBeginColumn() {
        return this.level.getBeginColumn();
    }

    public int getEndLine() {
        return this.level.getEndLine();
    }

    public int getEndColumn() {
        return this.level.getEndColumn();
    }

    public String getWhere() {
        return this.level.getWhere().trim();
    }

    public String getName() throws DebugException {
        String name = this.level.getWhere().trim();
        if (name == null || name.length() == 0) {
            name = this.toString();
        }
        name = String.valueOf(name) + " (" + this.level.getFileURI().getPath() + ")";
        return name;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public IThread getThread() {
        return this.thread;
    }

    public boolean hasVariables() throws DebugException {
        this.checkVariablesAvailable();
        return this.variables.hasVariables();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void checkVariablesAvailable() throws DebugException {
        try {
            if (this.variables == null) {
                this.variables = this.readAllVariables();
                this.variables.sort(this.getDebugTarget());
                return;
            }
            if (!this.needRefreshVariables) return;
            try {
                this.refreshVariables();
            }
            catch (Throwable throwable) {
                Object var1_3 = null;
                this.needRefreshVariables = false;
                throw throwable;
            }
            {
                Object var1_4 = null;
                this.needRefreshVariables = false;
                return;
            }
        }
        catch (DbgpException e) {
            this.variables = new ScriptVariableContainer();
            Status status = new Status(4, "org.eclipse.dltk.debug", Messages.ScriptStackFrame_unableToLoadVariables, (Throwable)e);
            DLTKDebugPlugin.log((IStatus)status);
            throw new DebugException((IStatus)status);
        }
    }

    private void refreshVariables() throws DebugException, DbgpException {
        ScriptVariableContainer newVars = this.readAllVariables();
        newVars.sort(this.getDebugTarget());
        this.variables.locals = ScriptStackFrame.refreshVariables(newVars.locals, this.variables.locals);
        this.variables.globals = ScriptStackFrame.refreshVariables(newVars.globals, this.variables.globals);
        this.variables.classes = ScriptStackFrame.refreshVariables(newVars.classes, this.variables.classes);
    }

    static IVariable[] refreshVariables(IVariable[] newVars, IVariable[] oldVars) throws DebugException {
        if (oldVars != null) {
            IVariable variable;
            HashMap<String, IVariable> map = new HashMap<String, IVariable>();
            int i = 0;
            while (i < oldVars.length) {
                variable = oldVars[i];
                if (variable instanceof IRefreshableScriptVariable) {
                    map.put(variable.getName(), variable);
                }
                ++i;
            }
            i = 0;
            while (i < newVars.length) {
                variable = newVars[i];
                IRefreshableScriptVariable old = (IRefreshableScriptVariable)map.get(variable.getName());
                if (old != null) {
                    newVars[i] = old.refreshVariable(variable);
                }
                ++i;
            }
        }
        return newVars;
    }

    public IVariable[] getVariables() throws DebugException {
        this.checkVariablesAvailable();
        return this.variables.toArray(this.getDebugTarget());
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public IDebugTarget getDebugTarget() {
        return this.thread.getDebugTarget();
    }

    public IScriptVariable findVariable(String varName) throws DebugException {
        this.checkVariablesAvailable();
        return (IScriptVariable)this.variables.findVariable(varName);
    }

    public int getLevel() {
        return this.level.getLevel();
    }

    public String toString() {
        return MessageFormat.format(STACK_FRAME_LABEL, new Integer(this.level.getLevel()));
    }

    public String getSourceLine() {
        return this.level.getWhere();
    }

    public URI getSourceURI() {
        return this.level.getFileURI();
    }

    public IScriptThread getScriptThread() {
        return (IScriptThread)this.getThread();
    }

    public ScriptStackFrame bind(IDbgpStackLevel newLevel) {
        if (this.level.isSameMethod(newLevel)) {
            this.level = newLevel;
            this.needRefreshVariables = true;
            return this;
        }
        return new ScriptStackFrame(this.stack, newLevel);
    }

    private static class ScriptVariableContainer {
        IVariable[] locals = null;
        IVariable[] globals = null;
        IVariable[] classes = null;
        ScriptVariableWrapper globalsWrapper = null;
        ScriptVariableWrapper classesWrapper = null;

        private ScriptVariableContainer() {
        }

        ScriptVariableContainer sort(IDebugTarget target) {
            Comparator variableComparator = ScriptDebugManager.getInstance().getVariableNameComparatorByDebugModel(target.getModelIdentifier());
            if (this.locals != null) {
                Arrays.sort(this.locals, variableComparator);
            }
            if (this.globals != null) {
                Arrays.sort(this.globals, variableComparator);
            }
            if (this.classes != null) {
                Arrays.sort(this.classes, variableComparator);
            }
            return this;
        }

        private int size() {
            int size = 0;
            if (this.locals != null) {
                size += this.locals.length;
            }
            if (this.globals != null) {
                ++size;
            }
            if (this.classes != null) {
                ++size;
            }
            return size;
        }

        IScriptVariable[] toArray(IDebugTarget target) {
            int size = this.size();
            IScriptVariable[] result = new IScriptVariable[size];
            if (size != 0) {
                int index = 0;
                if (this.globals != null) {
                    if (this.globalsWrapper == null) {
                        this.globalsWrapper = new ScriptVariableWrapper(target, Messages.ScriptStackFrame_globalVariables, this.globals);
                    } else {
                        this.globalsWrapper.refreshValue(this.globals);
                    }
                    result[index++] = this.globalsWrapper;
                }
                if (this.classes != null) {
                    if (this.classesWrapper == null) {
                        this.classesWrapper = new ScriptVariableWrapper(target, Messages.ScriptStackFrame_classVariables, this.classes);
                    } else {
                        this.classesWrapper.refreshValue(this.classes);
                    }
                    result[index++] = this.classesWrapper;
                }
                if (this.locals != null) {
                    System.arraycopy(this.locals, 0, result, index, this.locals.length);
                    index += this.locals.length;
                }
            }
            return result;
        }

        public boolean hasVariables() {
            return this.locals != null && this.locals.length != 0 || this.classes != null || this.globals != null;
        }

        public IVariable findVariable(String varName) throws DebugException {
            IVariable variable;
            if (this.locals != null && (variable = ScriptVariableContainer.findVariable(varName, this.locals)) != null) {
                return variable;
            }
            if (this.globals != null && (variable = ScriptVariableContainer.findVariable(varName, this.globals)) != null) {
                return variable;
            }
            return null;
        }

        private static IVariable findVariable(String varName, IVariable[] vars) throws DebugException {
            int i = 0;
            while (i < vars.length) {
                IVariable var = vars[i];
                if (var.getName().equals(varName)) {
                    return var;
                }
                ++i;
            }
            return null;
        }
    }
}

