/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.IDebuggerInitializer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class PHPWebServerDebuggerInitializer
implements IDebuggerInitializer {
    private DebugException exception;
    private static boolean isDebugMode = System.getProperty("loggingDebug") != null;

    public void debug(ILaunch launch) throws DebugException {
        String debugQuery;
        this.exception = null;
        IDebugParametersInitializer parametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(launch);
        final String encodedURL = parametersInitializer.getRequestURL(launch).replaceAll(" ", "%20");
        boolean runWithDebug = true;
        try {
            runWithDebug = launch.getLaunchConfiguration().getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        }
        catch (CoreException coreException) {}
        if (!runWithDebug && "run".equals(launch.getLaunchMode())) {
            debugQuery = encodedURL;
        } else {
            String query = parametersInitializer.generateQuery(launch);
            debugQuery = encodedURL.indexOf(63) == -1 ? String.valueOf(encodedURL) + '?' + query : String.valueOf(encodedURL) + '&' + query;
        }
        if (isDebugMode) {
            System.out.println("debugQuery = " + debugQuery);
        }
        boolean openInBrowser = false;
        try {
            openInBrowser = launch.getLaunchConfiguration().getAttribute("org.eclipse.php.debug.core.OpenInBrowser", false);
        }
        catch (Throwable t) {
            Logger.logException("Error obtaining the 'openInBrowser' configuration.", t);
        }
        if (openInBrowser) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        int browserStyle = 14;
                        PlatformUI.getWorkbench().getBrowserSupport().createBrowser(browserStyle, null, encodedURL, debugQuery).openURL(new URL(debugQuery));
                    }
                    catch (Throwable t) {
                        Logger.logException("Error initializing the web browser.", t);
                        String errorMessage = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
                        PHPWebServerDebuggerInitializer.this.exception = new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, t));
                    }
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
        } else {
            try {
                PHPWebServerDebuggerInitializer.connect(new URL(debugQuery));
            }
            catch (MalformedURLException e) {
                Logger.logException("Malformed URL Exception " + debugQuery, e);
                String errorMessage = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
                throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, (Throwable)e));
            }
        }
    }

    public static void connect(URL url) throws DebugException {
        try {
            URLConnection connection = url.openConnection();
            String headerKey = connection.getHeaderFieldKey(1);
            if (headerKey == null) {
                Logger.log(2, "No HeaderKey returned by server. Most likely not started");
                String errorMessage = PHPDebugCoreMessages.DebuggerConnection_Problem_1;
                throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, null));
            }
            int i = 1;
            while ((headerKey = connection.getHeaderFieldKey(i)) != null) {
                if (headerKey.equals("X-Zend-Debug-Server")) {
                    String headerValue = connection.getHeaderField(headerKey);
                    if (headerValue.equals("OK")) break;
                    Logger.log(2, "Unexpected Header Value returned by Server. " + headerValue);
                    String errorMessage = String.valueOf(PHPDebugCoreMessages.DebuggerConnection_Problem_2) + " - " + headerValue;
                    throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, null));
                }
                ++i;
            }
            InputStream inputStream = connection.getInputStream();
            while (inputStream.read() != -1) {
            }
        }
        catch (UnknownHostException exc) {
            Logger.logException("Unknown host: " + url.getHost(), exc);
        }
        catch (ConnectException exc) {
            Logger.logException("Unable to connect to URL " + url, exc);
        }
        catch (IOException exc) {
            Logger.logException("Unable to connect to URL " + url, exc);
        }
        catch (Exception exc) {
            Logger.logException("Unexpected exception communicating with Web server", exc);
            String errorMessage = exc.getMessage();
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, (Throwable)exc));
        }
    }
}

