/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;

public class BundlePoolFilteredListener
extends DirectoryChangeListener {
    private DirectoryChangeListener delegate;
    private Set bundlePoolFiles = new HashSet();

    public BundlePoolFilteredListener(DirectoryChangeListener listener) {
        this.delegate = listener;
        IFileArtifactRepository bundlePool = Activator.getBundlePoolRepository();
        if (bundlePool != null) {
            IArtifactKey[] keys = bundlePool.getArtifactKeys();
            int i = 0;
            while (i < keys.length) {
                File artifactFile = bundlePool.getArtifactFile(keys[i]);
                if (artifactFile != null) {
                    this.bundlePoolFiles.add(artifactFile);
                }
                ++i;
            }
        }
    }

    public boolean added(File file) {
        return this.delegate.added(file);
    }

    public boolean changed(File file) {
        return this.delegate.changed(file);
    }

    public Long getSeenFile(File file) {
        return this.delegate.getSeenFile(file);
    }

    public boolean isInterested(File file) {
        if (this.bundlePoolFiles.contains(file)) {
            return false;
        }
        return this.delegate.isInterested(file);
    }

    public boolean removed(File file) {
        return this.delegate.removed(file);
    }

    public void startPoll() {
        this.delegate.startPoll();
    }

    public void stopPoll() {
        this.delegate.stopPoll();
    }
}

