/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.jetty.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.equinox.http.jetty.internal.HttpServerManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.startlevel.StartLevel;

public class Activator
implements BundleActivator {
    private static final String JETTY_WORK_DIR = "jettywork";
    private static final String DEFAULT_PID = "default";
    private static final String MANAGED_SERVICE_FACTORY_PID = "org.eclipse.equinox.http.jetty.config";
    private static final String ORG_OSGI_SERVICE_HTTP_PORT = "org.osgi.service.http.port";
    private static final String ORG_OSGI_SERVICE_HTTP_PORT_SECURE = "org.osgi.service.http.port.secure";
    private static final String AUTOSTART = "org.eclipse.equinox.http.jetty.autostart";
    private static HttpServerManager staticServerManager;
    private HttpServerManager httpServerManager;
    private ServiceRegistration registration;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void start(BundleContext context) throws Exception {
        File jettyWorkDir = new File(context.getDataFile(""), JETTY_WORK_DIR);
        jettyWorkDir.mkdir();
        this.httpServerManager = new HttpServerManager(jettyWorkDir);
        String autostart = context.getProperty(AUTOSTART);
        if ((autostart == null || Boolean.valueOf(autostart).booleanValue()) && !this.isBundleActivationPolicyUsed(context)) {
            Dictionary defaultSettings = this.createDefaultSettings(context);
            this.httpServerManager.updated(DEFAULT_PID, defaultSettings);
        }
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("service.pid", MANAGED_SERVICE_FACTORY_PID);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registration = context.registerService(clazz.getName(), (Object)this.httpServerManager, dictionary);
        Activator.setStaticServerManager(this.httpServerManager);
    }

    private boolean isBundleActivationPolicyUsed(BundleContext context) {
        ServiceReference reference;
        StartLevel sl;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.startlevel.StartLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StartLevel startLevel = sl = (reference = context.getServiceReference(clazz.getName())) != null ? (StartLevel)context.getService(reference) : null;
        if (sl != null) {
            try {
                Bundle bundle = context.getBundle();
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.osgi.service.startlevel.StartLevel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class[] classArray = new Class[1];
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("org.osgi.framework.Bundle");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz3;
                Method isBundleActivationPolicyUsed = clazz2.getMethod("isBundleActivationPolicyUsed", classArray);
                Boolean result = (Boolean)isBundleActivationPolicyUsed.invoke((Object)sl, bundle);
                boolean bl = result;
                return bl;
            }
            catch (Exception exception) {
            }
            finally {
                context.ungetService(reference);
            }
        }
        return false;
    }

    public void stop(BundleContext context) throws Exception {
        Activator.setStaticServerManager(null);
        this.registration.unregister();
        this.registration = null;
        this.httpServerManager.shutdown();
        this.httpServerManager = null;
    }

    private Dictionary createDefaultSettings(BundleContext context) {
        String otherInfo;
        String sessionInactiveInterval;
        String contextpath;
        Hashtable<String, Object> defaultSettings = new Hashtable<String, Object>();
        ((Dictionary)defaultSettings).put("service.pid", DEFAULT_PID);
        String httpEnabledProperty = context.getProperty("org.eclipse.equinox.http.jetty.http.enabled");
        Boolean httpEnabled = httpEnabledProperty == null ? Boolean.TRUE : new Boolean(httpEnabledProperty);
        ((Dictionary)defaultSettings).put("http.enabled", httpEnabled);
        String httpPortProperty = context.getProperty("org.eclipse.equinox.http.jetty.http.port");
        if (httpPortProperty == null) {
            httpPortProperty = context.getProperty(ORG_OSGI_SERVICE_HTTP_PORT);
        }
        int httpPort = 80;
        if (httpPortProperty != null) {
            try {
                httpPort = Integer.parseInt(httpPortProperty);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ((Dictionary)defaultSettings).put("http.port", new Integer(httpPort));
        String httpHost = context.getProperty("org.eclipse.equinox.http.jetty.http.host");
        if (httpHost != null) {
            ((Dictionary)defaultSettings).put("http.host", httpHost);
        }
        Boolean httpsEnabled = new Boolean(context.getProperty("org.eclipse.equinox.http.jetty.https.enabled"));
        ((Dictionary)defaultSettings).put("https.enabled", httpsEnabled);
        if (httpsEnabled.booleanValue()) {
            String keystoretype;
            String algorithm;
            String protocol;
            String wantclientauth;
            String needclientauth;
            String keypassword;
            String password;
            String keystore;
            String httpsPortProperty = context.getProperty("org.eclipse.equinox.http.jetty.https.port");
            if (httpPortProperty == null) {
                httpPortProperty = context.getProperty(ORG_OSGI_SERVICE_HTTP_PORT_SECURE);
            }
            int httpsPort = 443;
            if (httpsPortProperty != null) {
                try {
                    httpsPort = Integer.parseInt(httpsPortProperty);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ((Dictionary)defaultSettings).put("https.port", new Integer(httpsPort));
            String httpsHost = context.getProperty("org.eclipse.equinox.http.jetty.https.host");
            if (httpsHost != null) {
                ((Dictionary)defaultSettings).put("https.host", httpsHost);
            }
            if ((keystore = context.getProperty("org.eclipse.equinox.http.jetty.ssl.keystore")) != null) {
                ((Dictionary)defaultSettings).put("ssl.keystore", keystore);
            }
            if ((password = context.getProperty("org.eclipse.equinox.http.jetty.ssl.password")) != null) {
                ((Dictionary)defaultSettings).put("ssl.password", password);
            }
            if ((keypassword = context.getProperty("org.eclipse.equinox.http.jetty.ssl.keypassword")) != null) {
                ((Dictionary)defaultSettings).put("ssl.keypassword", keypassword);
            }
            if ((needclientauth = context.getProperty("org.eclipse.equinox.http.jetty.ssl.needclientauth")) != null) {
                ((Dictionary)defaultSettings).put("ssl.needclientauth", new Boolean(needclientauth));
            }
            if ((wantclientauth = context.getProperty("org.eclipse.equinox.http.jetty.ssl.wantclientauth")) != null) {
                ((Dictionary)defaultSettings).put("ssl.wantclientauth", new Boolean(wantclientauth));
            }
            if ((protocol = context.getProperty("org.eclipse.equinox.http.jetty.ssl.protocol")) != null) {
                ((Dictionary)defaultSettings).put("ssl.protocol", protocol);
            }
            if ((algorithm = context.getProperty("org.eclipse.equinox.http.jetty.ssl.algorithm")) != null) {
                ((Dictionary)defaultSettings).put("ssl.algorithm", algorithm);
            }
            if ((keystoretype = context.getProperty("org.eclipse.equinox.http.jetty.ssl.keystoretype")) != null) {
                ((Dictionary)defaultSettings).put("ssl.keystoretype", keystoretype);
            }
        }
        if ((contextpath = context.getProperty("org.eclipse.equinox.http.jetty.context.path")) != null) {
            ((Dictionary)defaultSettings).put("context.path", contextpath);
        }
        if ((sessionInactiveInterval = context.getProperty("org.eclipse.equinox.http.jetty.context.sessioninactiveinterval")) != null) {
            try {
                ((Dictionary)defaultSettings).put("context.sessioninactiveinterval", new Integer(sessionInactiveInterval));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((otherInfo = context.getProperty("org.eclipse.equinox.http.jetty.other.info")) != null) {
            ((Dictionary)defaultSettings).put("other.info", otherInfo);
        }
        return defaultSettings;
    }

    public static synchronized void startServer(String pid, Dictionary settings) throws Exception {
        if (staticServerManager == null) {
            throw new IllegalStateException("Inactive");
        }
        staticServerManager.updated(pid, settings);
    }

    public static synchronized void stopServer(String pid) throws Exception {
        if (staticServerManager != null) {
            staticServerManager.deleted(pid);
        }
    }

    private static synchronized void setStaticServerManager(HttpServerManager httpServerManager) {
        staticServerManager = httpServerManager;
    }
}

