/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.preferences.IPHPPreferencePageBlock;

public class PHPPreferencePageBlocksRegistry {
    private static final String EXTENSION_POINT_NAME = "phpPreferencePageBlocks";
    private static final String BLOCK_TAG = "block";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PAGE_ID_ATTRIBUTE = "pageId";
    private static final String PDT_PREFIX = "org.eclipse.php.";
    private Dictionary pageBlocks = new Hashtable();
    private static PHPPreferencePageBlocksRegistry instance = null;
    private static Comparator pageBlockComparator = new PageBlockComparator();

    private PHPPreferencePageBlocksRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.php.ui", EXTENSION_POINT_NAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (BLOCK_TAG.equals(element.getName())) {
                String preferencesPageID = element.getAttribute(PAGE_ID_ATTRIBUTE);
                this.addBlock(this.pageBlocks, preferencesPageID, element);
            }
            ++i;
        }
    }

    private void addBlock(Dictionary dictionary, String preferencesPageID, IConfigurationElement element) {
        ArrayList<PHPPreferencePageBlocksFactory> list = (ArrayList<PHPPreferencePageBlocksFactory>)dictionary.get(preferencesPageID);
        if (list == null) {
            list = new ArrayList<PHPPreferencePageBlocksFactory>(5);
        }
        list.add(new PHPPreferencePageBlocksFactory(element));
        dictionary.put(preferencesPageID, list);
    }

    private Dictionary getPageBlocks() {
        return this.pageBlocks;
    }

    private static PHPPreferencePageBlocksRegistry getInstance() {
        if (instance == null) {
            instance = new PHPPreferencePageBlocksRegistry();
        }
        return instance;
    }

    public static IPHPPreferencePageBlock[] getPHPPreferencePageBlock(String pageId) throws Exception {
        List addonFactories = (List)PHPPreferencePageBlocksRegistry.getInstance().getPageBlocks().get(pageId);
        IPHPPreferencePageBlock[] addons = PHPPreferencePageBlocksRegistry.getBlocks(addonFactories);
        Arrays.sort(addons, pageBlockComparator);
        return addons;
    }

    private static IPHPPreferencePageBlock[] getBlocks(List addonFactories) {
        if (addonFactories == null) {
            return new IPHPPreferencePageBlock[0];
        }
        IPHPPreferencePageBlock[] addons = new IPHPPreferencePageBlock[addonFactories.size()];
        int i = 0;
        while (i < addons.length) {
            addons[i] = ((PHPPreferencePageBlocksFactory)addonFactories.get(i)).createPHPPreferencePageBlock();
            ++i;
        }
        return addons;
    }

    class PHPPreferencePageBlocksFactory {
        private IConfigurationElement element;
        private IPHPPreferencePageBlock preferencesPageBlock;

        public PHPPreferencePageBlocksFactory(IConfigurationElement element) {
            this.element = element;
        }

        public IPHPPreferencePageBlock createPHPPreferencePageBlock() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(String.valueOf(PHPUIMessages.getString("PHPPreferencePageBlocksRegistry.0")) + "org.eclipse.php.ui" + "." + PHPPreferencePageBlocksRegistry.EXTENSION_POINT_NAME){

                public void run() throws Exception {
                    PHPPreferencePageBlocksFactory.this.preferencesPageBlock = (IPHPPreferencePageBlock)PHPPreferencePageBlocksFactory.this.element.createExecutableExtension(PHPPreferencePageBlocksRegistry.CLASS_ATTRIBUTE);
                    PHPPreferencePageBlocksFactory.this.preferencesPageBlock.setComparableName(PHPPreferencePageBlocksFactory.this.element.getAttribute(PHPPreferencePageBlocksRegistry.NAME_ATTRIBUTE));
                }
            });
            return this.preferencesPageBlock;
        }
    }

    static class PageBlockComparator
    implements Comparator {
        PageBlockComparator() {
        }

        public int compare(Object o1, Object o2) {
            IPHPPreferencePageBlock firstBlock = (IPHPPreferencePageBlock)o1;
            IPHPPreferencePageBlock secondBlock = (IPHPPreferencePageBlock)o2;
            if (firstBlock != null && secondBlock != null) {
                boolean firstIsPDT = firstBlock.getClass().getName().startsWith(PHPPreferencePageBlocksRegistry.PDT_PREFIX);
                boolean secondIsPDT = secondBlock.getClass().getName().startsWith(PHPPreferencePageBlocksRegistry.PDT_PREFIX);
                if (firstIsPDT) {
                    if (!secondIsPDT) {
                        return -1;
                    }
                } else if (secondIsPDT) {
                    return 1;
                }
                return firstBlock.getComparableName().compareTo(secondBlock.getComparableName());
            }
            if (firstBlock == null) {
                return secondBlock == null ? 0 : -1;
            }
            return 1;
        }
    }
}

