/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.BuildpathDetector;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.ui.wizards.CapabilityConfigurationPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.PHPIncludePathsBlock;
import org.eclipse.php.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.php.internal.ui.wizards.IPHPProjectCreateWizardPage;
import org.eclipse.php.internal.ui.wizards.PHPBuildpathDetector;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardFirstPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.web.core.internal.project.JsWebNature;

public class PHPProjectWizardSecondPage
extends CapabilityConfigurationPage
implements IPHPProjectCreateWizardPage {
    private static final String FILENAME_PROJECT = ".project";
    private static final String FILENAME_BUILDPATH = ".buildpath";
    protected final PHPProjectWizardFirstPage fFirstPage;
    private URI fCurrProjectLocation;
    protected IProject fCurrProject;
    private boolean fKeepContent;
    private File fDotProjectBackup;
    private File fDotBuildpathBackup;
    private Boolean fIsAutobuild;

    public PHPProjectWizardSecondPage(PHPProjectWizardFirstPage mainPage) {
        this.fFirstPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = false;
        this.fDotProjectBackup = null;
        this.fDotBuildpathBackup = null;
        this.fIsAutobuild = null;
    }

    public PHPProjectWizardFirstPage getFirstPage() {
        return this.fFirstPage;
    }

    protected boolean useNewSourcePage() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (!visible && currentPage != null && currentPage instanceof PHPProjectWizardFirstPage) {
            IWizardPage nextPage = currentPage.getNextPage();
            if (nextPage instanceof PHPProjectWizardSecondPage) {
                ((PHPProjectWizardSecondPage)nextPage).removeProject();
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private void changeToNewProject() {
        this.fKeepContent = this.fFirstPage.getDetect();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (PHPProjectWizardSecondPage.this.fIsAutobuild == null) {
                            PHPProjectWizardSecondPage.this.fIsAutobuild = CoreUtility.enableAutoBuild((boolean)false);
                        }
                        PHPProjectWizardSecondPage.this.updateProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.ScriptProjectWizardSecondPage_error_title;
            String message = NewWizardMessages.ScriptProjectWizardSecondPage_error_message;
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.getProjectLocationURI();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_initialize, 70);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI realLocation = this.fCurrProjectLocation;
            if (this.fCurrProjectLocation == null) {
                try {
                    URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    realLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(this.fCurrProject.getName()).toString(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Assert.isTrue((boolean)false, (String)"Can't happen");
                }
            }
            this.rememberExistingFiles(realLocation);
            PHPProjectWizardSecondPage.createProject((IProject)this.fCurrProject, (URI)this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            IBuildpathEntry[] buildpathEntries = null;
            IncludePath[] includepathEntries = null;
            if (this.fFirstPage.getDetect()) {
                includepathEntries = this.setProjectBaseIncludepath();
                if (!this.fCurrProject.getFile(FILENAME_BUILDPATH).exists()) {
                    IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)this.getScriptNature());
                    BuildpathDetector detector = this.createBuildpathDetector(monitor, toolkit);
                    buildpathEntries = detector.getBuildpath();
                } else {
                    monitor.worked(20);
                }
            } else if (this.fFirstPage.hasPhpSourceFolder()) {
                IFolder folder;
                IPreferenceStore store = this.getPreferenceStore();
                Path srcPath = new Path(store.getString("com.xore.dltk.ui.wizards.srcFoldersSrcName"));
                Path binPath = new Path(store.getString("org.eclipse.php.ui.wizards.srcBinFoldersBinName"));
                if (srcPath.segmentCount() > 0) {
                    folder = this.fCurrProject.getFolder((IPath)srcPath);
                    CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                } else {
                    monitor.worked(10);
                }
                if (binPath.segmentCount() > 0) {
                    folder = this.fCurrProject.getFolder((IPath)binPath);
                    CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                } else {
                    monitor.worked(10);
                }
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
                cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
                buildpathEntries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
                includepathEntries = new IncludePath[]{new IncludePath((Object)this.fCurrProject.getFolder((IPath)srcPath), this.fCurrProject)};
            } else {
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
                cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath));
                buildpathEntries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
                includepathEntries = this.setProjectBaseIncludepath();
                monitor.worked(20);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(DLTKCore.create((IProject)this.fCurrProject), buildpathEntries, false);
            this.configureScriptProject((IProgressMonitor)new SubProgressMonitor(monitor, 30));
            this.addJsSupport(monitor);
            this.setPhpLangOptions();
            this.getScriptProject().setRawBuildpath(buildpathEntries, (IProgressMonitor)new NullProgressMonitor());
            LanguageModelInitializer.enableLanguageModelFor((IScriptProject)this.getScriptProject());
            this.getBuildPathsBlock().init(this.getScriptProject(), new IBuildpathEntry[0]);
            IncludePathManager.getInstance().setIncludePath(this.fCurrProject, includepathEntries);
        }
        finally {
            monitor.done();
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setHelpContext(this.getControl());
    }

    protected void setHelpContext(Control control) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.php.help.adding_elements_to_a_project_s_include_path");
    }

    private IncludePath[] setProjectBaseIncludepath() {
        return new IncludePath[]{new IncludePath((Object)this.fCurrProject, this.fCurrProject)};
    }

    protected void addJsSupport(IProgressMonitor monitor) throws CoreException, JavaScriptModelException {
        if (this.fFirstPage.fJavaScriptSupportGroup.shouldSupportJavaScript()) {
            JsWebNature jsWebNature = new JsWebNature(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            jsWebNature.configure();
            ArrayList<IIncludePathEntry> newJsClassPathsList = new ArrayList<IIncludePathEntry>();
            newJsClassPathsList.addAll((Collection)Arrays.asList(jsWebNature.getJavaProject().getRawIncludepath()));
            IPath[] exclusionPatterns = ClasspathEntry.EXCLUDE_NONE;
            if (this.fFirstPage.hasPhpSourceFolder()) {
                exclusionPatterns = new IPath[]{new Path(this.getPreferenceStore().getString("com.xore.dltk.ui.wizards.srcFoldersSrcName"))};
            }
            newJsClassPathsList.add(JavaScriptCore.newSourceEntry((IPath)this.fCurrProject.getFullPath(), (IPath[])exclusionPatterns));
            jsWebNature.getJavaProject().setRawIncludepath(newJsClassPathsList.toArray(new IIncludePathEntry[0]), monitor);
        }
    }

    public void configureScriptProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int nSteps = 6;
        monitor.beginTask(NewWizardMessages.ScriptCapabilityConfigurationPage_op_desc_Script, nSteps);
        try {
            try {
                IProject project = this.getScriptProject().getProject();
                BuildpathsBlock.addScriptNature((IProject)project, (IProgressMonitor)new SubProgressMonitor(monitor, 1), (String)this.getScriptNature());
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected BuildpathDetector createBuildpathDetector(IProgressMonitor monitor, IDLTKLanguageToolkit toolkit) throws CoreException {
        PHPBuildpathDetector detector = new PHPBuildpathDetector(this.fCurrProject, toolkit);
        detector.detectBuildpath((IProgressMonitor)new SubProgressMonitor(monitor, 20));
        return detector;
    }

    protected String getScriptNature() {
        return "org.eclipse.php.core.PHPNature";
    }

    protected IPreferenceStore getPreferenceStore() {
        return PHPUiPlugin.getDefault().getPreferenceStore();
    }

    private URI getProjectLocationURI() throws CoreException {
        if (this.fFirstPage.isInWorkspace()) {
            return null;
        }
        return this.fFirstPage.getLocationURI();
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotBuildpathBackup = null;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists()) {
            IFileStore buildpathFile;
            IFileStore projectFile = file.getChild(FILENAME_PROJECT);
            if (projectFile.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(projectFile, "project-desc");
            }
            if ((buildpathFile = file.getChild(FILENAME_BUILDPATH)).fetchInfo().exists()) {
                this.fDotBuildpathBackup = this.createBackup(buildpathFile, "buildpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        int ticks = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotBuildpathBackup != null ? 1 : 0)) * 2;
        monitor.beginTask("", ticks);
        try {
            if (this.fDotProjectBackup != null) {
                IFileStore projectFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_PROJECT);
                projectFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.copyFile(this.fDotProjectBackup, projectFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.dltk.ui", 4, NewWizardMessages.ScriptProjectWizardSecondPage_problem_restore_project, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        try {
            if (this.fDotBuildpathBackup != null) {
                IFileStore buildpathFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_BUILDPATH);
                buildpathFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.copyFile(this.fDotBuildpathBackup, buildpathFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.dltk.ui", 4, NewWizardMessages.ScriptProjectWizardSecondPage_problem_restore_buildpath, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, ".bak");
            this.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.dltk.ui", 4, Messages.format((String)NewWizardMessages.ScriptProjectWizardSecondPage_problem_backup, (Object)name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void copyFile(IFileStore source, File target) throws IOException, CoreException {
        InputStream is = source.openInputStream(0, null);
        FileOutputStream os = new FileOutputStream(target);
        this.copyFile(is, os);
    }

    private void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream is = new FileInputStream(source);
        OutputStream os = target.openOutputStream(0, monitor);
        this.copyFile(is, os);
    }

    private void copyFile(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                is.close();
            }
            finally {
                os.close();
            }
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            IWizardPage currentPage;
            monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_create, 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (!this.fKeepContent && DLTKCore.DEBUG) {
                System.err.println("Add compiler compilance options here...");
            }
            if (!((currentPage = this.getContainer().getCurrentPage()) instanceof PHPProjectWizardFirstPage)) {
                this.getBuildPathsBlock().configureScriptProject(monitor);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild != null) {
                CoreUtility.enableAutoBuild((boolean)this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
    }

    protected void setPhpLangOptions() {
        boolean useASPTags = this.fFirstPage.fVersionGroup.fConfigurationBlock.getUseAspTagsValue();
        String phpVersion = this.fFirstPage.fVersionGroup.fConfigurationBlock.getPHPVersionValue();
        UseAspTagsHandler.setUseAspTagsAsPhp((boolean)useASPTags, (IProject)this.fCurrProject);
        PhpVersionProjectPropertyHandler.setVersion((String)phpVersion, (IProject)this.fCurrProject);
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                PHPProjectWizardSecondPage.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.ScriptProjectWizardSecondPage_error_remove_title;
            String message = NewWizardMessages.ScriptProjectWizardSecondPage_error_remove_message;
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
        }
        catch (InterruptedException interruptedException) {}
    }

    final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor;
        boolean bl = noProgressMonitor = this.fCurrProjectLocation == null;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_remove, 3);
        try {
            try {
                try {
                    this.fCurrProject.getLocationURI();
                    boolean removeContent = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    this.fCurrProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                }
                finally {
                    CoreUtility.enableAutoBuild((boolean)this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
        }
    }

    public void performCancel() {
        this.removeProject();
    }

    public IProject getCurrProject() {
        return this.fCurrProject;
    }

    protected BuildpathsBlock createBuildpathBlock(IStatusChangeListener listener) {
        return new PHPIncludePathsBlock(new BusyIndicatorRunnableContext(), listener, 0, this.useNewSourcePage(), null);
    }

    public void initPage() {
        this.changeToNewProject();
    }
}

