/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.LSApplicationParameters;
import org.eclipse.swt.internal.carbon.OS;

public final class Program {
    String name;
    byte[] fsRef;
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";
    static final String PREFIX_FILE = "file://";

    Program() {
    }

    public static Program findProgram(String extension) {
        char[] chars;
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            chars = new char[extension.length()];
            extension.getChars(0, chars.length, chars, 0);
        } else {
            chars = new char[extension.length() - 1];
            extension.getChars(1, extension.length(), chars, 0);
        }
        int ext = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        Program program = null;
        if (ext != 0) {
            byte[] fsRef = new byte[80];
            if (OS.LSGetApplicationForInfo(0, 0, ext, -1, fsRef, null) == 0) {
                program = Program.getProgram(fsRef);
            }
            OS.CFRelease(ext);
        }
        return program;
    }

    public static String[] getExtensions() {
        return new String[]{".txt", ".rtf", ".html", ".htm", ".xml", ".c", ".m", ".cp", ".cpp", ".c++", ".cc", ".cxx", ".mm", ".h", ".hpp", ".h++", ".hxx", ".java", ".jav", ".s", ".r", ".defs", ".mig", ".exp", ".js", ".jscript", ".javascript", ".sh", ".command", ".csh", ".pl", ".pm", ".py", ".rb", ".rbw", ".php", ".php3", ".php4", ".ph3", ".ph4", ".phtml", ".jnlp", ".applescript", ".scpt", ".o", ".exe", ".dll", ".class", ".jar", ".qtz", ".gtar", ".tar", ".gz", ".gzip", ".tgz", ".hqx", ".bin", ".vcf", ".vcard", ".jpg", ".jpeg", ".jp2", ".tif", ".tiff", ".pic", ".pct", ".pict", ".pntg", ".png", ".xbm", ".qif", ".qtif", ".icns", ".mov", ".qt", ".avi", ".vfw", ".mpg", ".mpeg", ".m75", ".m15", ".mp4", ".3gp", ".3gpp", ".3g2", ".3gp2", ".mp3", ".m4a", ".m4p", ".m4b", ".au", ".ulw", ".snd", ".aifc", ".aiff", ".aif", ".caf", ".bundle", ".app", ".plugin", ".mdimporter", ".wdgt", ".cpio", ".zip", ".framework", ".rtfd", ".dfont", ".otf", ".ttf", ".ttc", ".suit", ".pfb", ".pfa", ".icc", ".icm", ".pf", ".pdf", ".ps", ".eps", ".psd", ".ai", ".gif", ".bmp", ".ico", ".doc", ".xls", ".ppt", ".wav", ".wave", ".asf", ".wm", ".wmv", ".wmp", ".wma", ".asx", ".wmx", ".wvx", ".wax", ".key", ".kth", ".tga", ".sgi", ".exr", ".fpx", ".jfx", ".efx", ".sd2", ".rm", ".ram", ".ra", ".smil", ".sit", ".sitx", ".plist", ".nib", ".lproj", ".iPhoto", ".iChat", ".chat", ".rmf", ".xfdf", ".fdf", ".game", ".pgn", ".ics", ".vcs", ".aplmodel", ".icbu", ".icalevent", ".icaltodo", ".mailhold", ".mbox", ".imapmbox", ".emlx", ".mailextract", ".sherlock", ".tpl", ".prefPane", ".sliderSaver", ".saver", ".log", ".gcx"};
    }

    public static Program[] getPrograms() {
        Hashtable<String, Program> bundles = new Hashtable<String, Program>();
        String[] extensions = Program.getExtensions();
        byte[] fsRef = new byte[80];
        int i = 0;
        while (i < extensions.length) {
            String extension = extensions[i];
            char[] chars = new char[extension.length() - 1];
            extension.getChars(1, extension.length(), chars, 0);
            int ext = OS.CFStringCreateWithCharacters(0, chars, chars.length);
            if (ext != 0) {
                int utis;
                Program program;
                if (OS.LSGetApplicationForInfo(0, 0, ext, -1, fsRef, null) == 0 && (program = Program.getProgram(fsRef)) != null && bundles.get(program.getName()) == null) {
                    bundles.put(program.getName(), program);
                    fsRef = new byte[80];
                }
                if (OS.VERSION >= 4160 && (utis = OS.UTTypeCreateAllIdentifiersForTag(OS.kUTTagClassFilenameExtension(), ext, 0)) != 0) {
                    int utiCount = OS.CFArrayGetCount(utis);
                    int j = 0;
                    while (j < utiCount) {
                        int apps;
                        int uti = OS.CFArrayGetValueAtIndex(utis, j);
                        if (uti != 0 && (apps = OS.LSCopyAllRoleHandlersForContentType(uti, -1)) != 0) {
                            int appCount = OS.CFArrayGetCount(apps);
                            int k = 0;
                            while (k < appCount) {
                                Program program2;
                                int app = OS.CFArrayGetValueAtIndex(apps, k);
                                if (app != 0 && OS.LSFindApplicationForInfo(0, app, 0, fsRef, null) == 0 && (program2 = Program.getProgram(fsRef)) != null && bundles.get(program2.getName()) == null) {
                                    bundles.put(program2.getName(), program2);
                                    fsRef = new byte[80];
                                }
                                ++k;
                            }
                            OS.CFRelease(apps);
                        }
                        ++j;
                    }
                    OS.CFRelease(utis);
                }
                OS.CFRelease(ext);
            }
            ++i;
        }
        int count = 0;
        Program[] programs = new Program[bundles.size()];
        Enumeration values = bundles.elements();
        while (values.hasMoreElements()) {
            programs[count++] = (Program)values.nextElement();
        }
        return programs;
    }

    public static boolean launch(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        int rc = -1;
        char[] unescapedChars = new char[]{'%'};
        if (fileName.indexOf(58) == -1) {
            fileName = PREFIX_FILE + fileName;
        } else {
            String lowercaseName = fileName.toLowerCase();
            if (lowercaseName.startsWith(PREFIX_HTTP) || lowercaseName.startsWith(PREFIX_HTTPS)) {
                unescapedChars = new char[]{'%', '#'};
            }
        }
        char[] chars = new char[fileName.length()];
        fileName.getChars(0, chars.length, chars, 0);
        int str = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        if (str != 0) {
            int unescapedStr = OS.CFStringCreateWithCharacters(0, unescapedChars, unescapedChars.length);
            int escapedStr = OS.CFURLCreateStringByAddingPercentEscapes(0, str, unescapedStr, 0, 0x8000100);
            if (escapedStr != 0) {
                int url = OS.CFURLCreateWithString(0, escapedStr, 0);
                if (url != 0) {
                    rc = OS.LSOpenCFURLRef(url, null);
                    OS.CFRelease(url);
                }
                OS.CFRelease(escapedStr);
            }
            if (unescapedStr != 0) {
                OS.CFRelease(unescapedStr);
            }
            OS.CFRelease(str);
        }
        return rc == 0;
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        if (OS.VERSION < 4160) {
            return Program.launch(fileName);
        }
        int rc = -1;
        int fsRefPtr = OS.NewPtr(this.fsRef.length);
        if (fsRefPtr != 0) {
            OS.memmove(fsRefPtr, this.fsRef, this.fsRef.length);
            LSApplicationParameters params = new LSApplicationParameters();
            params.version = 0;
            params.flags = 0;
            params.application = fsRefPtr;
            if (fileName.length() == 0) {
                rc = OS.LSOpenApplication(params, null);
            } else {
                char[] unescapedChars = new char[]{'%'};
                if (fileName.indexOf(58) == -1) {
                    fileName = PREFIX_FILE + fileName;
                } else {
                    String lowercaseName = fileName.toLowerCase();
                    if (lowercaseName.startsWith(PREFIX_HTTP) || lowercaseName.startsWith(PREFIX_HTTPS)) {
                        unescapedChars = new char[]{'%', '#'};
                    }
                }
                char[] chars = new char[fileName.length()];
                fileName.getChars(0, chars.length, chars, 0);
                int str = OS.CFStringCreateWithCharacters(0, chars, chars.length);
                if (str != 0) {
                    int unescapedStr = OS.CFStringCreateWithCharacters(0, unescapedChars, unescapedChars.length);
                    int escapedStr = OS.CFURLCreateStringByAddingPercentEscapes(0, str, unescapedStr, 0, 0x8000100);
                    if (escapedStr != 0) {
                        int urls = OS.CFArrayCreateMutable(0, 1, 0);
                        if (urls != 0) {
                            int url = OS.CFURLCreateWithString(0, escapedStr, 0);
                            if (url != 0) {
                                OS.CFArrayAppendValue(urls, url);
                                rc = OS.LSOpenURLsWithRole(urls, -1, 0, params, null, 0);
                            }
                            OS.CFRelease(urls);
                        }
                        OS.CFRelease(escapedStr);
                    }
                    if (unescapedStr != 0) {
                        OS.CFRelease(unescapedStr);
                    }
                    OS.CFRelease(str);
                }
            }
            OS.DisposePtr(fsRefPtr);
        }
        return rc == 0;
    }

    ImageData createImageFromFamily(int family, int type, int maskType, int width, int height) {
        int dataHandle = OS.NewHandle(0);
        int result = OS.GetIconFamilyData(family, type, dataHandle);
        if (result != 0) {
            OS.DisposeHandle(dataHandle);
            return null;
        }
        int maskHandle = OS.NewHandle(0);
        result = OS.GetIconFamilyData(family, maskType, maskHandle);
        if (result != 0) {
            OS.DisposeHandle(maskHandle);
            OS.DisposeHandle(dataHandle);
            return null;
        }
        int dataSize = OS.GetHandleSize(dataHandle);
        OS.HLock(dataHandle);
        OS.HLock(maskHandle);
        int[] iconPtr = new int[1];
        int[] maskPtr = new int[1];
        OS.memmove(iconPtr, dataHandle, 4);
        OS.memmove(maskPtr, maskHandle, 4);
        byte[] data = new byte[dataSize];
        OS.memmove(data, iconPtr[0], dataSize);
        byte[] alphaData = new byte[width * height];
        OS.memmove(alphaData, maskPtr[0], alphaData.length);
        OS.HUnlock(maskHandle);
        OS.HUnlock(dataHandle);
        OS.DisposeHandle(maskHandle);
        OS.DisposeHandle(dataHandle);
        ImageData image = new ImageData(width, height, 32, new PaletteData(0xFF0000, 65280, 255), 4, data);
        image.alphaData = alphaData;
        return image;
    }

    public ImageData getImageData() {
        int[] iconRef = new int[1];
        OS.GetIconRefFromFileInfo(this.fsRef, 0, null, 0, 0, 0, iconRef, null);
        int[] family = new int[1];
        int rc = OS.IconRefToIconFamily(iconRef[0], -1, family);
        OS.ReleaseIconRef(iconRef[0]);
        if (rc != 0) {
            return null;
        }
        ImageData result = this.createImageFromFamily(family[0], 1769157426, 1933077867, 16, 16);
        OS.DisposeHandle(family[0]);
        if (result == null) {
            RGB[] rgbs = new RGB[]{new RGB(255, 255, 255), new RGB(95, 95, 95), new RGB(128, 128, 128), new RGB(192, 192, 192), new RGB(223, 223, 191), new RGB(255, 223, 159), new RGB(0, 0, 0)};
            result = new ImageData(16, 16, 4, new PaletteData(rgbs));
            result.transparentPixel = 6;
            String[] p = new String[]{"CCCCCCCCGGG", "CFAAAAACBGG", "CAAAAAACFBG", "CAAAAAACBBB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CDDDDDDDDDB", "CBBBBBBBBBB"};
            int y = 0;
            while (y < p.length) {
                int x = 0;
                while (x < 11) {
                    result.setPixel(x + 3, y + 1, p[y].charAt(x) - 65);
                    ++x;
                }
                ++y;
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    static Program getProgram(byte[] fsRef) {
        String name = "";
        int[] namePtr = new int[1];
        OS.LSCopyDisplayNameForRef(fsRef, namePtr);
        if (namePtr[0] != 0) {
            int length = OS.CFStringGetLength(namePtr[0]);
            if (length != 0) {
                char[] buffer = new char[length];
                CFRange range = new CFRange();
                range.length = length;
                OS.CFStringGetCharacters(namePtr[0], range, buffer);
                name = new String(buffer);
            }
            OS.CFRelease(namePtr[0]);
        }
        Program program = new Program();
        program.fsRef = fsRef;
        program.name = name;
        return program;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.name.equals(program.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

