/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.task;

import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.compiler.task.AbstractTodoTaskPreferences;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.compiler.task.TaskTagUtils;

public class TodoTaskPreferences
extends AbstractTodoTaskPreferences
implements ITodoTaskPreferences {
    private Preferences store;

    public TodoTaskPreferences(Preferences store) {
        this.store = store;
    }

    public boolean isEnabled() {
        return this.store.getBoolean("org.eclipse.dltk.coretasks.enabled");
    }

    public boolean isCaseSensitive() {
        return this.store.getBoolean("org.eclipse.dltk.coretasks.case_sensitive");
    }

    protected String getRawTaskTags() {
        return this.store.getString("org.eclipse.dltk.coretasks.tags");
    }

    public void setTaskTags(List elements) {
        this.store.setValue("org.eclipse.dltk.coretasks.tags", TaskTagUtils.encodeTaskTags(elements));
    }

    public static void initializeDefaultValues(Preferences store) {
        TaskTagUtils.initializeDefaultValues(store);
    }
}

