/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.mixin.MixinBuiltinProjectFragmentRequest;
import org.eclipse.dltk.internal.core.mixin.MixinExternalProjectFragmentRequest;
import org.eclipse.dltk.internal.core.mixin.MixinIndexRequest;
import org.eclipse.dltk.internal.core.mixin.MixinSourceModulesRequest;

class MixinProjectRequest
extends MixinIndexRequest {
    private final IScriptProject project;
    private final boolean indexExternal;

    public MixinProjectRequest(IScriptProject project, boolean indexExternal) {
        this.project = project;
        this.indexExternal = indexExternal;
    }

    protected String getName() {
        return this.project.getElementName();
    }

    protected void run() throws CoreException {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this.project);
        IProjectFragment[] fragments = this.project.getProjectFragments();
        IndexManager manager = ModelManager.getModelManager().getIndexManager();
        SourceModuleCollector moduleCollector = new SourceModuleCollector();
        int i = 0;
        while (i < fragments.length) {
            if (this.isCancelled) {
                return;
            }
            IProjectFragment fragment = fragments[i];
            if (fragment instanceof BuiltinProjectFragment) {
                if (this.indexExternal) {
                    manager.request(new MixinBuiltinProjectFragmentRequest(fragment, toolkit, ((BuiltinProjectFragment)fragment).lastModified()));
                }
            } else if (fragment instanceof ExternalProjectFragment) {
                if (this.indexExternal) {
                    manager.request(new MixinExternalProjectFragmentRequest(fragment, toolkit));
                }
            } else {
                fragment.accept(moduleCollector);
            }
            ++i;
        }
        manager.request(new MixinSourceModulesRequest(this.project, toolkit, moduleCollector.modules));
    }

    public boolean belongsTo(String jobFamily) {
        return jobFamily.equals(this.project.getProject().getName());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MixinProjectRequest other = (MixinProjectRequest)obj;
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }

    static class SourceModuleCollector
    implements IModelElementVisitor {
        final Set modules = new HashSet();

        SourceModuleCollector() {
        }

        public boolean visit(IModelElement element) {
            if (element.getElementType() == 5) {
                this.modules.add(element);
                return false;
            }
            return true;
        }
    }
}

