/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.search.matching.DLTKSearchPattern;

public class MethodDeclarationPattern
extends DLTKSearchPattern
implements IIndexConstants {
    public char[] simpleName;
    protected static char[][] CATEGORIES = new char[][]{METHOD_DECL};

    public static char[] createIndexKey(int modifiers, char[] typeName, char[] packageName, char[][] enclosingTypeNames) {
        int typeNameLength = typeName == null ? 0 : typeName.length;
        int packageLength = packageName == null ? 0 : packageName.length;
        int enclosingNamesLength = 0;
        if (enclosingTypeNames != null) {
            int i = 0;
            int length = enclosingTypeNames.length;
            while (i < length) {
                enclosingNamesLength += enclosingTypeNames[i].length;
                if (++i >= length) continue;
                ++enclosingNamesLength;
            }
        }
        int resultLength = typeNameLength + packageLength + enclosingNamesLength + 5;
        char[] result = new char[resultLength];
        int pos = 0;
        if (typeNameLength > 0) {
            System.arraycopy(typeName, 0, result, pos, typeNameLength);
            pos += typeNameLength;
        }
        result[pos++] = 123;
        if (packageLength > 0) {
            System.arraycopy(packageName, 0, result, pos, packageLength);
            pos += packageLength;
        }
        result[pos++] = 123;
        if (enclosingTypeNames != null && enclosingNamesLength > 0) {
            int i = 0;
            int length = enclosingTypeNames.length;
            while (i < length) {
                char[] enclosingName = enclosingTypeNames[i];
                int itsLength = enclosingName.length;
                System.arraycopy(enclosingName, 0, result, pos, itsLength);
                pos += itsLength;
                if (++i >= length) continue;
                result[pos++] = 36;
            }
        }
        result[pos++] = 123;
        result[pos++] = (char)modifiers;
        result[pos] = (char)(modifiers >> 16);
        return result;
    }

    public MethodDeclarationPattern(char[] simpleName, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(matchRule, toolkit);
        this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? simpleName : CharOperation.toLowerCase(simpleName);
    }

    MethodDeclarationPattern(int matchRule, IDLTKLanguageToolkit toolkit) {
        super(8, matchRule, toolkit);
    }

    public void decodeIndexKey(char[] key) {
        int slash = CharOperation.indexOf('{', key, 0);
        this.simpleName = CharOperation.subarray(key, 0, slash);
    }

    public SearchPattern getBlankPattern() {
        return new MethodDeclarationPattern(8, this.getToolkit());
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        MethodDeclarationPattern pattern = (MethodDeclarationPattern)decodedPattern;
        return this.matchesName(this.simpleName, pattern.simpleName);
    }

    public EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.simpleName;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 1: {
                break;
            }
            case 0: {
                if (this.isCamelCase) break;
                matchRule &= 0xFFFFFFFF;
                matchRule |= 1;
                key = CharOperation.append(this.simpleName, '{');
                break;
            }
            case 2: {
                if (this.simpleName[this.simpleName.length - 1] == '*') break;
                key = CharOperation.concat(this.simpleName, ONE_STAR, '{');
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    protected StringBuffer print(StringBuffer output) {
        output.append("MethodDeclarationPattern: ");
        output.append("name<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }
}

