/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.search.matching.TypeDeclarationPattern;

public class QualifiedTypeDeclarationPattern
extends TypeDeclarationPattern
implements IIndexConstants {
    public char[] qualification;

    public QualifiedTypeDeclarationPattern(char[] qualification, char[] simpleName, char typeSuffix, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(matchRule, toolkit);
        this.qualification = this.isCaseSensitive() ? qualification : CharOperation.toLowerCase(qualification);
        this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.typeSuffix = typeSuffix;
    }

    public QualifiedTypeDeclarationPattern(char[] qualification, int qualificationMatchRule, char[] simpleName, char typeSuffix, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(qualification, simpleName, typeSuffix, matchRule, toolkit);
    }

    QualifiedTypeDeclarationPattern(int matchRule, IDLTKLanguageToolkit toolkit) {
        super(matchRule, toolkit);
    }

    public void decodeIndexKey(char[] key) {
        int start;
        int slash = CharOperation.indexOf('{', key, 0);
        this.simpleName = CharOperation.subarray(key, 0, slash);
        if (key[start = ++slash] == '{') {
            this.pkg = CharOperation.NO_CHAR;
        } else {
            slash = CharOperation.indexOf('{', key, start);
            this.pkg = internedPackageNames.add(CharOperation.subarray(key, start, slash));
        }
        this.qualification = CharOperation.NO_CHAR;
        int last = key.length - 1;
        boolean bl = this.secondary = key[last] == 'S';
        if (this.secondary) {
            last -= 2;
        }
        this.modifiers = key[last - 1] + (key[last] << 16);
        this.decodeModifiers();
        start = slash + 1;
        if (start == (last -= 2)) {
            this.enclosingTypeNames = CharOperation.NO_CHAR_CHAR;
        } else {
            int length = 0;
            int size = last - start;
            this.qualification = new char[length + size];
            System.arraycopy(this.qualification, 0, this.qualification, 0, length);
            if (last == start + 1 && key[start] == '0') {
                this.enclosingTypeNames = ONE_ZERO_CHAR;
                this.qualification[length] = 48;
            } else {
                this.enclosingTypeNames = CharOperation.splitOn('$', key, start, last);
                System.arraycopy(key, start, this.qualification, 0, size);
            }
        }
    }

    public SearchPattern getBlankPattern() {
        return new QualifiedTypeDeclarationPattern(8, this.getToolkit());
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        QualifiedTypeDeclarationPattern pattern = (QualifiedTypeDeclarationPattern)decodedPattern;
        block0 : switch (this.typeSuffix) {
            case 'C': {
                switch (pattern.typeSuffix) {
                    case 'C': {
                        break block0;
                    }
                }
                return false;
            }
            case 'A': {
                if (this.typeSuffix == pattern.typeSuffix) break;
                return false;
            }
        }
        return this.matchesName(this.simpleName, pattern.simpleName) && (this.qualification == null || pattern.matchesName(this.qualification, pattern.qualification));
    }

    protected StringBuffer print(StringBuffer output) {
        switch (this.typeSuffix) {
            case 'C': {
                output.append("ClassDeclarationPattern: qualification<");
                break;
            }
            case 'A': {
                output.append("AnnotationTypeDeclarationPattern: qualification<");
                break;
            }
            default: {
                output.append("TypeDeclarationPattern: qualification<");
            }
        }
        if (this.qualification != null) {
            output.append(this.qualification);
        } else {
            output.append("*");
        }
        output.append(">, type<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append("> ");
        return super.print(output);
    }
}

