/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.AddUnimplementedMethodsOperation;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OverrideMethodDialog;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OverrideMethodsAction
extends SelectionDispatchAction {
    private static final String DIALOG_TITLE = ActionMessages.OverrideMethodsAction_error_title;
    private CompilationUnitEditor fEditor;
    static /* synthetic */ Class class$0;

    public OverrideMethodsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public OverrideMethodsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OverrideMethodsAction_label);
        this.setDescription(ActionMessages.OverrideMethodsAction_description);
        this.setToolTipText(ActionMessages.OverrideMethodsAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.add_unimplemented_methods_action_context");
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getJavaScriptUnit() != null && !type.isInterface();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof IJavaScriptUnit;
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    private String getDialogTitle() {
        return DIALOG_TITLE;
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaScriptModelException {
        IType type;
        Object[] elements = selection.toArray();
        if (elements.length == 1 && elements[0] instanceof IType) {
            IType type2 = (IType)elements[0];
            if (type2.getJavaScriptUnit() != null && !type2.isInterface()) {
                return type2;
            }
        } else if (elements[0] instanceof IJavaScriptUnit && (type = ((IJavaScriptUnit)elements[0]).findPrimaryType()) != null && !type.isInterface()) {
            return type;
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        try {
            IType type = this.getSelectedType(selection);
            if (type == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_not_applicable);
                this.notifyResult(false);
                return;
            }
            if (!ElementValidator.check((IJavaScriptElement)type, this.getShell(), this.getDialogTitle(), false) || !ActionUtil.isEditable(this.getShell(), (IJavaScriptElement)type)) {
                this.notifyResult(false);
                return;
            }
            this.run(this.getShell(), type);
        }
        catch (CoreException exception) {
            ExceptionHandler.handle(exception, this.getShell(), this.getDialogTitle(), ActionMessages.OverrideMethodsAction_error_actionfailed);
        }
    }

    public void run(ITextSelection selection) {
        try {
            IType type = SelectionConverter.getTypeAtOffset(this.fEditor);
            if (type != null) {
                if (!ElementValidator.check((IJavaScriptElement)type, this.getShell(), this.getDialogTitle(), false) || !ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaScriptElement)type)) {
                    this.notifyResult(false);
                    return;
                }
                if (type.isAnnotation()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_annotation_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                if (type.isInterface()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_interface_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                this.run(this.getShell(), type);
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_not_applicable);
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), this.getDialogTitle(), null);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.OverrideMethodsAction_error_actionfailed);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(Shell shell, IType type) throws CoreException {
        block22: {
            IRewriteTarget target;
            IRewriteTarget iRewriteTarget;
            OverrideMethodDialog dialog = new OverrideMethodDialog(shell, this.fEditor, type, false);
            if (!dialog.hasMethodsToOverride()) {
                MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_error_nothing_found);
                this.notifyResult(false);
                return;
            }
            if (dialog.open() != 0) {
                this.notifyResult(false);
                return;
            }
            Object[] selected = dialog.getResult();
            if (selected == null) {
                this.notifyResult(false);
                return;
            }
            ArrayList<Object> methods = new ArrayList<Object>();
            int i = 0;
            while (i < selected.length) {
                Object elem = selected[i];
                if (elem instanceof IFunctionBinding) {
                    methods.add(elem);
                }
                ++i;
            }
            IFunctionBinding[] methodToOverride = methods.toArray(new IFunctionBinding[methods.size()]);
            IEditorPart editor = JavaScriptUI.openInEditor((IJavaScriptElement)type.getJavaScriptUnit());
            if (editor != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iRewriteTarget = (IRewriteTarget)editor.getAdapter((Class)clazz);
            } else {
                iRewriteTarget = target = null;
            }
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                try {
                    JavaScriptUnit astRoot = dialog.getCompilationUnit();
                    ITypeBinding typeBinding = ASTNodes.getTypeBinding(astRoot, type);
                    int insertPos = dialog.getInsertOffset();
                    AddUnimplementedMethodsOperation operation = (AddUnimplementedMethodsOperation)OverrideMethodsAction.createRunnable(astRoot, typeBinding, methodToOverride, insertPos, dialog.getGenerateComment());
                    Object context = JavaScriptPlugin.getActiveWorkbenchWindow();
                    if (context == null) {
                        context = new BusyIndicatorRunnableContext();
                    }
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation, operation.getSchedulingRule()), operation.getSchedulingRule());
                    String[] created = operation.getCreatedMethods();
                    if (created == null || created.length == 0) {
                        MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_error_nothing_found);
                    }
                }
                catch (InvocationTargetException exception) {
                    ExceptionHandler.handle(exception, shell, this.getDialogTitle(), null);
                }
                catch (InterruptedException interruptedException) {}
                Object var15_19 = null;
                if (target == null) break block22;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (target != null) {
                    target.endCompoundChange();
                }
                throw throwable;
            }
            target.endCompoundChange();
        }
        this.notifyResult(true);
    }

    public static IWorkspaceRunnable createRunnable(JavaScriptUnit astRoot, ITypeBinding type, IFunctionBinding[] methodToOverride, int insertPos, boolean createComments) {
        AddUnimplementedMethodsOperation operation = new AddUnimplementedMethodsOperation(astRoot, type, methodToOverride, insertPos, true, true, false);
        operation.setCreateComments(createComments);
        return operation;
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaScriptModelException exception) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)exception))) {
                JavaScriptPlugin.log(exception);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }
}

