/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;

class Binding {
    private final Set rootPatterns = new HashSet();
    private final Set includePatterns = new HashSet();
    private final Set excludePatterns = new HashSet();
    private final String TAG_EXTENSION;
    private final Map knownIds = new HashMap();
    private final Map knownRootIds = new HashMap();

    protected Binding(String tagExtension) {
        this.TAG_EXTENSION = tagExtension;
    }

    boolean isVisibleExtension(String anExtensionId) {
        Pattern pattern;
        if (this.knownIds.containsKey(anExtensionId)) {
            return (Boolean)this.knownIds.get(anExtensionId);
        }
        Iterator itr = this.includePatterns.iterator();
        while (itr.hasNext()) {
            pattern = (Pattern)itr.next();
            if (!pattern.matcher(anExtensionId).matches()) continue;
            this.knownIds.put(anExtensionId, Boolean.TRUE);
            return true;
        }
        itr = this.excludePatterns.iterator();
        while (itr.hasNext()) {
            pattern = (Pattern)itr.next();
            if (!pattern.matcher(anExtensionId).matches()) continue;
            this.knownIds.put(anExtensionId, Boolean.FALSE);
            return false;
        }
        this.knownIds.put(anExtensionId, Boolean.FALSE);
        return false;
    }

    boolean isRootExtension(String anExtensionId) {
        if (this.rootPatterns.size() == 0) {
            return false;
        }
        if (this.knownRootIds.containsKey(anExtensionId)) {
            return (Boolean)this.knownRootIds.get(anExtensionId);
        }
        Pattern pattern = null;
        Iterator itr = this.rootPatterns.iterator();
        while (itr.hasNext()) {
            pattern = (Pattern)itr.next();
            if (!pattern.matcher(anExtensionId).matches()) continue;
            this.knownRootIds.put(anExtensionId, Boolean.TRUE);
            return true;
        }
        this.knownRootIds.put(anExtensionId, Boolean.FALSE);
        return false;
    }

    boolean hasOverriddenRootExtensions() {
        return this.rootPatterns.size() > 0;
    }

    void consumeIncludes(IConfigurationElement element, boolean toRespectRoots) {
        Assert.isTrue((boolean)"includes".equals(element.getName()));
        IConfigurationElement[] contentExtensionPatterns = element.getChildren(this.TAG_EXTENSION);
        String isRootString = null;
        boolean isRoot = false;
        String patternString = null;
        Pattern compiledPattern = null;
        int i = 0;
        while (i < contentExtensionPatterns.length) {
            if (toRespectRoots) {
                isRootString = contentExtensionPatterns[i].getAttribute("isRoot");
                boolean bl = isRoot = isRootString != null ? Boolean.valueOf(isRootString.trim()) : false;
            }
            if ((patternString = contentExtensionPatterns[i].getAttribute("pattern")) == null) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new Object[]{"pattern", element.getDeclaringExtension().getUniqueIdentifier(), element.getDeclaringExtension().getNamespaceIdentifier()}), null);
            } else {
                compiledPattern = Pattern.compile(patternString);
                this.includePatterns.add(compiledPattern);
                this.knownIds.clear();
                if (toRespectRoots && isRoot) {
                    this.rootPatterns.add(compiledPattern);
                }
            }
            ++i;
        }
    }

    void consumeExcludes(IConfigurationElement element) {
        Assert.isTrue((boolean)"excludes".equals(element.getName()));
        IConfigurationElement[] contentExtensionPatterns = element.getChildren(this.TAG_EXTENSION);
        String patternString = null;
        Pattern compiledPattern = null;
        int i = 0;
        while (i < contentExtensionPatterns.length) {
            patternString = contentExtensionPatterns[i].getAttribute("pattern");
            if (patternString == null) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new Object[]{"pattern", element.getDeclaringExtension().getUniqueIdentifier(), element.getDeclaringExtension().getNamespaceIdentifier()}), null);
            } else {
                compiledPattern = Pattern.compile(patternString);
                this.excludePatterns.add(compiledPattern);
                this.knownIds.clear();
            }
            ++i;
        }
    }
}

