/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPExecutableDebuggerInitializer {
    protected ILaunch launch;

    public PHPExecutableDebuggerInitializer(ILaunch launch) throws IOException {
        this.launch = launch;
    }

    public void initializeDebug(String phpExe, String fileName, String workingDir, String query) {
        this.initializeDebug(phpExe, fileName, workingDir, query, null, null);
    }

    public void initializeDebug(String phpExe, String fileName, String workingDir, String query, Map<String, String> envVariables, String phpIniLocation) {
        try {
            PHPexeItem[] items;
            File phpExeFile = new File(phpExe);
            String phpConfigDir = phpExeFile.getParent();
            if (phpIniLocation != null && !phpIniLocation.equals("")) {
                phpConfigDir = new File(phpIniLocation).getParent();
            }
            String sapiType = null;
            PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getAllItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem item = pHPexeItemArray[n2];
                if (item.getExecutable().equals(phpExeFile)) {
                    sapiType = item.getSapiType();
                    break;
                }
                ++n2;
            }
            String[] args = PHPLaunchUtilities.getProgramArguments(this.launch.getLaunchConfiguration());
            Map<String, String> additionalLaunchEnvironment = PHPLaunchUtilities.getPHPCGILaunchEnvironment(fileName, query, phpConfigDir, phpExeFile.getParent(), (String[])(sapiType == "CGI" ? args : null));
            if (envVariables == null) {
                envVariables = additionalLaunchEnvironment;
            } else {
                additionalLaunchEnvironment.putAll(envVariables);
                envVariables = additionalLaunchEnvironment;
            }
            String[] environmetVars = PHPLaunchUtilities.getEnvironment(this.launch.getLaunchConfiguration(), this.asAttributesArray(envVariables));
            String[] phpCmdArray = PHPLaunchUtilities.getCommandLine(this.launch.getLaunchConfiguration(), phpExe, phpConfigDir, fileName, (String[])(sapiType == "CLI" ? args : null));
            PHPexes.changePermissions(new File(phpCmdArray[0]));
            File workingDirFile = new File(workingDir);
            Process p = workingDirFile.exists() ? Runtime.getRuntime().exec(phpCmdArray, environmetVars, workingDirFile) : Runtime.getRuntime().exec(phpCmdArray, environmetVars);
            new Thread(new ProcessCrashDetector(p)).start();
            ProcessOutputReader reader = new ProcessOutputReader(p);
            new Thread(reader).start();
        }
        catch (Exception e) {
            final Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                public void run() {
                    String message = e.getLocalizedMessage();
                    if (message != null) {
                        message = message.replaceFirst(String.valueOf(e.getClass().getName()) + ": ", "");
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)"Error", (String)NLS.bind((String)"Error running PHP executable:\n\n{0}", (Object)message));
                    }
                }
            });
            DebugPlugin.log((Throwable)e);
        }
    }

    private String[] asAttributesArray(Map<String, String> attributesMap) {
        String[] attributes = new String[attributesMap.size()];
        int index = 0;
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            attributes[index++] = String.valueOf(entry.getKey()) + '=' + entry.getValue();
        }
        return attributes;
    }

    private class ProcessOutputReader
    implements Runnable {
        Process p;

        ProcessOutputReader(Process p) {
            this.p = p;
        }

        public void run() {
            try {
                byte[] buff = new byte[1000];
                InputStream in = this.p.getInputStream();
                int c = in.read(buff);
                while (c > 0) {
                    c = in.read(buff);
                }
                in = this.p.getErrorStream();
                c = in.read(buff);
                while (c != -1) {
                    c = in.read(buff);
                }
            }
            catch (IOException exc) {
                PHPDebugPlugin.log(exc);
            }
            if (PHPExecutableDebuggerInitializer.this.launch != null && PHPExecutableDebuggerInitializer.this.launch.getDebugTarget() == null) {
                String launchName = PHPExecutableDebuggerInitializer.this.launch.getLaunchConfiguration().getName();
                boolean isRunMode = "run".equals(PHPExecutableDebuggerInitializer.this.launch.getLaunchMode());
                String msg = null;
                msg = isRunMode ? MessageFormat.format(PHPDebugCoreMessages.Debugger_Error_Message_3, launchName) : MessageFormat.format(PHPDebugCoreMessages.Debugger_Error_Message_2, launchName);
                final String message = msg;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.Debugger_Launch_Error, (String)message);
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(((ProcessOutputReader)ProcessOutputReader.this).PHPExecutableDebuggerInitializer.this.launch);
                    }
                });
            }
        }
    }
}

