/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Action;
import JFlex.Out;
import JFlex.StatePairList;

public final class DFA {
    private static final int STATES = 500;
    public static final int NO_TARGET = -1;
    int[][] table;
    boolean[] isFinal;
    boolean[] isPushback;
    boolean[] isLookEnd;
    Action[] action;
    int[] lexState;
    int numStates;
    int numInput;

    public DFA(int n, int n2) {
        this.numInput = n2 - 1;
        int n3 = Math.max(n, 500);
        this.table = new int[n3][this.numInput];
        this.action = new Action[n3];
        this.isFinal = new boolean[n3];
        this.isPushback = new boolean[n3];
        this.isLookEnd = new boolean[n3];
        this.lexState = new int[n];
        this.numStates = 0;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < this.numInput) {
                this.table[n4][n5] = -1;
                n5 = (char)(n5 + 1);
            }
            ++n4;
        }
    }

    public void setLexState(int n, int n2) {
        this.lexState[n] = n2;
    }

    private void ensureStateCapacity(int n) {
        int n2 = this.isFinal.length;
        if (n < n2) {
            return;
        }
        int n3 = n2 * 2;
        while (n3 <= n) {
            n3 *= 2;
        }
        boolean[] blArray = new boolean[n3];
        boolean[] blArray2 = new boolean[n3];
        boolean[] blArray3 = new boolean[n3];
        Action[] actionArray = new Action[n3];
        int[][] nArray = new int[n3][this.numInput];
        System.arraycopy(this.isFinal, 0, blArray, 0, this.numStates);
        System.arraycopy(this.isPushback, 0, blArray2, 0, this.numStates);
        System.arraycopy(this.isLookEnd, 0, blArray3, 0, this.numStates);
        System.arraycopy(this.action, 0, actionArray, 0, this.numStates);
        System.arraycopy(this.table, 0, nArray, 0, n2);
        int n4 = n2;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < this.numInput) {
                nArray[n4][n5] = -1;
                ++n5;
            }
            ++n4;
        }
        this.isFinal = blArray;
        this.isPushback = blArray2;
        this.isLookEnd = blArray3;
        this.action = actionArray;
        this.table = nArray;
    }

    public void setAction(int n, Action action) {
        this.action[n] = action;
    }

    public void setFinal(int n, boolean bl) {
        this.isFinal[n] = bl;
    }

    public void setPushback(int n, boolean bl) {
        this.isPushback[n] = bl;
    }

    public void setLookEnd(int n, boolean bl) {
        this.isLookEnd[n] = bl;
    }

    public void addTransition(int n, char c, int n2) {
        int n3 = Math.max(n, n2) + 1;
        this.ensureStateCapacity(n3);
        if (n3 > this.numStates) {
            this.numStates = n3;
        }
        this.table[n][c] = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.numStates) {
            stringBuffer.append("State ");
            if (this.isFinal[n]) {
                stringBuffer.append("[FINAL] ");
            }
            if (this.isPushback[n]) {
                stringBuffer.append("[EOL] ");
            }
            stringBuffer.append(String.valueOf(n) + ":" + Out.NL);
            int n2 = 0;
            while (n2 < this.numInput) {
                if (this.table[n][n2] >= 0) {
                    stringBuffer.append("  with '" + n2 + "' in " + this.table[n][n2] + Out.NL);
                }
                n2 = (char)(n2 + 1);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void minimize() {
        int n;
        int n2;
        Out.print(String.valueOf(this.numStates) + " states before minimization, ");
        boolean[][] blArray = new boolean[this.numStates][];
        StatePairList[][] statePairListArray = new StatePairList[this.numStates][];
        int n3 = 1;
        while (n3 < this.numStates) {
            statePairListArray[n3] = new StatePairList[n3];
            blArray[n3] = new boolean[n3];
            n2 = 0;
            while (n2 < n3) {
                blArray[n3][n2] = this.isFinal[n3] && this.isFinal[n2] && this.isPushback[n3] == this.isPushback[n2] && this.isLookEnd[n3] == this.isLookEnd[n2] ? this.action[n3].equals(this.action[n2]) : !this.isFinal[n2] && !this.isFinal[n3] && this.isPushback[n3] == this.isPushback[n2] && this.isLookEnd[n3] == this.isLookEnd[n2];
                ++n2;
            }
            ++n3;
        }
        n3 = 1;
        while (n3 < this.numStates) {
            n2 = 0;
            while (n2 < n3) {
                if (blArray[n3][n2]) {
                    int n4;
                    int n5;
                    int n6;
                    n = 0;
                    while (n < this.numInput) {
                        if (blArray[n3][n2]) {
                            n6 = this.table[n3][n];
                            n5 = this.table[n2][n];
                            if (n6 < n5) {
                                n4 = n6;
                                n6 = n5;
                                n5 = n4;
                            }
                            if (!(n6 < 0 && n5 < 0 || n6 == n5 || n6 != -1 && n5 != -1 && blArray[n6][n5])) {
                                blArray[n3][n2] = false;
                                if (statePairListArray[n3][n2] != null) {
                                    statePairListArray[n3][n2].markAll(statePairListArray, blArray);
                                }
                            }
                        }
                        n = (char)(n + 1);
                    }
                    if (blArray[n3][n2]) {
                        n = 0;
                        while (n < this.numInput) {
                            n6 = this.table[n3][n];
                            n5 = this.table[n2][n];
                            if (n6 < n5) {
                                n4 = n6;
                                n6 = n5;
                                n5 = n4;
                            }
                            if (n6 != n5 && n6 >= 0 && n5 >= 0) {
                                if (statePairListArray[n6][n5] == null) {
                                    statePairListArray[n6][n5] = new StatePairList();
                                }
                                statePairListArray[n6][n5].addPair(n3, n2);
                            }
                            n = (char)(n + 1);
                        }
                    }
                }
                ++n2;
            }
            ++n3;
        }
        int[] nArray = new int[this.numStates];
        boolean[] blArray2 = new boolean[this.numStates];
        int[] nArray2 = new int[this.numStates];
        n3 = 0;
        while (n3 < this.numStates) {
            nArray[n3] = n3;
            n2 = 0;
            while (n2 < n3) {
                if (blArray[n3][n2]) {
                    nArray[n3] = n2;
                    blArray2[n3] = true;
                    break;
                }
                ++n2;
            }
            ++n3;
        }
        int n7 = 0;
        n3 = 0;
        while (n3 < this.numStates) {
            if (blArray2[n3]) {
                ++n7;
            } else {
                nArray2[n3] = n7;
            }
            ++n3;
        }
        n3 = 0;
        n2 = 0;
        while (n3 < this.numStates) {
            if (!blArray2[n3]) {
                n = 0;
                while (n < this.numInput) {
                    if (this.table[n3][n] >= 0) {
                        this.table[n2][n] = nArray[this.table[n3][n]];
                        int[] nArray3 = this.table[n2];
                        int n8 = n;
                        nArray3[n8] = nArray3[n8] - nArray2[this.table[n2][n]];
                    } else {
                        this.table[n2][n] = this.table[n3][n];
                    }
                    n = (char)(n + 1);
                }
                this.isFinal[n2] = this.isFinal[n3];
                this.isPushback[n2] = this.isPushback[n3];
                this.isLookEnd[n2] = this.isLookEnd[n3];
                this.action[n2] = this.action[n3];
                ++n2;
            }
            ++n3;
        }
        this.numStates = n2;
        n3 = 0;
        while (n3 < this.lexState.length) {
            this.lexState[n3] = nArray[this.lexState[n3]];
            int n9 = n3;
            this.lexState[n9] = this.lexState[n9] - nArray2[this.lexState[n3]];
            ++n3;
        }
        Out.println(String.valueOf(this.numStates) + " states in minimized DFA");
    }

    public void printTable(boolean[][] blArray) {
        Out.dump("Equivalence table is : ");
        int n = 1;
        while (n < this.numStates) {
            String string = String.valueOf(n) + " :";
            int n2 = 0;
            while (n2 < n) {
                string = blArray[n][n2] ? String.valueOf(string) + " E" : String.valueOf(string) + " x";
                ++n2;
            }
            Out.dump(string);
            ++n;
        }
    }
}

