/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ccvs.core.mapping.ChangeSetModelProvider;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.ChangeSetComparator;
import org.eclipse.team.internal.ccvs.ui.mappings.ChangeSetContentProvider;
import org.eclipse.team.internal.ccvs.ui.mappings.OpenChangeSetAction;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelActionProvider;
import org.eclipse.team.internal.ui.mapping.ResourceModelTraversalCalculator;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelParticipantAction;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ChangeSetActionProvider
extends ResourceModelActionProvider {
    public static final String CHANGE_SET_GROUP = "changeSetActions";
    private static final String P_LAST_COMMENTSORT = "org.eclipse.team.ui.P_LAST_COMMENT_SORT";
    private MenuManager sortByComment;
    private CreateChangeSetAction createChangeSet;
    private MenuManager addToChangeSet;
    private EditChangeSetAction editChangeSet;
    private RemoveChangeSetAction removeChangeSet;
    private MakeDefaultChangeSetAction makeDefault;
    private OpenChangeSetAction openCommitSet;

    static String escapeActionText(String x) {
        int ampersandIndex = x.indexOf(38);
        if (ampersandIndex == -1) {
            return x;
        }
        int len = x.length();
        StringBuffer sb = new StringBuffer(2 * len + 1);
        int doneIndex = 0;
        while (ampersandIndex != -1) {
            sb.append(x.substring(doneIndex, ampersandIndex));
            sb.append("&&");
            doneIndex = ampersandIndex + 1;
            ampersandIndex = x.indexOf(38, doneIndex);
        }
        if (doneIndex < len) {
            sb.append(x.substring(doneIndex, len));
        }
        return sb.toString();
    }

    public static int getSortCriteria(ISynchronizePageConfiguration configuration) {
        int sortCriteria = 1;
        if (configuration != null) {
            Object o = configuration.getProperty(P_LAST_COMMENTSORT);
            if (o instanceof Integer) {
                Integer wrapper = (Integer)o;
                sortCriteria = wrapper;
            } else {
                try {
                    IDialogSettings pageSettings = configuration.getSite().getPageSettings();
                    if (pageSettings != null) {
                        sortCriteria = pageSettings.getInt(P_LAST_COMMENTSORT);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        switch (sortCriteria) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                sortCriteria = 1;
            }
        }
        return sortCriteria;
    }

    public static void setSortCriteria(ISynchronizePageConfiguration configuration, int criteria) {
        configuration.setProperty(P_LAST_COMMENTSORT, (Object)new Integer(criteria));
        IDialogSettings pageSettings = configuration.getSite().getPageSettings();
        if (pageSettings != null) {
            pageSettings.put(P_LAST_COMMENTSORT, criteria);
        }
    }

    protected void initialize() {
        super.initialize();
        if (this.getChangeSetCapability().supportsCheckedInChangeSets()) {
            this.sortByComment = new MenuManager(TeamUIMessages.ChangeLogModelProvider_0a);
            this.sortByComment.add((IAction)new ToggleSortOrderAction(TeamUIMessages.ChangeLogModelProvider_1a, 2));
            this.sortByComment.add((IAction)new ToggleSortOrderAction(TeamUIMessages.ChangeLogModelProvider_2a, 1));
            this.sortByComment.add((IAction)new ToggleSortOrderAction(TeamUIMessages.ChangeLogModelProvider_3a, 3));
            this.openCommitSet = new OpenChangeSetAction(this.getSynchronizePageConfiguration());
        }
        if (this.getChangeSetCapability().supportsActiveChangeSets()) {
            this.addToChangeSet = new MenuManager(TeamUIMessages.ChangeLogModelProvider_12);
            this.addToChangeSet.setRemoveAllWhenShown(true);
            this.addToChangeSet.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    ChangeSetActionProvider.this.addChangeSets(manager);
                }
            });
            this.createChangeSet = new CreateChangeSetAction(this.getSynchronizePageConfiguration());
            this.addToChangeSet.add((IAction)this.createChangeSet);
            this.addToChangeSet.add((IContributionItem)new Separator());
            this.editChangeSet = new EditChangeSetAction(this.getSynchronizePageConfiguration());
            this.makeDefault = new MakeDefaultChangeSetAction(this.getSynchronizePageConfiguration());
            this.removeChangeSet = new RemoveChangeSetAction(this.getSynchronizePageConfiguration());
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.isContentProviderEnabled()) {
            super.fillContextMenu(menu);
            if (this.getChangeSetCapability().enableCheckedInChangeSetsFor(this.getSynchronizePageConfiguration())) {
                this.appendToGroup((IContributionManager)menu, "file-bottom", (IAction)this.openCommitSet);
                this.appendToGroup((IContributionManager)menu, "sort", (IContributionItem)this.sortByComment);
            }
            if (this.getChangeSetCapability().enableActiveChangeSetsFor(this.getSynchronizePageConfiguration())) {
                this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IContributionItem)this.addToChangeSet);
                this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IAction)this.editChangeSet);
                this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IAction)this.removeChangeSet);
                this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IAction)this.makeDefault);
            }
        }
    }

    public void dispose() {
        if (this.addToChangeSet != null) {
            this.addToChangeSet.dispose();
            this.addToChangeSet.removeAll();
        }
        if (this.sortByComment != null) {
            this.sortByComment.dispose();
            this.sortByComment.removeAll();
        }
        super.dispose();
    }

    protected void addChangeSets(IMenuManager manager) {
        ChangeSet[] sets = this.getActiveChangeSetManager().getSets();
        Arrays.sort(sets, new ChangeSetComparator());
        ISelection selection = this.getContext().getSelection();
        this.createChangeSet.selectionChanged(selection);
        this.addToChangeSet.add((IAction)this.createChangeSet);
        this.addToChangeSet.add((IContributionItem)new Separator());
        int i = 0;
        while (i < sets.length) {
            ActiveChangeSet set = (ActiveChangeSet)sets[i];
            AddToChangeSetAction action = new AddToChangeSetAction(this.getSynchronizePageConfiguration(), set, selection);
            manager.add((IAction)action);
            ++i;
        }
        this.addToChangeSet.add((IContributionItem)new Separator());
        this.addToChangeSet.add((IAction)new AddToChangeSetAction(this.getSynchronizePageConfiguration(), null, selection));
    }

    private boolean appendToGroup(IContributionManager manager, String groupId, IContributionItem item) {
        if (manager == null || item == null) {
            return false;
        }
        IContributionItem group = manager.find(groupId);
        if (group != null) {
            manager.appendToGroup(group.getId(), item);
            return true;
        }
        return false;
    }

    private boolean appendToGroup(IContributionManager manager, String groupId, IAction action) {
        if (manager == null || action == null) {
            return false;
        }
        IContributionItem group = manager.find(groupId);
        if (group != null) {
            manager.appendToGroup(group.getId(), action);
            return true;
        }
        return false;
    }

    public ChangeSetCapability getChangeSetCapability() {
        ISynchronizeParticipant participant = this.getSynchronizePageConfiguration().getParticipant();
        if (participant instanceof IChangeSetProvider) {
            IChangeSetProvider provider = (IChangeSetProvider)participant;
            return provider.getChangeSetCapability();
        }
        return null;
    }

    void syncExec(Runnable runnable) {
        Control ctrl = this.getSynchronizePageConfiguration().getPage().getViewer().getControl();
        Utils.syncExec((Runnable)runnable, (Control)ctrl);
    }

    ActiveChangeSetManager getActiveChangeSetManager() {
        return CVSUIPlugin.getPlugin().getChangeSetManager();
    }

    public IDiff[] getLocalChanges(IStructuredSelection selection) {
        if (selection instanceof ITreeSelection) {
            ITreeSelection ts = (ITreeSelection)selection;
            TreePath[] paths = ts.getPaths();
            ArrayList<IDiff> result = new ArrayList<IDiff>();
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                IDiff[] diffs = this.getLocalChanges(path);
                int j = 0;
                while (j < diffs.length) {
                    IDiff diff = diffs[j];
                    result.add(diff);
                    ++j;
                }
                ++i;
            }
            return result.toArray(new IDiff[result.size()]);
        }
        return new IDiff[0];
    }

    private IDiff[] getLocalChanges(TreePath path) {
        IResourceDiffTree tree = this.getDiffTree(path);
        if (path.getSegmentCount() == 1 && path.getLastSegment() instanceof IDiffTree) {
            return ((ResourceDiffTree)tree).getDiffs();
        }
        ResourceTraversal[] traversals = this.getTraversals(path.getLastSegment());
        return tree.getDiffs(traversals);
    }

    private IResourceDiffTree getDiffTree(TreePath path) {
        return this.getContentProvider().getDiffTree(path);
    }

    public boolean containsLocalChanges(IStructuredSelection selection) {
        if (selection instanceof ITreeSelection) {
            ITreeSelection ts = (ITreeSelection)selection;
            TreePath[] paths = ts.getPaths();
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                if (this.containsLocalChanges(path)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean containsLocalChanges(TreePath path) {
        IResourceDiffTree tree = this.getDiffTree(path);
        ResourceTraversal[] traversals = this.getTraversals(path.getLastSegment());
        return tree.hasMatchingDiffs(traversals, this.getVisibleLocalChangesFilter());
    }

    private ResourceTraversal[] getTraversals(Object element) {
        if (element instanceof ChangeSet) {
            ChangeSet set = (ChangeSet)element;
            return new ResourceTraversal[]{new ResourceTraversal(set.getResources(), 0, 0)};
        }
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{project}, 2, 0)};
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{file}, 0, 0)};
        }
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout")) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{folder}, 1, 0)};
            }
            if (this.getLayout().equals("org.eclipse.team.ui.tree_layout")) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{folder}, 2, 0)};
            }
            if (this.getLayout().equals("org.eclipse.team.ui.flay_layout")) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{folder}, 0, 0)};
            }
        }
        return new ResourceTraversal[0];
    }

    private FastDiffFilter getVisibleLocalChangesFilter() {
        return new FastDiffFilter(){

            public boolean select(IDiff diff) {
                IThreeWayDiff twd;
                return diff instanceof IThreeWayDiff && ChangeSetActionProvider.this.isVisible(diff) && ((twd = (IThreeWayDiff)diff).getDirection() == 256 || twd.getDirection() == 768);
            }
        };
    }

    boolean isVisible(IDiff diff) {
        return ((SynchronizePageConfiguration)this.getSynchronizePageConfiguration()).isVisible(diff);
    }

    protected ResourceModelTraversalCalculator getTraversalCalculator() {
        return ResourceModelTraversalCalculator.getTraversalCalculator((ISynchronizePageConfiguration)this.getSynchronizePageConfiguration());
    }

    private ChangeSetContentProvider getContentProvider() {
        ITreeContentProvider provider;
        INavigatorContentExtension extension = this.getExtension();
        if (extension != null && (provider = extension.getContentProvider()) instanceof ChangeSetContentProvider) {
            return (ChangeSetContentProvider)provider;
        }
        return null;
    }

    private INavigatorContentExtension getExtension() {
        INavigatorContentService service = this.getActionSite().getContentService();
        Set set = service.findContentExtensionsByTriggerPoint(this.getModelProvider());
        Iterator iter = set.iterator();
        if (iter.hasNext()) {
            INavigatorContentExtension extension = (INavigatorContentExtension)iter.next();
            return extension;
        }
        return null;
    }

    private Object getModelProvider() {
        return ChangeSetModelProvider.getProvider();
    }

    private String getLayout() {
        return TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.default_layout");
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (context != null) {
            if (this.editChangeSet != null) {
                this.editChangeSet.selectionChanged((IStructuredSelection)this.getContext().getSelection());
            }
            if (this.removeChangeSet != null) {
                this.removeChangeSet.selectionChanged((IStructuredSelection)this.getContext().getSelection());
            }
            if (this.makeDefault != null) {
                this.makeDefault.selectionChanged((IStructuredSelection)this.getContext().getSelection());
            }
        }
    }

    protected boolean isContentProviderEnabled() {
        ChangeSetContentProvider provider = this.getContentProvider();
        if (provider != null) {
            return provider.isEnabled();
        }
        return false;
    }

    ISynchronizePageConfiguration internalGetSynchronizePageConfiguration() {
        return this.getSynchronizePageConfiguration();
    }

    private class AddToChangeSetAction
    extends ModelParticipantAction {
        private final ActiveChangeSet set;

        public AddToChangeSetAction(ISynchronizePageConfiguration configuration, ActiveChangeSet set, ISelection selection) {
            super(set == null ? TeamUIMessages.ChangeSetActionGroup_2 : ChangeSetActionProvider.escapeActionText(set.getTitle()), configuration);
            this.set = set;
            this.selectionChanged(selection);
        }

        public void run() {
            IDiff[] diffArray = ChangeSetActionProvider.this.getLocalChanges(this.getStructuredSelection());
            if (this.set != null) {
                this.set.add(diffArray);
            } else {
                ChangeSet[] sets = ChangeSetActionProvider.this.getActiveChangeSetManager().getSets();
                IResource[] resources = this.getResources(diffArray);
                int i = 0;
                while (i < sets.length) {
                    ActiveChangeSet activeSet = (ActiveChangeSet)sets[i];
                    activeSet.remove(resources);
                    ++i;
                }
            }
        }

        private IResource[] getResources(IDiff[] diffArray) {
            ArrayList<IResource> result = new ArrayList<IResource>();
            int i = 0;
            while (i < diffArray.length) {
                IDiff diff = diffArray[i];
                IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
                if (resource != null) {
                    result.add(resource);
                }
                ++i;
            }
            return result.toArray(new IResource[result.size()]);
        }

        protected boolean isEnabledForSelection(IStructuredSelection selection) {
            return ChangeSetActionProvider.this.isContentProviderEnabled() && ChangeSetActionProvider.this.containsLocalChanges(selection);
        }
    }

    private abstract class ChangeSetAction
    extends BaseSelectionListenerAction {
        public ChangeSetAction(String title, ISynchronizePageConfiguration configuration) {
            super(title);
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            return this.getSelectedSet() != null;
        }

        protected ActiveChangeSet getSelectedSet() {
            ActiveChangeSet activeChangeSet;
            Object first;
            IStructuredSelection selection = this.getStructuredSelection();
            if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof ActiveChangeSet && (activeChangeSet = (ActiveChangeSet)first).isUserCreated()) {
                return activeChangeSet;
            }
            return null;
        }
    }

    private class CreateChangeSetAction
    extends ModelParticipantAction {
        public CreateChangeSetAction(ISynchronizePageConfiguration configuration) {
            super(TeamUIMessages.ChangeLogModelProvider_0, configuration);
        }

        public void run() {
            IDiff[] diffs = ChangeSetActionProvider.this.getLocalChanges(this.getStructuredSelection());
            ChangeSetActionProvider.this.syncExec(new Runnable(this, diffs){
                final /* synthetic */ CreateChangeSetAction this$1;
                private final /* synthetic */ IDiff[] val$diffs;
                {
                    this.this$1 = createChangeSetAction;
                    this.val$diffs = iDiffArray;
                }

                public void run() {
                    this.this$1.createChangeSet(this.val$diffs);
                }
            });
        }

        void createChangeSet(IDiff[] diffs) {
            ActiveChangeSet set = ChangeSetActionProvider.this.getChangeSetCapability().createChangeSet(this.getConfiguration(), diffs);
            if (set != null) {
                ChangeSetActionProvider.this.getActiveChangeSetManager().add((ChangeSet)set);
            }
        }

        protected boolean isEnabledForSelection(IStructuredSelection selection) {
            return ChangeSetActionProvider.this.isContentProviderEnabled() && ChangeSetActionProvider.this.containsLocalChanges(selection);
        }
    }

    private class EditChangeSetAction
    extends ChangeSetAction {
        public EditChangeSetAction(ISynchronizePageConfiguration configuration) {
            super(TeamUIMessages.ChangeLogModelProvider_6, configuration);
        }

        public void run() {
            ActiveChangeSet set = this.getSelectedSet();
            if (set == null) {
                return;
            }
            ChangeSetActionProvider.this.getChangeSetCapability().editChangeSet(ChangeSetActionProvider.this.internalGetSynchronizePageConfiguration(), set);
        }
    }

    private class MakeDefaultChangeSetAction
    extends ChangeSetAction {
        public MakeDefaultChangeSetAction(ISynchronizePageConfiguration configuration) {
            super(TeamUIMessages.ChangeLogModelProvider_9, configuration);
        }

        public void run() {
            ActiveChangeSet set = this.getSelectedSet();
            if (set == null) {
                return;
            }
            ChangeSetActionProvider.this.getActiveChangeSetManager().makeDefault(set);
        }
    }

    private class RemoveChangeSetAction
    extends ChangeSetAction {
        public RemoveChangeSetAction(ISynchronizePageConfiguration configuration) {
            super("Remove Change Set", configuration);
        }

        public void run() {
            ActiveChangeSet set = this.getSelectedSet();
            if (set == null) {
                return;
            }
            if (MessageDialog.openConfirm((Shell)ChangeSetActionProvider.this.internalGetSynchronizePageConfiguration().getSite().getShell(), (String)TeamUIMessages.ChangeSetActionGroup_0, (String)NLS.bind((String)TeamUIMessages.ChangeSetActionGroup_1, (Object[])new String[]{set.getTitle()}))) {
                ChangeSetActionProvider.this.getActiveChangeSetManager().remove((ChangeSet)set);
            }
        }
    }

    private class ToggleSortOrderAction
    extends Action {
        private int criteria;

        protected ToggleSortOrderAction(String name, int criteria) {
            super(name, 8);
            this.criteria = criteria;
            this.update();
        }

        public void run() {
            int sortCriteria = ChangeSetActionProvider.getSortCriteria(ChangeSetActionProvider.this.internalGetSynchronizePageConfiguration());
            if (this.isChecked() && sortCriteria != this.criteria) {
                ChangeSetActionProvider.setSortCriteria(ChangeSetActionProvider.this.internalGetSynchronizePageConfiguration(), this.criteria);
                this.update();
                ((SynchronizePageConfiguration)ChangeSetActionProvider.this.internalGetSynchronizePageConfiguration()).getPage().getViewer().refresh();
            }
        }

        public void update() {
            this.setChecked(this.criteria == ChangeSetActionProvider.getSortCriteria(ChangeSetActionProvider.this.internalGetSynchronizePageConfiguration()));
        }
    }
}

