/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.EditorsPluginPreferenceInitializer;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class AbstractDecoratedTextEditorPreferenceConstants {
    public static final String EDITOR_CURRENT_LINE = "currentLine";
    public static final String EDITOR_CURRENT_LINE_COLOR = "currentLineColor";
    public static final String EDITOR_TAB_WIDTH = "tabWidth";
    public static final String EDITOR_SPACES_FOR_TABS = "spacesForTabs";
    public static final String EDITOR_UNDO_HISTORY_SIZE = "undoHistorySize";
    public static final String EDITOR_PRINT_MARGIN = "printMargin";
    public static final String EDITOR_PRINT_MARGIN_COLOR = "printMarginColor";
    public static final String EDITOR_PRINT_MARGIN_COLUMN = "printMarginColumn";
    public static final String EDITOR_UNKNOWN_INDICATION = "othersIndication";
    public static final String EDITOR_UNKNOWN_INDICATION_COLOR = "othersIndicationColor";
    public static final String EDITOR_UNKNOWN_INDICATION_IN_OVERVIEW_RULER = "othersIndicationInOverviewRuler";
    public static final String EDITOR_OVERVIEW_RULER = "overviewRuler";
    public static final String EDITOR_LINE_NUMBER_RULER = "lineNumberRuler";
    public static final String EDITOR_LINE_NUMBER_RULER_COLOR = "lineNumberColor";
    public static final String USE_ANNOTATIONS_PREFERENCE_PAGE = "useAnnotationsPrefPage";
    public static final String USE_QUICK_DIFF_PREFERENCE_PAGE = "useQuickDiffPrefPage";
    public static final String QUICK_DIFF_ALWAYS_ON = "quickdiff.quickDiff";
    public static final String QUICK_DIFF_DEFAULT_PROVIDER = "quickdiff.defaultProvider";
    public static final String QUICK_DIFF_CHARACTER_MODE = "quickdiff.characterMode";
    public static final String EDITOR_USE_CUSTOM_CARETS = "AbstractTextEditor.Accessibility.UseCustomCarets";
    public static final String EDITOR_WIDE_CARET = "AbstractTextEditor.Accessibility.WideCaret";
    public static final String EDITOR_SELECTION_FOREGROUND_COLOR = "AbstractTextEditor.Color.SelectionForeground";
    public static final String EDITOR_SELECTION_FOREGROUND_DEFAULT_COLOR = "AbstractTextEditor.Color.SelectionForeground.SystemDefault";
    public static final String EDITOR_SELECTION_BACKGROUND_COLOR = "AbstractTextEditor.Color.SelectionBackground";
    public static final String EDITOR_SELECTION_BACKGROUND_DEFAULT_COLOR = "AbstractTextEditor.Color.SelectionBackground.SystemDefault";
    public static final String EDITOR_HYPERLINKS_ENABLED = "hyperlinksEnabled";
    public static final String EDITOR_HYPERLINK_KEY_MODIFIER = "hyperlinkKeyModifier";
    public static final String EDITOR_HYPERLINK_KEY_MODIFIER_MASK = "hyperlinkKeyModifierMask";
    public static final String EDITOR_HYPERLINK_COLOR = "hyperlinkColor";
    public static final String EDITOR_DISABLE_OVERWRITE_MODE = "disable_overwrite_mode";
    public static final String EDITOR_WARN_IF_INPUT_DERIVED = "warn_if_input_derived";
    public static final String EDITOR_SMART_HOME_END = "AbstractTextEditor.Navigation.SmartHomeEnd";
    public static final String EDITOR_SHOW_WHITESPACE_CHARACTERS = "showWhitespaceCharacters";
    public static final String SHOW_RANGE_INDICATOR = "show_range_indicator";
    public static final String REVISION_ASK_BEFORE_QUICKDIFF_SWITCH = "quickdiff.nowarn.before.switch";
    public static final String REVISION_RULER_RENDERING_MODE = "revisionRulerRenderingMode";
    public static final String REVISION_RULER_SHOW_AUTHOR = "revisionRulerShowAuthor";
    public static final String REVISION_RULER_SHOW_REVISION = "revisionRulerShowRevision";
    public static final String EDITOR_TEXT_DRAG_AND_DROP_ENABLED = "textDragAndDropEnabled";
    public static final String EDITOR_SHOW_TEXT_HOVER_AFFORDANCE = "showTextHoverAffordance";
    public static final String EDITOR_HOVER_ENRICH_MODE = "hoverReplaceMode";

    private AbstractDecoratedTextEditorPreferenceConstants() {
    }

    public static void initializeDefaultValues(IPreferenceStore store) {
        store.setDefault(USE_ANNOTATIONS_PREFERENCE_PAGE, false);
        store.setDefault(USE_QUICK_DIFF_PREFERENCE_PAGE, false);
        store.setDefault(EDITOR_CURRENT_LINE, true);
        store.setDefault(EDITOR_TAB_WIDTH, 4);
        store.setDefault(EDITOR_SPACES_FOR_TABS, false);
        store.setDefault(EDITOR_UNDO_HISTORY_SIZE, 200);
        store.setDefault(EDITOR_PRINT_MARGIN, false);
        store.setDefault(EDITOR_PRINT_MARGIN_COLUMN, 80);
        store.setDefault(EDITOR_LINE_NUMBER_RULER, false);
        if (!store.getBoolean(USE_QUICK_DIFF_PREFERENCE_PAGE)) {
            store.setDefault(QUICK_DIFF_ALWAYS_ON, true);
            store.setDefault(QUICK_DIFF_CHARACTER_MODE, false);
            store.setDefault(QUICK_DIFF_DEFAULT_PROVIDER, "org.eclipse.ui.internal.editors.quickdiff.LastSaveReferenceProvider");
        }
        store.setDefault(EDITOR_OVERVIEW_RULER, true);
        store.setDefault(EDITOR_UNKNOWN_INDICATION, false);
        store.setDefault(EDITOR_UNKNOWN_INDICATION_IN_OVERVIEW_RULER, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_UNKNOWN_INDICATION_COLOR, (RGB)new RGB(0, 0, 0));
        store.setDefault(EDITOR_USE_CUSTOM_CARETS, false);
        store.setDefault(EDITOR_WIDE_CARET, true);
        store.setDefault(EDITOR_SELECTION_FOREGROUND_DEFAULT_COLOR, true);
        store.setDefault(EDITOR_SELECTION_BACKGROUND_DEFAULT_COLOR, true);
        store.setDefault("AbstractTextEditor.Color.Background.SystemDefault", true);
        store.setDefault("AbstractTextEditor.Color.Foreground.SystemDefault", true);
        String mod1Name = Action.findModifierString((int)SWT.MOD1);
        store.setDefault(EDITOR_HYPERLINKS_ENABLED, true);
        store.setDefault(EDITOR_HYPERLINK_KEY_MODIFIER, mod1Name);
        store.setDefault(EDITOR_HYPERLINK_KEY_MODIFIER_MASK, SWT.MOD1);
        HyperlinkDetectorDescriptor[] descriptors = EditorsUI.getHyperlinkDetectorRegistry().getHyperlinkDetectorDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            int stateMask = AbstractDecoratedTextEditorPreferenceConstants.computeStateMask(descriptors[i].getModifierKeys());
            if (stateMask == 131072) {
                EditorsPlugin.logErrorMessage("The '" + descriptors[i].getId() + "' hyperlink detector specifies 'Shift' as modifier. This is not allowed and hence replaced with the default modifier.");
                stateMask = -1;
            }
            store.setDefault(String.valueOf(descriptors[i].getId()) + "_stateMask", stateMask);
            ++i;
        }
        boolean isInTestMode = System.getProperty("eclipse.perf.dbloc") != null;
        boolean isInstalled = EditorsUI.getSpellingService().getSpellingEngineDescriptors().length > 0;
        store.setDefault("spellingEnabled", !isInTestMode && isInstalled);
        store.setDefault("spellingEngine", "");
        store.setDefault(SHOW_RANGE_INDICATOR, true);
        store.setDefault(REVISION_ASK_BEFORE_QUICKDIFF_SWITCH, "");
        store.setDefault("rulerContributions", "");
        store.setDefault(REVISION_RULER_RENDERING_MODE, IRevisionRulerColumnExtension.AGE.name());
        store.setDefault(REVISION_RULER_SHOW_AUTHOR, false);
        store.setDefault(REVISION_RULER_SHOW_REVISION, false);
        store.setDefault(EDITOR_WARN_IF_INPUT_DERIVED, true);
        store.setDefault(EDITOR_SMART_HOME_END, true);
        store.setDefault(EDITOR_SHOW_WHITESPACE_CHARACTERS, false);
        store.setDefault(EDITOR_TEXT_DRAG_AND_DROP_ENABLED, true);
        store.setDefault(EDITOR_SHOW_TEXT_HOVER_AFFORDANCE, true);
        store.setDefault(EDITOR_HOVER_ENRICH_MODE, 0);
        MarkerAnnotationPreferences.initializeDefaultValues(store);
        EditorsPluginPreferenceInitializer.setThemeBasedPreferences(store, false);
    }

    private static final int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = AbstractDecoratedTextEditorPreferenceConstants.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    private static final int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase("M1")) {
            return SWT.MOD1;
        }
        if (modifierName.equalsIgnoreCase("M2")) {
            return SWT.MOD2;
        }
        if (modifierName.equalsIgnoreCase("M3")) {
            return SWT.MOD3;
        }
        if (modifierName.equalsIgnoreCase("M4")) {
            return SWT.MOD4;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }
}

