/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

public class StatusLineCLabelContribution
extends ContributionItem {
    public static final int DEFAULT_CHAR_WIDTH = 40;
    private int charWidth;
    private CLabel label;
    private Image image;
    private String text = "";
    private int widthHint = -1;
    private int heightHint = -1;
    private Listener listener;
    private int eventType;
    private String tooltip;

    public StatusLineCLabelContribution(String id, int charWidth) {
        super(id);
        this.charWidth = charWidth;
        this.setVisible(false);
    }

    public void fill(Composite parent) {
        this.label = new CLabel(parent, -1);
        StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
        if (this.widthHint < 0) {
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            FontMetrics fm = gc.getFontMetrics();
            this.widthHint = fm.getAverageCharWidth() * this.charWidth;
            this.heightHint = fm.getHeight();
            gc.dispose();
        }
        statusLineLayoutData.widthHint = this.widthHint;
        this.label.setLayoutData((Object)statusLineLayoutData);
        this.label.setText(this.text);
        this.label.setImage(this.image);
        if (this.listener != null) {
            this.label.addListener(this.eventType, this.listener);
        }
        if (this.tooltip != null) {
            this.label.setToolTipText(this.tooltip);
        }
        statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.heightHint = this.heightHint;
    }

    public void addListener(int type, Listener labelListener) {
        this.eventType = type;
        this.listener = labelListener;
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.text = text;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setText(this.text);
        }
        if (this.text.length() == 0) {
            if (this.isVisible()) {
                this.setVisible(false);
                IContributionManager contributionManager = this.getParent();
                if (contributionManager != null) {
                    contributionManager.update(true);
                }
            }
        } else if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager contributionManager = this.getParent();
            if (contributionManager != null) {
                contributionManager.update(true);
            }
        }
    }

    public void setTooltip(String tooltip) {
        if (tooltip == null) {
            throw new NullPointerException();
        }
        this.tooltip = tooltip;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setToolTipText(this.tooltip);
        }
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setImage(this.image);
        }
        if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager contributionManager = this.getParent();
            if (contributionManager != null) {
                contributionManager.update(true);
            }
        }
    }
}

