/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core;

import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.server.core.Logger;
import org.eclipse.php.internal.server.core.ServerHelper;

public class Server
implements IXMLPreferencesStorable {
    public static final String SERVER_ELEMENT = "server";
    public static final String NAME = "name";
    public static final String BASE_URL = "base_url";
    public static final String DOCUMENT_ROOT = "document_root";
    public static final String PORT = "port";
    public static final String HOSTNAME = "hostname";
    public static final String FILE_NAME = "file_name";
    private static final int DEFAULT_HTTP_PORT = 80;
    private ServerHelper helper = new ServerHelper(this);

    public Server() {
    }

    public Server(String name, String host, String baseURL, String documentRoot) {
        this();
        this.setName(name);
        this.setHost(host);
        this.setBaseURL(baseURL);
        this.setDocumentRoot(documentRoot);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.helper.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.helper.removePropertyChangeListener(listener);
    }

    public void setAttribute(String attributeName, String value) {
        this.helper.setAttribute(attributeName, value);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        return this.helper.getAttribute(attributeName, defaultValue);
    }

    public void removeAttribute(String attributeName) {
        this.helper.removeAttribute(attributeName);
    }

    public String getName() {
        return this.getAttribute(NAME, "");
    }

    public void setName(String name) {
        this.setAttribute(NAME, name);
    }

    public String getBaseURL() {
        return this.getAttribute(BASE_URL, "");
    }

    public void setBaseURL(String url) {
        this.setAttribute(BASE_URL, url);
    }

    public String getHost() {
        return this.getAttribute(HOSTNAME, "localhost");
    }

    public void setHost(String host) {
        this.setAttribute(HOSTNAME, host);
    }

    public void setDocumentRoot(String docRoot) {
        this.setAttribute(DOCUMENT_ROOT, docRoot);
    }

    public String getDocumentRoot() {
        return this.getAttribute(DOCUMENT_ROOT, "");
    }

    public URL getRootURL() {
        try {
            String port = this.getPortString();
            String base = this.getBaseURL();
            if (base.equals("")) {
                base = "http://" + this.getHost();
            }
            URL url = null;
            url = port.equals("80") ? new URL(String.valueOf(base) + "/") : new URL(String.valueOf(base) + ":" + port + "/");
            return url;
        }
        catch (Exception e) {
            Logger.logException("Could not get root URL", e);
            return null;
        }
    }

    protected static String renderCommandLine(String[] commandLine, String separator) {
        if (commandLine == null || commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(separator);
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    public int getPort() {
        int port = Integer.parseInt(this.getPortString());
        if (port < 0) {
            port = 80;
        }
        return port;
    }

    public String getPortString() {
        return this.getAttribute(PORT, "80");
    }

    public void setPort(String port) {
        try {
            if (port.equals("")) {
                this.setAttribute(PORT, "80");
            } else {
                this.setAttribute(PORT, port);
            }
        }
        catch (Throwable throwable) {}
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Server)) {
            return false;
        }
        String name = this.getName();
        String otherName = ((Server)obj).getName();
        if (name == null && otherName != null) {
            return false;
        }
        return name.equals(otherName);
    }

    public String toString() {
        return "Server [" + this.getName() + "::" + this.getHost() + ']';
    }

    public void restoreFromMap(HashMap map) {
        HashMap properties = (HashMap)map.get(SERVER_ELEMENT);
        for (String key : properties.keySet()) {
            this.setAttribute(key, (String)properties.get(key));
        }
    }

    public HashMap storeToMap() {
        HashMap properties = new HashMap(this.helper.map);
        HashMap serverMap = new HashMap(1);
        serverMap.put(SERVER_ELEMENT, properties);
        return serverMap;
    }

    public boolean isLocal() {
        try {
            String host = this.getHost();
            if (host != null) {
                InetAddress addr = InetAddress.getByName(host);
                return addr.isLoopbackAddress() || addr.isSiteLocalAddress();
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

