/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.Stack;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;

public abstract class BracketInserter
implements VerifyKeyListener,
ILinkedModeListener {
    protected final ScriptEditor editor;
    protected boolean fCloseBrackets = true;
    protected boolean fCloseStrings = true;
    protected boolean fCloseAngularBrackets = true;
    protected final String CATEGORY;
    protected IPositionUpdater fUpdater;
    protected Stack fBracketLevelStack = new Stack();

    protected BracketInserter(ScriptEditor editor) {
        this.editor = editor;
        this.CATEGORY = this.editor.toString();
        this.fUpdater = new ScriptEditor.ExclusivePositionUpdater(this.CATEGORY);
    }

    public void setCloseBracketsEnabled(boolean enabled) {
        this.fCloseBrackets = enabled;
    }

    public void setCloseStringsEnabled(boolean enabled) {
        this.fCloseStrings = enabled;
    }

    public void setCloseAngularBracketsEnabled(boolean enabled) {
        this.fCloseAngularBrackets = enabled;
    }

    protected boolean isAngularIntroducer(String identifier) {
        return false;
    }

    protected static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    protected static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '<': {
                return '>';
            }
            case '>': {
                return '<';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    public abstract void verifyKey(VerifyEvent var1);

    public void left(LinkedModeModel environment, int flags) {
        final ScriptEditor.BracketLevel level = (ScriptEditor.BracketLevel)this.fBracketLevelStack.pop();
        if (flags != 8) {
            return;
        }
        ISourceViewer sourceViewer = this.editor.getScriptSourceViewer();
        final IDocument document = sourceViewer.getDocument();
        if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                public void perform(IDocument d, IDocumentListener owner) {
                    if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                        try {
                            document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, "");
                        }
                        catch (BadLocationException e) {
                            DLTKUIPlugin.log(e);
                        }
                    }
                    if (BracketInserter.this.fBracketLevelStack.size() == 0) {
                        document.removePositionUpdater(BracketInserter.this.fUpdater);
                        try {
                            document.removePositionCategory(BracketInserter.this.CATEGORY);
                        }
                        catch (BadPositionCategoryException e) {
                            DLTKUIPlugin.log(e);
                        }
                    }
                }
            });
        }
    }

    public void suspend(LinkedModeModel environment) {
    }

    public void resume(LinkedModeModel environment, int flags) {
    }
}

