/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.ui.wizards.NewElementWizard;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class BuildPathWizard
extends NewElementWizard {
    private boolean fDoFlushChange;
    private final BPListElement fEntryToEdit;
    private IProjectFragment fProjectFragment;
    private final ArrayList fExistingEntries;

    public BuildPathWizard(BPListElement[] existingEntries, BPListElement newEntry, String titel, ImageDescriptor image) {
        if (image != null) {
            this.setDefaultPageImageDescriptor(image);
        }
        this.setDialogSettings(DLTKUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(titel);
        this.fEntryToEdit = newEntry;
        this.fExistingEntries = new ArrayList<BPListElement>(Arrays.asList(existingEntries));
        this.fDoFlushChange = true;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.fDoFlushChange) {
            IScriptProject scriptProject = this.getEntryToEdit().getScriptProject();
            BuildpathsBlock.flush(this.getExistingEntries(), scriptProject, monitor);
            IProject project = scriptProject.getProject();
            IPath projPath = project.getFullPath();
            IPath path = this.getEntryToEdit().getPath();
            if (!projPath.equals((Object)path) && projPath.isPrefixOf(path)) {
                path = path.removeFirstSegments(projPath.segmentCount());
            }
            IFolder folder = project.getFolder(path);
            this.fProjectFragment = scriptProject.getProjectFragment((IResource)folder);
        }
    }

    public IModelElement getCreatedElement() {
        return this.fProjectFragment;
    }

    public void setDoFlushChange(boolean b) {
        this.fDoFlushChange = b;
    }

    public ArrayList getExistingEntries() {
        return this.fExistingEntries;
    }

    protected BPListElement getEntryToEdit() {
        return this.fEntryToEdit;
    }

    public List getInsertedElements() {
        return new ArrayList();
    }

    public List getRemovedElements() {
        return new ArrayList();
    }

    public List getModifiedElements() {
        ArrayList<BPListElement> result = new ArrayList<BPListElement>(1);
        result.add(this.fEntryToEdit);
        return result;
    }

    public abstract void cancel();
}

