/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.AddSourceFolderWizard;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementSorter;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListLabelProvider;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathBasePage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathWizard;
import org.eclipse.dltk.internal.ui.wizards.buildpath.CreateMultipleSourceFoldersDialog;
import org.eclipse.dltk.internal.ui.wizards.buildpath.EditFilterWizard;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.AbstractOpenWizardAction;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class SourceContainerWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fBuildpathList;
    protected IScriptProject fCurrJProject;
    private Control fSWTControl;
    protected TreeListDialogField fFoldersList;
    private final int IDX_ADD = 0;
    private final int IDX_ADD_LINK = 1;
    private final int IDX_EDIT = 3;
    private final int IDX_REMOVE = 4;

    protected static AddSourceFolderWizard newSourceFolderWizard(BPListElement element, List existingElements, boolean newFolder) {
        BPListElement[] existing = existingElements.toArray(new BPListElement[existingElements.size()]);
        AddSourceFolderWizard wizard = new AddSourceFolderWizard(existing, element, false, newFolder, newFolder, newFolder ? BPListElement.isProjectSourceFolder(existing, element.getScriptProject()) : false, newFolder);
        wizard.setDoFlushChange(false);
        return wizard;
    }

    private static AddSourceFolderWizard newLinkedSourceFolderWizard(BPListElement element, List existingElements, boolean newFolder) {
        BPListElement[] existing = existingElements.toArray(new BPListElement[existingElements.size()]);
        AddSourceFolderWizard wizard = new AddSourceFolderWizard(existing, element, true, newFolder, newFolder, newFolder ? BPListElement.isProjectSourceFolder(existing, element.getScriptProject()) : false, newFolder);
        wizard.setDoFlushChange(false);
        return wizard;
    }

    private static EditFilterWizard newEditFilterWizard(BPListElement element, List existingElements) {
        BPListElement[] existing = existingElements.toArray(new BPListElement[existingElements.size()]);
        EditFilterWizard result = new EditFilterWizard(existing, element);
        result.setDoFlushChange(false);
        return result;
    }

    protected int getIDX_ADD() {
        return 0;
    }

    protected int getIDX_ADD_LINK() {
        return 1;
    }

    protected int getIDX_EDIT() {
        return 3;
    }

    protected int getIDX_REMOVE() {
        return 4;
    }

    public SourceContainerWorkbookPage(ListDialogField buildpathList) {
        this.fBuildpathList = buildpathList;
        this.fSWTControl = null;
    }

    protected void initContainerElements() {
        SourceContainerAdapter adapter = new SourceContainerAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.SourceContainerWorkbookPage_folders_add_button;
        stringArray[1] = NewWizardMessages.SourceContainerWorkbookPage_folders_link_source_button;
        stringArray[3] = NewWizardMessages.SourceContainerWorkbookPage_folders_edit_button;
        stringArray[4] = NewWizardMessages.SourceContainerWorkbookPage_folders_remove_button;
        String[] buttonLabels = stringArray;
        this.fFoldersList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new BPListLabelProvider());
        this.fFoldersList.setDialogFieldListener(adapter);
        this.fFoldersList.setLabelText(NewWizardMessages.SourceContainerWorkbookPage_folders_label);
        this.fFoldersList.setViewerSorter(new BPListElementSorter());
        this.fFoldersList.enableButton(this.getIDX_EDIT(), false);
    }

    public void setTitle(String title) {
        this.fFoldersList.setLabelText(title);
    }

    public void init(IScriptProject jproject) {
        this.fCurrJProject = jproject;
        this.updateFoldersList();
    }

    protected void updateFoldersList() {
        BPListElement cpe;
        ArrayList<BPListElement> folders = new ArrayList<BPListElement>();
        List cpelements = this.fBuildpathList.getElements();
        int i = 0;
        while (i < cpelements.size()) {
            cpe = (BPListElement)cpelements.get(i);
            if (cpe.getEntryKind() == 3) {
                folders.add(cpe);
            }
            ++i;
        }
        this.fFoldersList.setElements(folders);
        i = 0;
        while (i < folders.size()) {
            cpe = (BPListElement)folders.get(i);
            IPath[] ePatterns = (IPath[])cpe.getAttribute("exclusion");
            IPath[] iPatterns = (IPath[])cpe.getAttribute("inclusion");
            if (ePatterns.length > 0 || iPatterns.length > 0) {
                this.fFoldersList.expandElement(cpe, 3);
            }
            ++i;
        }
    }

    public Control getControl(Composite parent) {
        this.initContainerElements();
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fFoldersList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fFoldersList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fFoldersList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        List elements = this.fFoldersList.getElements();
        int i = 0;
        while (i < elements.size()) {
            BPListElement elem = (BPListElement)elements.get(i);
            IPath[] exclusionPatterns = (IPath[])elem.getAttribute("exclusion");
            IPath[] inclusionPatterns = (IPath[])elem.getAttribute("inclusion");
            if (exclusionPatterns.length > 0 || inclusionPatterns.length > 0) {
                this.fFoldersList.expandElement(elem, 3);
            }
            ++i;
        }
        return composite;
    }

    protected Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }

    protected void sourcePageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fFoldersList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void sourcePageDoubleClicked(TreeListDialogField field) {
        List selection;
        if (field == this.fFoldersList && this.canEdit(selection = field.getSelectedElements())) {
            this.editEntry();
        }
    }

    protected void sourcePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fFoldersList) {
            if (index == this.getIDX_ADD()) {
                IProject project = this.fCurrJProject.getProject();
                if (project.exists() && this.hasFolders((IContainer)project)) {
                    List existingElements = this.fFoldersList.getElements();
                    BPListElement[] existing = existingElements.toArray(new BPListElement[existingElements.size()]);
                    CreateMultipleSourceFoldersDialog dialog = new CreateMultipleSourceFoldersDialog(this.fCurrJProject, existing, this.getShell());
                    if (dialog.open() == 0) {
                        this.refresh(dialog.getInsertedElements(), dialog.getRemovedElements(), dialog.getModifiedElements());
                    }
                } else {
                    BPListElement newElement = new BPListElement(this.fCurrJProject, 3, false);
                    AddSourceFolderWizard wizard = SourceContainerWorkbookPage.newSourceFolderWizard(newElement, this.fFoldersList.getElements(), true);
                    OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
                    action.run();
                }
            } else if (index == this.getIDX_ADD_LINK()) {
                BPListElement newElement = new BPListElement(this.fCurrJProject, 3, false);
                AddSourceFolderWizard wizard = SourceContainerWorkbookPage.newLinkedSourceFolderWizard(newElement, this.fFoldersList.getElements(), true);
                OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
                action.run();
            } else if (index == this.getIDX_EDIT()) {
                this.editEntry();
            } else if (index == this.getIDX_REMOVE()) {
                this.removeEntry();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasFolders(IContainer container) {
        List elements;
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IContainer) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        if ((elements = this.fFoldersList.getElements()).size() > 1) {
            return true;
        }
        if (elements.size() == 0) {
            return false;
        }
        BPListElement single = (BPListElement)elements.get(0);
        return !single.getPath().equals((Object)this.fCurrJProject.getPath());
    }

    private void editEntry() {
        List selElements = this.fFoldersList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fFoldersList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((BPListElement)elem);
        } else if (elem instanceof BPListElementAttribute) {
            this.editAttributeEntry((BPListElementAttribute)elem);
        }
    }

    private void editElementEntry(BPListElement elem) {
        if (elem.getLinkTarget() != null) {
            AddSourceFolderWizard wizard = SourceContainerWorkbookPage.newLinkedSourceFolderWizard(elem, this.fFoldersList.getElements(), false);
            OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
            action.run();
        } else {
            AddSourceFolderWizard wizard = SourceContainerWorkbookPage.newSourceFolderWizard(elem, this.fFoldersList.getElements(), false);
            OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
            action.run();
        }
    }

    private void editAttributeEntry(BPListElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("exclusion") || key.equals("inclusion")) {
            EditFilterWizard wizard = SourceContainerWorkbookPage.newEditFilterWizard(elem.getParent(), this.fFoldersList.getElements());
            OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
            action.run();
            this.fFoldersList.refresh();
            this.fBuildpathList.dialogFieldChanged();
        }
    }

    protected void sourcePageSelectionChanged(DialogField field) {
        List selected = this.fFoldersList.getSelectedElements();
        this.fFoldersList.enableButton(this.getIDX_EDIT(), this.canEdit(selected));
        this.fFoldersList.enableButton(this.getIDX_REMOVE(), this.canRemove(selected));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selected);
        this.fFoldersList.enableButton(this.getIDX_ADD(), noAttributes);
    }

    private void removeEntry() {
        List selElements = this.fFoldersList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof BPListElementAttribute) {
                BPListElementAttribute attrib = (BPListElementAttribute)elem;
                String key = attrib.getKey();
                Path[] value = null;
                if (key.equals("exclusion") || key.equals("inclusion")) {
                    value = new Path[]{};
                }
                attrib.getParent().setAttribute(key, value);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fFoldersList.refresh();
            this.fBuildpathList.dialogFieldChanged();
        } else {
            Iterator iter = selElements.iterator();
            while (iter.hasNext()) {
                BPListElement element = (BPListElement)iter.next();
                if (element.getEntryKind() != 3) continue;
                List list = BuildpathModifier.removeFilters(element.getPath(), this.fCurrJProject, this.fFoldersList.getElements());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    BPListElement modified = (BPListElement)iterator.next();
                    this.fFoldersList.refresh(modified);
                    this.fFoldersList.expandElement(modified, 3);
                }
            }
            this.fFoldersList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            BPListElement curr;
            BPListElementAttribute attrib;
            String key;
            Object elem = selElements.get(i);
            if (elem instanceof BPListElementAttribute ? ("inclusion".equals(key = (attrib = (BPListElementAttribute)elem).getKey()) ? ((IPath[])attrib.getValue()).length == 0 : ("exclusion".equals(key) ? ((IPath[])attrib.getValue()).length == 0 : attrib.getValue() == null)) : elem instanceof BPListElement && (curr = (BPListElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof BPListElement) {
            BPListElement cp = (BPListElement)elem;
            return !cp.getPath().equals((Object)cp.getScriptProject().getPath());
        }
        return elem instanceof BPListElementAttribute;
    }

    private void sourcePageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject == null) {
            return;
        }
        if (field == this.fFoldersList) {
            this.updateBuildpathList();
        }
    }

    private void updateBuildpathList() {
        int nEntries;
        List srcelements = this.fFoldersList.getElements();
        List cpelements = this.fBuildpathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int afterLastSourcePos = 0;
        int i = nEntries - 1;
        while (i >= 0) {
            BPListElement cpe = (BPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind)) {
                if (!srcelements.remove(cpe)) {
                    cpelements.remove(i);
                    lastRemovePos = i;
                } else if (lastRemovePos == nEntries) {
                    afterLastSourcePos = i + 1;
                }
            }
            --i;
        }
        if (!srcelements.isEmpty()) {
            int insertPos = Math.min(afterLastSourcePos, lastRemovePos);
            cpelements.addAll(insertPos, srcelements);
        }
        if (lastRemovePos != nEntries || !srcelements.isEmpty()) {
            this.fBuildpathList.setElements(cpelements);
        }
    }

    public List getSelection() {
        return this.fFoldersList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fFoldersList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fFoldersList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    public boolean isEntryKind(int kind) {
        return kind == 3;
    }

    protected void refresh(List insertedElements, List removedElements, List modifiedElements) {
        BPListElement element;
        this.fFoldersList.addElements(insertedElements);
        Iterator iter = insertedElements.iterator();
        while (iter.hasNext()) {
            element = (BPListElement)iter.next();
            this.fFoldersList.expandElement(element, 3);
        }
        this.fFoldersList.removeElements(removedElements);
        iter = modifiedElements.iterator();
        while (iter.hasNext()) {
            element = (BPListElement)iter.next();
            this.fFoldersList.refresh(element);
            this.fFoldersList.expandElement(element, 3);
        }
        this.fFoldersList.refresh();
        if (!insertedElements.isEmpty()) {
            this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(insertedElements));
        }
    }

    public class OpenBuildPathWizardAction
    extends AbstractOpenWizardAction
    implements IPropertyChangeListener {
        private final BuildPathWizard fWizard;
        private final List fSelectedElements;

        public OpenBuildPathWizardAction(BuildPathWizard wizard) {
            this.fWizard = wizard;
            this.addPropertyChangeListener(this);
            this.fSelectedElements = SourceContainerWorkbookPage.this.fFoldersList.getSelectedElements();
        }

        protected INewWizard createWizard() throws CoreException {
            return this.fWizard;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("result")) {
                if (event.getNewValue().equals(Boolean.TRUE)) {
                    this.finishWizard();
                } else {
                    this.fWizard.cancel();
                }
            }
        }

        protected void finishWizard() {
            List insertedElements = this.fWizard.getInsertedElements();
            SourceContainerWorkbookPage.this.refresh(insertedElements, this.fWizard.getRemovedElements(), this.fWizard.getModifiedElements());
            if (insertedElements.isEmpty()) {
                SourceContainerWorkbookPage.this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(this.fSelectedElements));
            }
        }
    }

    public class SourceContainerAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        public void customButtonPressed(TreeListDialogField field, int index) {
            SourceContainerWorkbookPage.this.sourcePageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            SourceContainerWorkbookPage.this.sourcePageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            SourceContainerWorkbookPage.this.sourcePageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            SourceContainerWorkbookPage.this.sourcePageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof BPListElement) {
                return ((BPListElement)element).getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof BPListElementAttribute) {
                return ((BPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element instanceof BPListElement;
        }

        public void dialogFieldChanged(DialogField field) {
            SourceContainerWorkbookPage.this.sourcePageDialogFieldChanged(field);
        }
    }
}

