/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.dltk.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListLabelProvider;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathBasePage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildpathOrderingWorkbookPage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.FolderSelectionDialog;
import org.eclipse.dltk.internal.ui.wizards.buildpath.LibrariesWorkbookPage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.ProjectsWorkbookPage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.SourceContainerWorkbookPage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.NewSourceContainerWorkbookPage;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.viewsupport.ImageDisposer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.views.navigator.ResourceComparator;

public abstract class BuildpathsBlock {
    protected IWorkspaceRoot fWorkspaceRoot;
    protected CheckedListDialogField fBuildPathList;
    protected StringButtonDialogField fBuildPathDialogField;
    protected StatusInfo fPathStatus;
    protected StatusInfo fBuildPathStatus;
    protected IScriptProject fCurrScriptProject;
    protected IStatusChangeListener fContext;
    protected Control fSWTWidget;
    protected TabFolder fTabFolder;
    protected int fPageIndex;
    protected BuildPathBasePage fSourceContainerPage;
    protected ProjectsWorkbookPage fProjectsPage;
    protected LibrariesWorkbookPage fLibrariesPage;
    protected BuildPathBasePage fCurrPage;
    protected String fUserSettingsTimeStamp;
    protected long fFileTimeStamp;
    protected IRunnableContext fRunnableContext;
    protected boolean fUseNewPage;
    protected final IWorkbenchPreferenceContainer fPageContainer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BuildpathsBlock(IRunnableContext runnableContext, IStatusChangeListener context, int pageToShow, boolean useNewPage, IWorkbenchPreferenceContainer pageContainer) {
        this.fPageContainer = pageContainer;
        this.fWorkspaceRoot = DLTKUIPlugin.getWorkspace().getRoot();
        this.fContext = context;
        this.fUseNewPage = useNewPage;
        this.fPageIndex = pageToShow;
        this.fSourceContainerPage = null;
        this.fLibrariesPage = null;
        this.fProjectsPage = null;
        this.fCurrPage = null;
        this.fRunnableContext = runnableContext;
        BuildPathAdapter adapter = new BuildPathAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.BuildPathsBlock_buildpath_up_button;
        stringArray[1] = NewWizardMessages.BuildPathsBlock_buildpath_down_button;
        stringArray[3] = NewWizardMessages.BuildPathsBlock_buildpath_checkall_button;
        stringArray[4] = NewWizardMessages.BuildPathsBlock_buildpath_uncheckall_button;
        String[] buttonLabels = stringArray;
        this.fBuildPathList = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new BPListLabelProvider());
        this.fBuildPathList.setDialogFieldListener(adapter);
        this.fBuildPathList.setLabelText(NewWizardMessages.BuildPathsBlock_buildpath_label);
        this.fBuildPathList.setUpButtonIndex(0);
        this.fBuildPathList.setDownButtonIndex(1);
        this.fBuildPathList.setCheckAllButtonIndex(3);
        this.fBuildPathList.setUncheckAllButtonIndex(4);
        this.fBuildPathDialogField = new StringButtonDialogField(adapter);
        this.fBuildPathDialogField.setButtonLabel(NewWizardMessages.BuildPathsBlock_buildpath_button);
        this.fBuildPathDialogField.setDialogFieldListener(adapter);
        this.fBuildPathDialogField.setLabelText(NewWizardMessages.BuildPathsBlock_buildpath_label);
        this.fBuildPathStatus = new StatusInfo();
        this.fPathStatus = new StatusInfo();
        this.fCurrScriptProject = null;
    }

    protected abstract boolean supportZips();

    public Control createControl(Composite parent) {
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(composite.getFont());
        TabItem item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_source);
        item.setImage(DLTKPluginImages.get("org.eclipse.dltk.ui.packagefolder_obj.gif"));
        this.fSourceContainerPage = this.fUseNewPage ? new NewSourceContainerWorkbookPage(this.fBuildPathList, this.fRunnableContext, this.getPreferenceStore()) : new SourceContainerWorkbookPage(this.fBuildPathList);
        item.setData((Object)this.fSourceContainerPage);
        item.setControl(this.fSourceContainerPage.getControl((Composite)folder));
        IWorkbench workbench = DLTKUIPlugin.getDefault().getWorkbench();
        Image projectImage = workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fProjectsPage = new ProjectsWorkbookPage(this.fBuildPathList, this.fPageContainer);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_projects);
        item.setImage(projectImage);
        item.setData((Object)this.fProjectsPage);
        item.setControl(this.fProjectsPage.getControl((Composite)folder));
        this.fLibrariesPage = new LibrariesWorkbookPage(this.supportZips(), this.fBuildPathList, this.fPageContainer);
        this.fLibrariesPage.setScriptProject(this.getScriptProject());
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_libraries);
        item.setImage(DLTKPluginImages.get("org.eclipse.dltk.ui.library_obj.gif"));
        item.setData((Object)this.fLibrariesPage);
        item.setControl(this.fLibrariesPage.getControl((Composite)folder));
        Image cpoImage = DLTKPluginImages.DESC_TOOL_BUILDPATH_ORDER.createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(cpoImage));
        BuildpathOrderingWorkbookPage ordpage = new BuildpathOrderingWorkbookPage(this.fBuildPathList);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_order);
        item.setImage(cpoImage);
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        if (this.fCurrScriptProject != null) {
            this.fSourceContainerPage.init(this.fCurrScriptProject);
            this.fLibrariesPage.init(this.fCurrScriptProject);
            this.fProjectsPage.init(this.fCurrScriptProject);
        }
        folder.setSelection(this.fPageIndex);
        this.fCurrPage = (BuildPathBasePage)folder.getItem(this.fPageIndex).getData();
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildpathsBlock.this.tabChanged(e.item);
            }
        });
        this.fTabFolder = folder;
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }

    public void init(IScriptProject jproject, IBuildpathEntry[] buildpathEntries) {
        this.fCurrScriptProject = jproject;
        boolean projectExists = false;
        List newBuildpath = null;
        IProject project = this.fCurrScriptProject.getProject();
        boolean bl = projectExists = project.exists() && project.getFile(".buildpath").exists();
        if (projectExists && buildpathEntries == null) {
            buildpathEntries = this.fCurrScriptProject.readRawBuildpath();
        }
        if (buildpathEntries != null) {
            newBuildpath = this.getExistingEntries(buildpathEntries);
        }
        if (newBuildpath == null) {
            newBuildpath = this.getDefaultBuildpath(jproject);
        }
        ArrayList<BPListElement> exportedEntries = new ArrayList<BPListElement>();
        int i = 0;
        while (i < newBuildpath.size()) {
            BPListElement curr = (BPListElement)newBuildpath.get(i);
            if (curr.isExported() || curr.getEntryKind() == 3) {
                exportedEntries.add(curr);
            }
            ++i;
        }
        this.fBuildPathDialogField.enableButton(project.exists());
        this.fBuildPathList.setElements(newBuildpath);
        this.fBuildPathList.setCheckedElements(exportedEntries);
        this.initializeTimeStamps();
        this.updateUI();
    }

    protected void updateUI() {
        if (this.fSWTWidget == null || this.fSWTWidget.isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.doUpdateUI();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (BuildpathsBlock.this.fSWTWidget == null || BuildpathsBlock.this.fSWTWidget.isDisposed()) {
                        return;
                    }
                    BuildpathsBlock.this.doUpdateUI();
                }
            });
        }
    }

    protected void doUpdateUI() {
        this.fBuildPathDialogField.refresh();
        this.fBuildPathList.refresh();
        if (this.fSourceContainerPage != null) {
            this.fSourceContainerPage.init(this.fCurrScriptProject);
            this.fProjectsPage.init(this.fCurrScriptProject);
            this.fLibrariesPage.init(this.fCurrScriptProject);
        }
        this.doStatusLineUpdate();
    }

    private String getEncodedSettings() {
        StringBuffer buf = new StringBuffer();
        int nElements = this.fBuildPathList.getSize();
        buf.append('[').append(nElements).append(']');
        int i = 0;
        while (i < nElements) {
            BPListElement elem = (BPListElement)this.fBuildPathList.getElement(i);
            elem.appendEncodedSettings(buf);
            ++i;
        }
        return buf.toString();
    }

    public boolean hasChangesInDialog() {
        String currSettings = this.getEncodedSettings();
        return !currSettings.equals(this.fUserSettingsTimeStamp);
    }

    public boolean hasChangesInBuildpathFile() {
        IFile file = this.fCurrScriptProject.getProject().getFile(".buildpath");
        return this.fFileTimeStamp != file.getModificationStamp();
    }

    public void initializeTimeStamps() {
        IFile file = this.fCurrScriptProject.getProject().getFile(".buildpath");
        this.fFileTimeStamp = file.getModificationStamp();
        this.fUserSettingsTimeStamp = this.getEncodedSettings();
    }

    private ArrayList getExistingEntries(IBuildpathEntry[] buildpathEntries) {
        ArrayList<BPListElement> newBuildpath = new ArrayList<BPListElement>();
        int i = 0;
        while (i < buildpathEntries.length) {
            IBuildpathEntry curr = buildpathEntries[i];
            newBuildpath.add(BPListElement.createFromExisting(curr, this.fCurrScriptProject));
            ++i;
        }
        return newBuildpath;
    }

    public IScriptProject getScriptProject() {
        return this.fCurrScriptProject;
    }

    public IBuildpathEntry[] getRawBuildPath() {
        List elements = this.fBuildPathList.getElements();
        int nElements = elements.size();
        IBuildpathEntry[] entries = new IBuildpathEntry[elements.size()];
        int i = 0;
        while (i < nElements) {
            BPListElement currElement = (BPListElement)elements.get(i);
            entries[i] = currElement.getBuildpathEntry();
            ++i;
        }
        return entries;
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    protected abstract IPreferenceStore getPreferenceStore();

    private List getDefaultBuildpath(IScriptProject jproj) {
        ArrayList<BPListElement> list = new ArrayList<BPListElement>();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            String sourceFolderName = store.getString("com.xore.dltk.ui.wizards.srcFoldersSrcName");
            Object srcFolder = store.getBoolean("com.xore.dltk.ui.wizards.srcBinFoldersInNewProjects") && sourceFolderName.length() > 0 ? jproj.getProject().getFolder(sourceFolderName) : jproj.getProject();
            list.add(new BPListElement(jproj, 3, srcFolder.getFullPath(), (IResource)srcFolder, false));
        }
        if (DLTKCore.DEBUG) {
            System.err.println("Add default library");
        }
        return list;
    }

    private void buildPathChangeControlPressed(DialogField field) {
        IContainer container;
        if (field == this.fBuildPathDialogField && (container = this.chooseContainer()) != null) {
            this.fBuildPathDialogField.setText(container.getFullPath().toString());
        }
    }

    private void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fBuildPathList) {
            this.updatePathStatus();
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        if (Display.getCurrent() != null) {
            IStatus res = this.findMostSevereStatus();
            this.fContext.statusChanged(res);
        }
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fPathStatus, this.fBuildPathStatus});
    }

    public void updatePathStatus() {
        this.fPathStatus.setOK();
        List elements = this.fBuildPathList.getElements();
        BPListElement entryMissing = null;
        int nEntriesMissing = 0;
        IBuildpathEntry[] entries = new IBuildpathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            BPListElement currElement = (BPListElement)elements.get(i);
            boolean isChecked = this.fBuildPathList.isChecked(currElement);
            if (currElement.getEntryKind() == 3) {
                if (!isChecked) {
                    this.fBuildPathList.setCheckedWithoutUpdate(currElement, true);
                }
                if (!this.fBuildPathList.isGrayed(currElement)) {
                    this.fBuildPathList.setGrayedWithoutUpdate(currElement, true);
                }
            } else {
                currElement.setExported(isChecked);
            }
            entries[i] = currElement.getBuildpathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fPathStatus.setWarning(Messages.format(NewWizardMessages.BuildPathsBlock_warning_EntryMissing, entryMissing.getPath().toString()));
            } else {
                this.fPathStatus.setWarning(Messages.format(NewWizardMessages.BuildPathsBlock_warning_EntriesMissing, String.valueOf(nEntriesMissing)));
            }
        }
        this.updateBuildPathStatus();
    }

    protected void updateBuildPathStatus() {
        List elements = this.fBuildPathList.getElements();
        IBuildpathEntry[] entries = new IBuildpathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            BPListElement currElement = (BPListElement)elements.get(i);
            entries[i] = currElement.getBuildpathEntry();
            --i;
        }
        IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)this.fCurrScriptProject, (IBuildpathEntry[])entries);
        if (!status.isOK()) {
            this.fBuildPathStatus.setError(status.getMessage());
            return;
        }
        this.fBuildPathStatus.setOK();
    }

    /*
     * Exception decompiling
     */
    public static void createProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 150->154)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void addScriptNature(IProject project, IProgressMonitor monitor, String nature) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!DLTKLanguageManager.hasScriptNature((IProject)project.getProject())) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = nature;
            if (DLTKCore.DEBUG) {
                System.err.println("Add selection of possible natures here");
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public void configureScriptProject(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        BuildpathsBlock.flush(this.fBuildPathList.getElements(), this.getScriptProject(), monitor);
        this.initializeTimeStamps();
        this.updateUI();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void flush(List buildpathEntries, IScriptProject javaProject, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(NewWizardMessages.BuildPathsBlock_operationdesc_Script);
        monitor.beginTask("", buildpathEntries.size() * 4 + 4);
        try {
            IBuildpathEntry[] buildpath;
            block21: {
                IProject project = javaProject.getProject();
                IPath projPath = project.getFullPath();
                monitor.worked(1);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                int nEntries = buildpathEntries.size();
                buildpath = new IBuildpathEntry[nEntries];
                int i = 0;
                Iterator iter = buildpathEntries.iterator();
                while (true) {
                    block22: {
                        block24: {
                            IFolder orginalFolder;
                            IFolder folder;
                            BPListElement entry;
                            block26: {
                                IPath orginalPath;
                                block25: {
                                    if (!iter.hasNext()) break block21;
                                    entry = (BPListElement)iter.next();
                                    buildpath[i] = entry.getBuildpathEntry();
                                    ++i;
                                    IResource res = entry.getResource();
                                    if (res instanceof IFolder && entry.getLinkTarget() == null && !res.exists()) {
                                        CoreUtility.createFolder((IFolder)res, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    } else {
                                        monitor.worked(1);
                                    }
                                    if (entry.getEntryKind() != 3) break block24;
                                    monitor.worked(1);
                                    IPath path = entry.getPath();
                                    if (projPath.equals((Object)path)) {
                                        monitor.worked(2);
                                        continue;
                                    }
                                    if (projPath.isPrefixOf(path)) {
                                        path = path.removeFirstSegments(projPath.segmentCount());
                                    }
                                    folder = project.getFolder(path);
                                    orginalPath = entry.getOrginalPath();
                                    if (orginalPath != null) break block25;
                                    if (!folder.exists()) {
                                        if (entry.getLinkTarget() == null) {
                                            CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                                            break block22;
                                        } else {
                                            folder.createLink(entry.getLinkTarget(), 16, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                                        }
                                    }
                                    break block22;
                                }
                                if (projPath.isPrefixOf(orginalPath)) {
                                    orginalPath = orginalPath.removeFirstSegments(projPath.segmentCount());
                                }
                                orginalFolder = project.getFolder(orginalPath);
                                if (entry.getLinkTarget() != null) break block26;
                                if (!folder.exists()) {
                                    IPath parentPath = entry.getPath().removeLastSegments(1);
                                    if (projPath.isPrefixOf(parentPath)) {
                                        parentPath = parentPath.removeFirstSegments(projPath.segmentCount());
                                    }
                                    if (parentPath.segmentCount() > 0) {
                                        IFolder parentFolder = project.getFolder(parentPath);
                                        if (!parentFolder.exists()) {
                                            CoreUtility.createFolder(parentFolder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                        } else {
                                            monitor.worked(1);
                                        }
                                    } else {
                                        monitor.worked(1);
                                    }
                                    orginalFolder.move(entry.getPath(), true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                break block22;
                            }
                            if (!folder.exists() || !entry.getLinkTarget().equals((Object)entry.getOrginalLinkTarget())) {
                                orginalFolder.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                folder.createLink(entry.getLinkTarget(), 16, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            break block22;
                        }
                        monitor.worked(3);
                    }
                    if (monitor.isCanceled()) break;
                }
                throw new OperationCanceledException();
            }
            javaProject.setRawBuildpath(buildpath, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var17_19 = null;
        }
        monitor.done();
    }

    public static boolean hasClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            return true;
        }
        if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                if (BuildpathsBlock.hasClassfiles(members[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void removeOldClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            resource.delete(false, null);
        } else if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                BuildpathsBlock.removeOldClassfiles(members[i]);
                ++i;
            }
        }
    }

    public static IRemoveOldBinariesQuery getRemoveOldBinariesQuery(final Shell shell) {
        return new IRemoveOldBinariesQuery(){

            public boolean doQuery(IPath oldOutputLocation) throws OperationCanceledException {
                int[] res = new int[]{1};
                Display.getDefault().syncExec(new Runnable(this, shell, oldOutputLocation, res){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ IPath val$oldOutputLocation;
                    private final /* synthetic */ int[] val$res;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$oldOutputLocation = iPath;
                        this.val$res = nArray;
                    }

                    public void run() {
                        Shell sh = this.val$shell != null ? this.val$shell : DLTKUIPlugin.getActiveWorkbenchShell();
                        String title = NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_title;
                        String message = Messages.format(NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_description, this.val$oldOutputLocation.toString());
                        MessageDialog dialog = new MessageDialog(sh, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                        this.val$res[0] = dialog.open();
                    }
                });
                if (res[0] == 0) {
                    return true;
                }
                if (res[0] == 1) {
                    return false;
                }
                throw new OperationCanceledException();
            }
        };
    }

    private IContainer chooseContainer() {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        IProject[] allProjects = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fCurrScriptProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        Object initSelection = null;
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(NewWizardMessages.BuildPathsBlock_ChooseOutputFolderDialog_title);
        dialog.setValidator(validator);
        dialog.setMessage(NewWizardMessages.BuildPathsBlock_ChooseOutputFolderDialog_description);
        dialog.addFilter(filter);
        dialog.setInput(this.fWorkspaceRoot);
        dialog.setInitialSelection(initSelection);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            return (IContainer)dialog.getFirstResult();
        }
        return null;
    }

    protected void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List selection;
            TabItem tabItem = (TabItem)widget;
            BuildPathBasePage newPage = (BuildPathBasePage)tabItem.getData();
            if (this.fCurrPage != null && !(selection = this.fCurrPage.getSelection()).isEmpty()) {
                newPage.setSelection(selection, false);
            }
            this.fCurrPage = newPage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    private int getPageIndex(int entryKind) {
        switch (entryKind) {
            case 1: 
            case 2: 
            case 5: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    private BPListElement findElement(IBuildpathEntry entry) {
        int i = 0;
        int len = this.fBuildPathList.getSize();
        while (i < len) {
            BPListElement curr = (BPListElement)this.fBuildPathList.getElement(i);
            if (curr.getEntryKind() == entry.getEntryKind() && curr.getPath().equals((Object)entry.getPath())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public void setElementToReveal(IBuildpathEntry entry, String attributeKey) {
        int pageIndex = this.getPageIndex(entry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = pageIndex;
        } else {
            this.fTabFolder.setSelection(pageIndex);
            BPListElement element = this.findElement(entry);
            if (element != null) {
                BPListElementAttribute attrib;
                Object elementToSelect = element;
                if (attributeKey != null && (attrib = element.findAttributeElement(attributeKey)) != null) {
                    elementToSelect = attrib;
                }
                BuildPathBasePage page = (BuildPathBasePage)this.fTabFolder.getItem(pageIndex).getData();
                ArrayList<Object> selection = new ArrayList<Object>(1);
                selection.add(elementToSelect);
                page.setSelection(selection, true);
            }
        }
    }

    public void addElement(IBuildpathEntry entry) {
        int pageIndex = this.getPageIndex(entry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = pageIndex;
        } else {
            this.fTabFolder.setSelection(pageIndex);
            Object page = this.fTabFolder.getItem(pageIndex).getData();
            if (page instanceof LibrariesWorkbookPage) {
                BPListElement element = BPListElement.createFromExisting(entry, this.fCurrScriptProject);
                ((LibrariesWorkbookPage)page).addElement(element);
            }
        }
    }

    private class BuildPathAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private BuildPathAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            BuildpathsBlock.this.buildPathChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            BuildpathsBlock.this.buildPathDialogFieldChanged(field);
        }
    }

    public static interface IRemoveOldBinariesQuery {
        public boolean doQuery(IPath var1) throws OperationCanceledException;
    }
}

