/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;

public class VirtualCopyToClipboardActionDelegate
extends AbstractDebugActionDelegate {
    private ContentViewer fViewer;
    private static final String TAB = "\t";
    private static final String SEPARATOR = "line.separator";
    static /* synthetic */ Class class$0;

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            IDebugView adapter;
            IViewPart iViewPart = this.getView();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IDebugView)iViewPart.getAdapter((Class)clazz)) != null) {
                if (adapter.getViewer() instanceof ContentViewer) {
                    this.setViewer((ContentViewer)adapter.getViewer());
                }
                adapter.setAction(this.getActionId(), action);
            }
            return super.initialize(action, selection);
        }
        return false;
    }

    protected String getActionId() {
        return IDebugView.COPY_ACTION;
    }

    protected void append(InternalTreeModelViewer.VirtualElement item, StringBuffer buffer, int indent) {
        int i = 0;
        while (i < indent) {
            buffer.append(TAB);
            ++i;
        }
        String[] labels = item.getLabel();
        int count = labels.length;
        if (count > 0) {
            int i2 = 0;
            while (i2 < count) {
                String text = labels[i2];
                if (text != null && !text.trim().equals("")) {
                    buffer.append(String.valueOf(text) + TAB);
                }
                ++i2;
            }
            buffer.append(System.getProperty(SEPARATOR));
        }
    }

    public void run(IAction action) {
        if (this.fViewer instanceof InternalTreeModelViewer) {
            InternalTreeModelViewer viewer = (InternalTreeModelViewer)this.fViewer;
            TreeItem[] items = this.getPrunedSelection();
            TreePath root = null;
            int[] indexes = null;
            if (items.length != 0) {
                TreeItem anItem = items[0];
                TreeItem rootItem = anItem.getParentItem();
                root = rootItem == null ? TreePath.EMPTY : viewer.getTreePathFromItem((Item)rootItem);
                indexes = new int[items.length];
                int i = 0;
                while (i < items.length) {
                    TreeItem child = items[i];
                    indexes[i] = rootItem == null ? viewer.getTree().indexOf(child) : rootItem.indexOf(child);
                    ++i;
                }
            }
            final InternalTreeModelViewer.VirtualModel model = viewer.buildVirtualModel(root, indexes);
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.fViewer.getControl().getShell());
            IProgressMonitor monitor = dialog.getProgressMonitor();
            dialog.setCancelable(true);
            final String[] columns = viewer.getPresentationContext().getColumns();
            final Object[] result = new Object[1];
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor m) throws InvocationTargetException, InterruptedException {
                    result[0] = model.populate(m, DebugUIPlugin.removeAccelerators(VirtualCopyToClipboardActionDelegate.this.getAction().getText()), columns);
                }
            };
            try {
                dialog.run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                DebugUIPlugin.log(e);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            InternalTreeModelViewer.VirtualElement modelRoot = (InternalTreeModelViewer.VirtualElement)result[0];
            if (!monitor.isCanceled()) {
                if (root != null) {
                    int depth = root.getSegmentCount();
                    int i = 0;
                    while (i < depth) {
                        InternalTreeModelViewer.VirtualElement[] children = modelRoot.getChildren();
                        int j = 0;
                        while (j < children.length) {
                            InternalTreeModelViewer.VirtualElement ve = children[j];
                            if (ve != null) {
                                modelRoot = ve;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                StringBuffer buffer = new StringBuffer();
                InternalTreeModelViewer.VirtualElement[] children = modelRoot.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i] != null) {
                        this.copy(children[i], buffer, 0);
                    }
                    ++i;
                }
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                Clipboard clipboard = new Clipboard(this.fViewer.getControl().getDisplay());
                try {
                    this.doCopy(clipboard, plainTextTransfer, buffer);
                }
                finally {
                    clipboard.dispose();
                }
            }
        }
    }

    protected void copy(InternalTreeModelViewer.VirtualElement item, StringBuffer buffer, int indent) {
        if (!item.isFiltered()) {
            this.append(item, buffer, indent);
            InternalTreeModelViewer.VirtualElement[] children = item.getChildren();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    this.copy(children[i], buffer, indent + 1);
                    ++i;
                }
            }
        }
    }

    protected void doCopy(Clipboard clipboard, TextTransfer plainTextTransfer, StringBuffer buffer) {
        block3: {
            try {
                clipboard.setContents((Object[])new String[]{buffer.toString()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fViewer.getControl().getShell(), (String)ActionMessages.CopyToClipboardActionDelegate_Problem_Copying_to_Clipboard_1, (String)ActionMessages.CopyToClipboardActionDelegate_There_was_a_problem_when_accessing_the_system_clipboard__Retry__2)) break block3;
                this.doCopy(clipboard, plainTextTransfer, buffer);
            }
        }
    }

    protected TreeItem[] getPrunedSelection() {
        Control control = this.fViewer.getControl();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        if (control instanceof Tree) {
            Tree tree = (Tree)control;
            TreeItem[] selection = tree.getSelection();
            int i = 0;
            while (i < selection.length) {
                TreeItem item = selection[i];
                if (this.isEnabledFor(item.getData()) && this.walkHierarchy(item, items)) {
                    items.add(item);
                }
                ++i;
            }
        }
        return items.toArray(new TreeItem[items.size()]);
    }

    protected boolean walkHierarchy(TreeItem item, List elements) {
        TreeItem parent = item.getParentItem();
        if (parent == null) {
            return true;
        }
        if (elements.contains(parent)) {
            return false;
        }
        return this.walkHierarchy(parent, elements);
    }

    protected ContentViewer getViewer() {
        return this.fViewer;
    }

    protected void setViewer(ContentViewer viewer) {
        this.fViewer = viewer;
    }

    protected void doAction(Object element) {
    }
}

