/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class ConsoleTerminateAction
extends Action
implements IUpdate {
    private ProcessConsole fConsole;

    public ConsoleTerminateAction(ProcessConsole console) {
        super(ConsoleMessages.ConsoleTerminateAction_0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.console_terminate_action_context");
        this.fConsole = console;
        this.setToolTipText(ConsoleMessages.ConsoleTerminateAction_1);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_TERMINATE"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_TERMINATE"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_TERMINATE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.console_terminate_action_context");
        this.update();
    }

    public void update() {
        IProcess process = this.fConsole.getProcess();
        this.setEnabled(process.canTerminate());
    }

    public void run() {
        try {
            IProcess process = this.fConsole.getProcess();
            this.killTargets(process);
            process.terminate();
        }
        catch (DebugException debugException) {}
    }

    private void killTargets(IProcess process) throws DebugException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            IProcess[] processes = launch.getProcesses();
            int j = 0;
            while (j < processes.length) {
                IProcess process2 = processes[j];
                if (process2.equals(process)) {
                    IDebugTarget[] debugTargets = launch.getDebugTargets();
                    int k = 0;
                    while (k < debugTargets.length) {
                        IDebugTarget target = debugTargets[k];
                        if (target.canTerminate()) {
                            target.terminate();
                        }
                        ++k;
                    }
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public void dispose() {
        this.fConsole = null;
    }
}

