/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatechecker;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.updatechecker.Activator;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateChecker;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateListener;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.UpdateEvent;
import org.osgi.framework.BundleContext;

public class UpdateChecker
implements IUpdateChecker {
    public static boolean DEBUG = false;
    public static boolean TRACE = false;
    private HashSet checkers = new HashSet();
    IProfileRegistry profileRegistry;
    IPlanner planner;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void addUpdateCheck(String profileId, Query query, long delay, long poll, IUpdateListener listener) {
        this.log("Adding update checker for " + profileId + " at " + this.getTimeStamp());
        UpdateCheckThread thread = new UpdateCheckThread(profileId, query, delay, poll, listener);
        this.checkers.add(thread);
        thread.start();
    }

    public void removeUpdateCheck(IUpdateListener listener) {
        Iterator iter = this.checkers.iterator();
        while (iter.hasNext()) {
            UpdateCheckThread thread = (UpdateCheckThread)iter.next();
            if (thread.listener != listener) continue;
            thread.done = true;
            this.checkers.remove(thread);
            break;
        }
    }

    IInstallableUnit[] checkForUpdates(String profileId, Query query) {
        IProfile profile = this.getProfileRegistry().getProfile(profileId);
        ArrayList<IInstallableUnit> iusWithUpdates = new ArrayList<IInstallableUnit>();
        if (profile == null) {
            return new IInstallableUnit[0];
        }
        ProvisioningContext context = new ProvisioningContext(this.getAvailableRepositories());
        if (query == null) {
            query = InstallableUnitQuery.ANY;
        }
        Iterator iter = profile.query(query, new Collector(), null).iterator();
        while (iter.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iter.next();
            IInstallableUnit[] replacements = this.getPlanner().updatesFor(iu, context, null);
            if (replacements.length <= 0) continue;
            iusWithUpdates.add(iu);
        }
        return iusWithUpdates.toArray(new IInstallableUnit[iusWithUpdates.size()]);
    }

    private URL[] getAvailableRepositories() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMetadataRepositoryManager repoMgr = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        URL[] repositories = repoMgr.getKnownRepositories(0);
        ArrayList<URL> available = new ArrayList<URL>();
        int i = 0;
        while (i < repositories.length) {
            try {
                repoMgr.loadRepository(repositories[i], null);
                available.add(repositories[i]);
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        return available.toArray(new URL[available.size()]);
    }

    void log(String string, Throwable e) {
        System.err.println(String.valueOf(string) + ": " + e);
        if (DEBUG) {
            e.printStackTrace();
        }
    }

    void log(String string) {
        if (TRACE) {
            System.out.println(string);
        }
    }

    String getTimeStamp() {
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("[MM/dd/yy;HH:mm:ss:SSS]");
        return df.format(d);
    }

    IPlanner getPlanner() {
        if (this.planner == null) {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IPlanner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.planner = (IPlanner)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
            if (this.planner == null) {
                throw new IllegalStateException("Provisioning system has not been initialized");
            }
        }
        return this.planner;
    }

    IProfileRegistry getProfileRegistry() {
        if (this.profileRegistry == null) {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
            if (this.profileRegistry == null) {
                throw new IllegalStateException("Provisioning system has not been initialized");
            }
        }
        return this.profileRegistry;
    }

    private class UpdateCheckThread
    extends Thread {
        boolean done = false;
        long poll;
        long delay;
        IUpdateListener listener;
        String profileId;
        Query query;

        UpdateCheckThread(String profileId, Query query, long delay, long poll, IUpdateListener listener) {
            this.poll = poll;
            this.delay = delay;
            this.profileId = profileId;
            this.query = query;
            this.listener = listener;
        }

        public void run() {
            try {
                if (this.delay != -1L && this.delay > 0L) {
                    Thread.sleep(this.delay);
                }
                while (!this.done) {
                    UpdateChecker.this.log("Checking for updates for " + this.profileId + " at " + UpdateChecker.this.getTimeStamp());
                    IInstallableUnit[] iusWithUpdates = UpdateChecker.this.checkForUpdates(this.profileId, this.query);
                    if (iusWithUpdates.length > 0) {
                        UpdateChecker.this.log("Notifying listener of available updates");
                        UpdateEvent event = new UpdateEvent(this.profileId, iusWithUpdates);
                        if (!this.done) {
                            this.listener.updatesAvailable(event);
                        }
                    } else {
                        UpdateChecker.this.log("No updates were available");
                    }
                    if (this.delay == -1L || this.delay <= 0L) {
                        this.done = true;
                        continue;
                    }
                    Thread.sleep(this.poll);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                UpdateChecker.this.log("Exception in update check thread", e);
            }
        }
    }
}

