/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.touchpoint.natives.BackupFiles;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.osgi.util.NLS;

public class Zip {
    public File[] unzip(String source, String destination, String backupDir) {
        File zipFile = new File(source);
        if (zipFile == null || !zipFile.exists()) {
            Util.log(String.valueOf(this.getClass().getName()) + " the files to be unzipped is not here");
        }
        if (backupDir != null) {
            try {
                BackupFiles backupFiles = new BackupFiles(new File(backupDir));
                backupFiles.backupFilesInZip(backupDir, zipFile.toURL(), new File(destination), null);
            }
            catch (IOException iOException) {
                Util.log(String.valueOf(this.getClass().getName()) + " something went wrong when backing up the files");
            }
        }
        try {
            String taskName = NLS.bind((String)Messages.unzipping, (Object)source);
            return FileUtils.unzipFile((File)zipFile, (File)new File(destination), (String)taskName, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException iOException) {
            Util.log(String.valueOf(this.getClass().getName()) + " something went wrong when unzipping");
            Util.log("zipfile: " + zipFile.getAbsolutePath());
            Util.log("destination: " + destination);
            return null;
        }
    }
}

