/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.ReplaceConfigurationPage;
import org.eclipse.search.internal.ui.text.ReplaceRefactoring;
import org.eclipse.swt.widgets.Shell;

public class ReplaceAction
extends Action {
    private final FileSearchResult fResult;
    private final Object[] fSelection;
    private final boolean fSkipFiltered;
    private final Shell fShell;

    public ReplaceAction(Shell shell, FileSearchResult result, Object[] selection, boolean skipFiltered) {
        this.fShell = shell;
        this.fResult = result;
        this.fSelection = selection;
        this.fSkipFiltered = skipFiltered;
    }

    public void run() {
        try {
            ReplaceRefactoring refactoring = new ReplaceRefactoring(this.fResult, this.fSelection, this.fSkipFiltered);
            ReplaceWizard refactoringWizard = new ReplaceWizard(refactoring);
            if (this.fSelection == null) {
                refactoringWizard.setDefaultPageTitle(SearchMessages.ReplaceAction_title_all);
            } else {
                refactoringWizard.setDefaultPageTitle(SearchMessages.ReplaceAction_title_selected);
            }
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)refactoringWizard);
            op.run(this.fShell, SearchMessages.ReplaceAction_description_operation);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static class ReplaceWizard
    extends RefactoringWizard {
        public ReplaceWizard(ReplaceRefactoring refactoring) {
            super((Refactoring)refactoring, 4);
        }

        protected void addUserInputPages() {
            this.addPage((IWizardPage)new ReplaceConfigurationPage((ReplaceRefactoring)this.getRefactoring()));
        }
    }
}

