/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.TypeFilteringDialog;

public class FileTypeEditor
extends SelectionAdapter
implements DisposeListener,
SelectionListener {
    private Combo fTextField;
    private Button fBrowseButton;
    private static final String TYPE_DELIMITER = SearchMessages.FileTypeEditor_typeDelimiter;
    public static final String FILE_PATTERN_NEGATOR = "!";
    private static final Comparator FILE_TYPES_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return this.compare((String)o1, (String)o2);
        }

        public int compare(String fp1, String fp2) {
            boolean isNegative2;
            boolean isNegative1 = fp1.startsWith(FileTypeEditor.FILE_PATTERN_NEGATOR);
            if (isNegative1 != (isNegative2 = fp2.startsWith(FileTypeEditor.FILE_PATTERN_NEGATOR))) {
                return isNegative1 ? 1 : -1;
            }
            return fp1.compareTo(fp2);
        }
    };

    public FileTypeEditor(Combo textField, Button browseButton) {
        this.fTextField = textField;
        this.fBrowseButton = browseButton;
        this.fTextField.addDisposeListener((DisposeListener)this);
        this.fBrowseButton.addDisposeListener((DisposeListener)this);
        this.fBrowseButton.addSelectionListener((SelectionListener)this);
    }

    public void widgetDisposed(DisposeEvent event) {
        Widget widget = event.widget;
        if (widget == this.fTextField) {
            this.fTextField = null;
        } else if (widget == this.fBrowseButton) {
            this.fBrowseButton = null;
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.fBrowseButton) {
            this.handleBrowseButton();
        }
    }

    public String[] getFileTypes() {
        HashSet<String> result = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.fTextField.getText(), TYPE_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String currentExtension = tokenizer.nextToken().trim();
            result.add(currentExtension);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setFileTypes(String[] types) {
        this.fTextField.setText(FileTypeEditor.typesToString(types));
    }

    protected void handleBrowseButton() {
        TypeFilteringDialog dialog = new TypeFilteringDialog(this.fTextField.getShell(), Arrays.asList(this.getFileTypes()));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            HashSet<String> patterns = new HashSet<String>();
            boolean starIncluded = false;
            int i = 0;
            while (i < result.length) {
                String curr = result[i].toString();
                if (curr.equals("*")) {
                    starIncluded = true;
                } else {
                    patterns.add("*." + curr);
                }
                ++i;
            }
            if (patterns.isEmpty() && starIncluded) {
                patterns.add("*");
            }
            Object[] filePatterns = patterns.toArray(new String[patterns.size()]);
            Arrays.sort(filePatterns);
            this.setFileTypes((String[])filePatterns);
        }
    }

    public static String typesToString(String[] types) {
        Arrays.sort(types, FILE_TYPES_COMPARATOR);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                result.append(TYPE_DELIMITER);
                result.append(" ");
            }
            result.append(types[i]);
            ++i;
        }
        return result.toString();
    }
}

