/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.LazyManipulator;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.MetadataGeneratorUtils;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.PlatformConfigurationWrapper;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.SourceManipulator;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.ActionFactory;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.Touchpoint;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointType;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class EclipseTouchpoint
extends Touchpoint {
    private static final TouchpointType TOUCHPOINT_TYPE = MetadataFactory.createTouchpointType((String)"org.eclipse.equinox.p2.osgi", (Version)new Version("1.0"));
    public static final String INSTALL_PHASE_ID = "install";
    public static final String UNINSTALL_PHASE_ID = "uninstall";
    public static final String PROFILE_PROP_LAUNCHER_NAME = "eclipse.touchpoint.launcherName";
    public static final String PARM_MANIPULATOR = "manipulator";
    public static final String PARM_PLATFORM_CONFIGURATION = "platformConfiguration";
    public static final String PARM_SOURCE_BUNDLES = "sourceBundles";
    public static final String PARM_IU = "iu";
    public static final String PARM_INSTALL_FOLDER = "installFolder";

    public IStatus completePhase(IProgressMonitor monitor, IProfile profile, String phaseId, Map touchpointParameters) {
        Manipulator manipulator = (Manipulator)touchpointParameters.get(PARM_MANIPULATOR);
        try {
            manipulator.save(false);
        }
        catch (RuntimeException e) {
            return Util.createError(Messages.error_saving_manipulator, e);
        }
        catch (IOException e) {
            return Util.createError(Messages.error_saving_manipulator, e);
        }
        if (INSTALL_PHASE_ID.equals(phaseId) || UNINSTALL_PHASE_ID.equals(phaseId)) {
            PlatformConfigurationWrapper configuration = (PlatformConfigurationWrapper)touchpointParameters.get(PARM_PLATFORM_CONFIGURATION);
            try {
                configuration.save();
            }
            catch (ProvisionException pe) {
                return Util.createError(Messages.error_saving_platform_configuration, (Exception)((Object)pe));
            }
        }
        SourceManipulator m = (SourceManipulator)touchpointParameters.get(PARM_SOURCE_BUNDLES);
        try {
            m.save();
        }
        catch (IOException e) {
            return Util.createError(Messages.error_saving_source_bundles_list, e);
        }
        return Status.OK_STATUS;
    }

    public ProvisioningAction getAction(String actionId) {
        return ActionFactory.create(actionId);
    }

    public TouchpointType getTouchpointType() {
        return TOUCHPOINT_TYPE;
    }

    public IStatus initializePhase(IProgressMonitor monitor, IProfile profile, String phaseId, Map touchpointParameters) {
        touchpointParameters.put(PARM_INSTALL_FOLDER, Util.getInstallFolder(profile));
        LazyManipulator manipulator = new LazyManipulator(profile);
        touchpointParameters.put(PARM_MANIPULATOR, manipulator);
        touchpointParameters.put(PARM_SOURCE_BUNDLES, new SourceManipulator(profile));
        File configLocation = Util.getConfigurationFolder(profile);
        URL poolURL = Util.getBundlePoolLocation(profile);
        touchpointParameters.put(PARM_PLATFORM_CONFIGURATION, new PlatformConfigurationWrapper(configLocation, poolURL, manipulator));
        return null;
    }

    public IStatus initializeOperand(IProfile profile, String phaseId, InstallableUnitOperand operand, Map parameters) {
        IInstallableUnit iu = (IInstallableUnit)parameters.get(PARM_IU);
        if (iu != null && Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu")).booleanValue()) {
            IInstallableUnit preparedIU = this.prepareIU(iu, profile);
            if (preparedIU == null) {
                return Util.createError(NLS.bind((String)Messages.failed_prepareIU, (Object)iu));
            }
            parameters.put(PARM_IU, preparedIU);
        }
        return Status.OK_STATUS;
    }

    private IInstallableUnit prepareIU(IInstallableUnit iu, IProfile profile) {
        Class<?> c = null;
        try {
            c = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.generator.MetadataGeneratorHelper");
            if (c != null) {
                c = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(NLS.bind((String)Messages.generator_not_available, (Object)e.getMessage()));
        }
        if (c != null) {
            IArtifactKey[] artifacts = iu.getArtifacts();
            if (artifacts == null || artifacts.length == 0) {
                return iu;
            }
            IArtifactKey artifactKey = artifacts[0];
            if (artifactKey == null) {
                return iu;
            }
            File bundleFile = Util.getArtifactFile(artifactKey, profile);
            if (bundleFile == null) {
                LogHelper.log((IStatus)Util.createError(NLS.bind((String)Messages.artifact_file_not_found, (Object)artifactKey.toString())));
                return null;
            }
            return MetadataGeneratorUtils.createBundleIU(artifactKey, bundleFile);
        }
        throw new IllegalStateException(Messages.unexpected_prepareiu_error);
    }

    public static IStatus loadManipulator(Manipulator manipulator) {
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            return Util.createError(Messages.error_loading_manipulator);
        }
        catch (FrameworkAdminRuntimeException frameworkAdminRuntimeException) {
            return Util.createError(Messages.error_loading_manipulator);
        }
        catch (IOException iOException) {
            return Util.createError(Messages.error_loading_manipulator);
        }
        return Status.OK_STATUS;
    }
}

