/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.util.HandleFactory;

public class ValidatorUtils {
    private static final HandleFactory factory = new HandleFactory();

    public static void processResourcesToElements(Object o, Set elements, Set resources) {
        if (o instanceof IResource) {
            HashSet els;
            block16: {
                els = new HashSet();
                ResourceVisitor visitor = new ResourceVisitor(els);
                try {
                    ((IResource)o).accept((IResourceVisitor)visitor);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block16;
                    e.printStackTrace();
                }
            }
            Iterator iterator = els.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                Object eo = ValidatorUtils.convertResourceToModelElement(object);
                if (eo == null) continue;
                if (eo instanceof IModelElement) {
                    elements.add(eo);
                    continue;
                }
                if (!(eo instanceof IResource)) continue;
                resources.add(eo);
            }
        } else if (o instanceof IModelElement) {
            if (o instanceof IParent) {
                SourceModuleVisitor visitor = new SourceModuleVisitor(elements);
                try {
                    ((IModelElement)o).accept((IModelElementVisitor)visitor);
                }
                catch (ModelException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
            } else if (!(o instanceof ISourceModule)) {
                ISourceModule module = (ISourceModule)((IModelElement)o).getAncestor(5);
                if (module != null) {
                    elements.add(module);
                }
            } else if (o instanceof ISourceModule) {
                elements.add(o);
            }
        }
    }

    private static Object convertResourceToModelElement(Object o) {
        if (o instanceof IModelElement) {
            return o;
        }
        if (!(o instanceof IResource)) {
            return null;
        }
        IResource res = (IResource)o;
        IProject project = res.getProject();
        if (!DLTKLanguageManager.hasScriptNature((IProject)project)) {
            return null;
        }
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        Openable element = factory.createOpenable(res.getFullPath().toString(), scope);
        if (element != null && element.getElementType() == 5 && element.exists()) {
            return element;
        }
        return res;
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    private static class ResourceVisitor
    implements IResourceVisitor {
        private Set resources;

        public ResourceVisitor(Set resources) {
            this.resources = resources;
        }

        public boolean visit(IResource resource) {
            if (!this.resources.contains(resource) && resource.getType() == 1) {
                this.resources.add(resource);
                return false;
            }
            return true;
        }
    }

    private static class SourceModuleVisitor
    implements IModelElementVisitor {
        private Set elements;

        public SourceModuleVisitor(Set elements) {
            this.elements = elements;
        }

        public boolean visit(IModelElement element) {
            if (element.getElementType() == 3 && (element instanceof ExternalProjectFragment || element instanceof BuiltinProjectFragment)) {
                return false;
            }
            if (element.getElementType() == 5 && !(element instanceof ExternalSourceModule) && !(element instanceof BuiltinSourceModule) && element.getResource() != null) {
                if (!this.elements.contains(element)) {
                    this.elements.add(element);
                }
                return false;
            }
            return true;
        }
    }
}

