/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.metadata.generator.features.DefaultSiteParser;
import org.eclipse.equinox.internal.p2.metadata.generator.features.DigestParser;
import org.eclipse.equinox.internal.p2.metadata.generator.features.FeatureParser;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteFeature;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteModel;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.ECFTransport;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Feature;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.FeatureEntry;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.URLEntry;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class UpdateSite {
    private static final String VERSION_SEPARATOR = "_";
    private static final String JAR_EXTENSION = ".jar";
    private static final String FEATURE_DIR = "features/";
    private static final String PLUGIN_DIR = "plugins/";
    private static final String FEATURE_TEMP_FILE = "feature";
    private static final String SITE_FILE = "site.xml";
    private static final String DIR_SEPARATOR = "/";
    private static final String PROTOCOL_FILE = "file";
    private static final int RETRY_COUNT = 2;
    private static final String DOT_XML = ".xml";
    private static final String SITE = "site";
    private String checksum;
    private URL location;
    private SiteModel site;
    private static Map siteCache = new HashMap();
    private Map featureCache = new HashMap();

    public static URL getFileURL(URL root, String fileName) throws MalformedURLException {
        String path = root.getPath();
        if (path.endsWith(fileName)) {
            return root;
        }
        if (UpdateSite.constainsUpdateSiteFileName(path)) {
            return new URL(root, fileName);
        }
        if (path.endsWith(DIR_SEPARATOR)) {
            return new URL(String.valueOf(root.toExternalForm()) + fileName);
        }
        return new URL(String.valueOf(root.toExternalForm()) + DIR_SEPARATOR + fileName);
    }

    private static URL getSiteURL(URL url) throws MalformedURLException {
        String path = url.getPath();
        if (UpdateSite.constainsUpdateSiteFileName(path)) {
            return url;
        }
        if (path.endsWith(DIR_SEPARATOR)) {
            return new URL(String.valueOf(url.toExternalForm()) + SITE_FILE);
        }
        return new URL(String.valueOf(url.toExternalForm()) + DIR_SEPARATOR + SITE_FILE);
    }

    private static boolean constainsUpdateSiteFileName(String path) {
        if (path.endsWith(DOT_XML)) {
            String lastSegment;
            int lastSlash = path.lastIndexOf(47);
            String string = lastSegment = lastSlash == -1 ? path : path.substring(lastSlash + 1);
            if (lastSegment.indexOf(SITE) != -1) {
                return true;
            }
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized UpdateSite load(URL location, IProgressMonitor monitor) throws ProvisionException {
        UpdateSite updateSite;
        if (location == null) {
            return null;
        }
        UpdateSite result = (UpdateSite)siteCache.get(location.toExternalForm());
        if (result != null) {
            return result;
        }
        InputStream input = null;
        File siteFile = UpdateSite.loadSiteFile(location, monitor);
        try {
            DefaultSiteParser siteParser = new DefaultSiteParser();
            CRC32 checksum = new CRC32();
            input = new CheckedInputStream(new BufferedInputStream(new FileInputStream(siteFile)), checksum);
            SiteModel siteModel = siteParser.parse(input);
            String checksumString = Long.toString(checksum.getValue());
            result = new UpdateSite(siteModel, UpdateSite.getSiteURL(location), checksumString);
            siteCache.put(location.toExternalForm(), result);
            updateSite = result;
        }
        catch (SAXException e) {
            try {
                String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
                throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, (Throwable)e));
                catch (IOException e2) {
                    msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
                    throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, (Throwable)e2));
                }
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
                if (!PROTOCOL_FILE.equals(location.getProtocol())) {
                    siteFile.delete();
                }
                throw throwable;
            }
        }
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {}
        if (!PROTOCOL_FILE.equals(location.getProtocol())) {
            siteFile.delete();
        }
        return updateSite;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File loadSiteFile(URL location, IProgressMonitor monitor) throws ProvisionException {
        void var2_12;
        String msg;
        block15: {
            IStatus transferResult;
            File siteFile = null;
            boolean deleteSiteFile = false;
            try {
                URL actualLocation = UpdateSite.getSiteURL(location);
                if (PROTOCOL_FILE.equals(actualLocation.getProtocol())) {
                    siteFile = new File(actualLocation.getPath());
                    if (siteFile.exists()) {
                        transferResult = Status.OK_STATUS;
                    } else {
                        msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
                        transferResult = new Status(4, Activator.ID, msg, (Throwable)new FileNotFoundException(siteFile.getAbsolutePath()));
                    }
                } else {
                    deleteSiteFile = true;
                    siteFile = File.createTempFile(SITE, DOT_XML);
                    BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(siteFile));
                    transferResult = UpdateSite.getTransport().download(actualLocation.toExternalForm(), destination, monitor);
                }
                if (transferResult.isOK()) {
                    deleteSiteFile = false;
                    File file = siteFile;
                    if (!deleteSiteFile || siteFile == null) return file;
                    siteFile.delete();
                    return file;
                }
            }
            catch (IOException e) {
                IOException iOException = e;
                if (deleteSiteFile && siteFile != null) {
                    siteFile.delete();
                }
                break block15;
            }
            catch (Throwable throwable) {
                if (!deleteSiteFile || siteFile == null) throw throwable;
                siteFile.delete();
                throw throwable;
            }
            {
                Throwable throwable = transferResult.getException();
            }
            if (deleteSiteFile && siteFile != null) {
                siteFile.delete();
            }
        }
        int code = var2_12 instanceof FileNotFoundException ? 1000 : 1002;
        msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
        throw new ProvisionException((IStatus)new Status(4, Activator.ID, code, msg, (Throwable)var2_12));
    }

    private static Feature parseFeature(FeatureParser featureParser, URL featureURL) {
        File featureFile = null;
        if (PROTOCOL_FILE.equals(featureURL.getProtocol())) {
            featureFile = new File(featureURL.getPath());
            return featureParser.parse(featureFile);
        }
        try {
            featureFile = File.createTempFile(FEATURE_TEMP_FILE, JAR_EXTENSION);
            IStatus transferResult = null;
            int i = 0;
            while (i < 2) {
                BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(featureFile));
                transferResult = UpdateSite.getTransport().download(featureURL.toExternalForm(), destination, null);
                if (transferResult.isOK()) break;
                ++i;
            }
            if (!transferResult.isOK()) {
                LogHelper.log((ProvisionException)new ProvisionException(transferResult));
                return null;
            }
            Feature feature = featureParser.parse(featureFile);
            return feature;
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.ErrorReadingFeature, (Object)featureURL), (Throwable)e));
        }
        finally {
            if (featureFile != null) {
                featureFile.delete();
            }
        }
        return null;
    }

    public static void validate(URL url, IProgressMonitor monitor) throws ProvisionException {
        try {
            URL siteURL = UpdateSite.getSiteURL(url);
            long lastModified = UpdateSite.getTransport().getLastModified(siteURL);
            if (lastModified == 0L) {
                String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)url);
                throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, null));
            }
        }
        catch (MalformedURLException e) {
            String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)url);
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, (Throwable)e));
        }
    }

    private UpdateSite(SiteModel site, URL location, String checksum) {
        this.site = site;
        this.location = location;
        this.checksum = checksum;
    }

    private URL getArchiveURL(URL base, String identifier) {
        URLEntry[] archives = this.site.getArchives();
        int i = 0;
        while (archives != null && i < archives.length) {
            URLEntry entry = archives[i];
            if (identifier.equals(entry.getAnnotation())) {
                return this.internalGetURL(base, entry.getURL());
            }
            ++i;
        }
        return null;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public URL getSiteFeatureURL(SiteFeature siteFeature) {
        URL url = siteFeature.getURL();
        if (url != null) {
            return url;
        }
        URL base = this.getBaseURL();
        String featureURLString = siteFeature.getURLString();
        return this.internalGetURL(base, featureURLString);
    }

    public URL getFeatureURL(String id, String version) {
        SiteFeature[] entries = this.site.getFeatures();
        int i = 0;
        while (i < entries.length) {
            if (id.equals(entries[i].getFeatureIdentifier()) && version.equals(entries[i].getFeatureVersion())) {
                return this.getSiteFeatureURL(entries[i]);
            }
            ++i;
        }
        URL base = this.getBaseURL();
        URL url = this.getArchiveURL(base, FEATURE_DIR + id + VERSION_SEPARATOR + version + JAR_EXTENSION);
        if (url != null) {
            return url;
        }
        try {
            return UpdateSite.getFileURL(base, FEATURE_DIR + id + VERSION_SEPARATOR + version + JAR_EXTENSION);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getLocation() {
        return this.location;
    }

    public String getMirrorsURL() {
        String mirrors = this.site.getMirrorsURL();
        if (mirrors == null) {
            return null;
        }
        int index = mirrors.indexOf(SITE_FILE);
        if (index != -1) {
            mirrors = String.valueOf(mirrors.substring(0, index)) + mirrors.substring(index + SITE_FILE.length());
        }
        return mirrors;
    }

    public URL getPluginURL(FeatureEntry plugin) {
        String path;
        URL base = this.getBaseURL();
        URL url = this.getArchiveURL(base, path = PLUGIN_DIR + plugin.getId() + VERSION_SEPARATOR + plugin.getVersion() + JAR_EXTENSION);
        if (url != null) {
            return url;
        }
        try {
            return UpdateSite.getFileURL(base, path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private URL getBaseURL() {
        URL base = null;
        String siteURLString = this.site.getLocationURLString();
        if (siteURLString != null) {
            if (!siteURLString.endsWith(DIR_SEPARATOR)) {
                siteURLString = String.valueOf(siteURLString) + DIR_SEPARATOR;
            }
            base = this.internalGetURL(this.location, siteURLString);
        }
        if (base == null) {
            base = this.location;
        }
        return base;
    }

    public SiteModel getSite() {
        return this.site;
    }

    private URL internalGetURL(URL base, String trailing) {
        if (trailing == null) {
            return null;
        }
        try {
            return new URL(trailing);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new URL(base, trailing);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    public synchronized Feature[] loadFeatures() throws ProvisionException {
        Feature[] result = this.loadFeaturesFromDigest();
        return result == null ? this.loadFeaturesFromSite() : result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Feature[] loadFeaturesFromDigest() {
        File digestFile = null;
        boolean local = false;
        if (!this.featureCache.isEmpty()) {
            return this.featureCache.values().toArray(new Feature[this.featureCache.size()]);
        }
        try {
            URL digestURL = this.getDigestURL();
            if (PROTOCOL_FILE.equals(digestURL.getProtocol())) {
                digestFile = URLUtil.toFile((URL)digestURL);
                if (!digestFile.exists()) {
                    return null;
                }
                local = true;
            } else {
                digestFile = File.createTempFile("digest", ".zip");
                BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(digestFile));
                IStatus result = UpdateSite.getTransport().download(digestURL.toExternalForm(), destination, null);
                if (!result.isOK()) {
                    return null;
                }
            }
            Feature[] features = new DigestParser().parse(digestFile);
            if (features == null) {
                return null;
            }
            int i = 0;
            while (true) {
                if (i >= features.length) {
                    Feature[] featureArray = features;
                    return featureArray;
                }
                String key = String.valueOf(features[i].getId()) + VERSION_SEPARATOR + features[i].getVersion();
                this.featureCache.put(key, features[i]);
                ++i;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (MalformedURLException e) {
            String msg = NLS.bind((String)Messages.InvalidRepositoryLocation, (Object)this.location);
            LogHelper.log((IStatus)new Status(4, Activator.ID, 1006, msg, (Throwable)e));
            return null;
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.ErrorReadingDigest, (Object)this.location), (Throwable)e));
            return null;
        }
        finally {
            if (!local && digestFile != null) {
                digestFile.delete();
            }
        }
    }

    private URL getDigestURL() throws MalformedURLException {
        URL digestBase = this.location;
        String digestURLString = this.site.getDigestURLString();
        if (digestURLString != null) {
            if (!digestURLString.endsWith(DIR_SEPARATOR)) {
                digestURLString = String.valueOf(digestURLString) + DIR_SEPARATOR;
            }
            digestBase = this.internalGetURL(this.location, digestURLString);
        }
        return UpdateSite.getFileURL(digestBase, "digest.zip");
    }

    private Feature[] loadFeaturesFromSite() throws ProvisionException {
        SiteFeature[] siteFeatures = this.site.getFeatures();
        FeatureParser featureParser = new FeatureParser();
        int i = 0;
        while (i < siteFeatures.length) {
            SiteFeature siteFeature = siteFeatures[i];
            String key = null;
            if (siteFeature.getFeatureIdentifier() == null || siteFeature.getFeatureVersion() == null || !this.featureCache.containsKey(key = String.valueOf(siteFeature.getFeatureIdentifier()) + VERSION_SEPARATOR + siteFeature.getFeatureVersion())) {
                URL featureURL = this.getSiteFeatureURL(siteFeature);
                Feature feature = UpdateSite.parseFeature(featureParser, featureURL);
                if (feature == null) {
                    LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.ErrorReadingFeature, (Object)featureURL)));
                } else {
                    if (key == null) {
                        siteFeature.setFeatureIdentifier(feature.getId());
                        siteFeature.setFeatureVersion(feature.getVersion());
                        key = String.valueOf(siteFeature.getFeatureIdentifier()) + VERSION_SEPARATOR + siteFeature.getFeatureVersion();
                    }
                    this.featureCache.put(key, feature);
                    this.loadIncludedFeatures(feature, featureParser);
                }
            }
            ++i;
        }
        return this.featureCache.values().toArray(new Feature[this.featureCache.size()]);
    }

    private void loadIncludedFeatures(Feature feature, FeatureParser featureParser) throws ProvisionException {
        FeatureEntry[] featureEntries = feature.getEntries();
        int i = 0;
        while (i < featureEntries.length) {
            String key;
            FeatureEntry entry = featureEntries[i];
            if (!(entry.isRequires() || entry.isPlugin() || this.featureCache.containsKey(key = String.valueOf(entry.getId()) + VERSION_SEPARATOR + entry.getVersion()))) {
                URL includedFeatureURL = this.getFeatureURL(entry.getId(), entry.getVersion());
                Feature includedFeature = UpdateSite.parseFeature(featureParser, includedFeatureURL);
                if (includedFeature == null) {
                    LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.ErrorReadingFeature, (Object)includedFeatureURL)));
                } else {
                    this.featureCache.put(key, includedFeature);
                    this.loadIncludedFeatures(includedFeature, featureParser);
                }
            }
            ++i;
        }
    }

    private static ECFTransport getTransport() {
        return ECFTransport.getInstance();
    }
}

