/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.rse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.internal.rse.DLTKRSEPlugin;
import org.eclipse.dltk.core.internal.rse.Messages;
import org.eclipse.dltk.core.internal.rse.MyHostShellProcessAdapter;
import org.eclipse.dltk.core.internal.rse.RSEEnvironment;
import org.eclipse.dltk.core.internal.rse.perfomance.RSEPerfomanceStatistics;
import org.eclipse.dltk.internal.launching.execution.EFSDeployment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.efs.RSEFileSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;

public class RSEExecEnvironment
implements IExecutionEnvironment {
    private static final String SHELL_PATH = "exec /bin/sh";
    private static final String CMD_SEPARATOR = " ;";
    private static final String EXPORT_CMD = "export ";
    private static final String EXIT_CMD = "exit";
    private static final String SET_CMD = "set";
    private final RSEEnvironment environment;
    private static int counter = -1;
    private static final Map hostToEnvironment = new HashMap();

    public RSEExecEnvironment(RSEEnvironment env) {
        this.environment = env;
    }

    public IDeployment createDeployment() {
        block4: {
            if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
                RSEPerfomanceStatistics.inc(4);
            }
            try {
                String tmpDir = this.getTempDir();
                if (tmpDir != null) {
                    String rootPath = String.valueOf(tmpDir) + this.environment.getSeparator() + this.getTempName("dltk", ".tmp");
                    URI rootUri = this.createRemoteURI(this.environment.getHost(), rootPath);
                    return new EFSDeployment((IEnvironment)this.environment, rootUri);
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }

    private URI createRemoteURI(IHost host, String rootPath) {
        return RSEFileSystem.getURIFor((String)host.getHostName(), (String)rootPath);
    }

    private IShellServiceSubSystem getShellServiceSubSystem(IHost host) {
        ISubSystem[] subsys = host.getSubSystems();
        int i = 0;
        while (i < subsys.length) {
            if (subsys[i] instanceof IShellServiceSubSystem) {
                return (IShellServiceSubSystem)subsys[i];
            }
            ++i;
        }
        return null;
    }

    private String getTempName(String prefix, String suffix) {
        if (counter == -1) {
            counter = new Random().nextInt() & 0xFFFF;
        }
        return String.valueOf(prefix) + Integer.toString(++counter) + suffix;
    }

    private String getTempDir() {
        String tmpDir;
        block4: {
            IHost host = this.environment.getHost();
            IShellServiceSubSystem system = this.getShellServiceSubSystem(host);
            if (system == null) {
                DLTKRSEPlugin.logWarning(NLS.bind((String)Messages.RSEExecEnvironment_hostNotFound, (Object)host.getName()));
                return null;
            }
            tmpDir = null;
            try {
                system.connect((IProgressMonitor)new NullProgressMonitor(), false);
                tmpDir = system.getConnectorService().getTempDirectory();
                if (tmpDir.length() == 0) {
                    tmpDir = "/tmp";
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return tmpDir;
    }

    public Process exec(String[] cmdLine, IPath workingDir, String[] environment) throws CoreException {
        if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
            RSEPerfomanceStatistics.inc(2);
        }
        long start = System.currentTimeMillis();
        IShellServiceSubSystem shell = this.getShellServiceSubSystem(this.environment.getHost());
        try {
            shell.connect(null, false);
        }
        catch (Exception e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        if (!shell.isConnected()) {
            return null;
        }
        IShellService shellService = shell.getShellService();
        IHostShell hostShell = null;
        String workingDirectory = null;
        workingDirectory = workingDir != null ? this.environment.convertPathToString(workingDir) : "/";
        try {
            hostShell = shellService.runCommand(workingDirectory, SHELL_PATH, environment, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SystemMessageException e1) {
            DLTKRSEPlugin.log(e1);
            return null;
        }
        if (environment != null) {
            hostShell.writeToShell(SHELL_PATH);
            int i = 0;
            while (i < environment.length) {
                hostShell.writeToShell(EXPORT_CMD + this.toShellArguments(environment[i]));
                ++i;
            }
        }
        String pattern = "DLTK_INITIAL_PREFIX_EXECUTION_STRING:" + String.valueOf(System.currentTimeMillis());
        String echoPattern = "echo \"" + pattern + "\"";
        hostShell.writeToShell(String.valueOf(echoPattern) + CMD_SEPARATOR + this.buildCommand(cmdLine) + CMD_SEPARATOR + echoPattern + CMD_SEPARATOR + EXIT_CMD);
        MyHostShellProcessAdapter p = null;
        try {
            p = new MyHostShellProcessAdapter(hostShell, pattern);
        }
        catch (Exception exception) {
            if (p != null) {
                ((Process)p).destroy();
            }
            throw new RuntimeException("Failed to run remote command");
        }
        if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
            long end = System.currentTimeMillis();
            RSEPerfomanceStatistics.inc(9, end - start);
        }
        return p;
    }

    private String toShellArguments(String cmd) {
        String replaceAll = cmd.replaceAll(" ", "\\\\ ");
        return replaceAll;
    }

    private String buildCommand(String[] cmdLine) {
        StringBuffer cmd = new StringBuffer();
        int i = 0;
        while (i < cmdLine.length) {
            if (i != 0) {
                cmd.append(" ");
            }
            cmd.append(cmdLine[i]);
            ++i;
        }
        return cmd.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getEnvironmentVariables(boolean realyNeed) {
        HashMap result;
        long start;
        block14: {
            if (!realyNeed) {
                return new HashMap();
            }
            start = System.currentTimeMillis();
            Map map = hostToEnvironment;
            synchronized (map) {
                Map result2 = (Map)hostToEnvironment.get(this.environment.getHost());
                if (result2 != null) {
                    return new HashMap(result2);
                }
            }
            result = new HashMap();
            try {
                Process process = this.exec(new String[]{SET_CMD}, (IPath)Path.EMPTY, null);
                if (process == null) break block14;
                final BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            String line;
                            while ((line = input.readLine()) != null) {
                                int pos = (line = line.trim()).indexOf("=");
                                if (pos == -1) continue;
                                String varName = line.substring(0, pos);
                                String varValue = line.substring(pos + 1);
                                result.put(varName, varValue);
                            }
                        }
                        catch (IOException e) {
                            DLTKRSEPlugin.log(e);
                        }
                    }
                });
                t.start();
                try {
                    t.join(25000L);
                }
                catch (InterruptedException e) {
                    DLTKRSEPlugin.log(e);
                }
                process.destroy();
            }
            catch (CoreException e) {
                DLTKRSEPlugin.log(e);
            }
        }
        if (!result.isEmpty()) {
            Map e = hostToEnvironment;
            synchronized (e) {
                hostToEnvironment.put(this.environment.getHost(), Collections.unmodifiableMap(result));
            }
        }
        if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
            long end = System.currentTimeMillis();
            RSEPerfomanceStatistics.inc(6);
            RSEPerfomanceStatistics.inc(5, end - start);
        }
        return result;
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public boolean isValidExecutableAndEquals(String possibleName, IPath path) {
        if (this.environment.getHost().getSystemType().isWindows()) {
            possibleName = possibleName.toLowerCase();
            String fName = path.removeFileExtension().toString().toLowerCase();
            String ext = path.getFileExtension();
            if (possibleName.equals(fName) && ("exe".equalsIgnoreCase(ext) || "bat".equalsIgnoreCase(ext))) {
                return true;
            }
        } else {
            String fName = path.lastSegment();
            if (fName.equals(possibleName)) {
                return true;
            }
        }
        return false;
    }
}

