/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.metadata.repository.Activator;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.IMetadataRepositoryFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class MetadataRepositoryManager
implements IMetadataRepositoryManager,
ProvisioningListener {
    private static final String ATTR_SUFFIX = "suffix";
    private static final String DEFAULT_SUFFIX = "content.xml";
    private static final String EL_FILTER = "filter";
    private static final String FACTORY = "factory";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_NAME = "name";
    private static final String KEY_PROVIDER = "provider";
    private static final String KEY_SUFFIX = "suffix";
    private static final String KEY_SYSTEM = "isSystem";
    private static final String KEY_TYPE = "type";
    private static final String KEY_URL = "url";
    private static final String KEY_VERSION = "version";
    private static final String NODE_REPOSITORIES = "repositories";
    private Map repositories = null;
    private final Object repositoryLock = new Object();
    private SoftReference unavailableRepositories;
    static /* synthetic */ Class class$0;

    public MetadataRepositoryManager() {
        IProvisioningEventBus bus;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bus = (IProvisioningEventBus)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
            bus.addListener((ProvisioningListener)this);
        }
    }

    public void addRepository(IMetadataRepository repository) {
        this.addRepository(repository, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRepository(IMetadataRepository repository, boolean signalAdd, String suffix) {
        boolean added = true;
        Object object = this.repositoryLock;
        synchronized (object) {
            String key;
            RepositoryInfo info;
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            if ((info = (RepositoryInfo)this.repositories.get(key = this.getKey(repository))) == null) {
                info = new RepositoryInfo();
            }
            info.repository = new SoftReference<IMetadataRepository>(repository);
            info.name = repository.getName();
            info.description = repository.getDescription();
            info.location = repository.getLocation();
            String value = (String)repository.getProperties().get("p2.system");
            info.isSystem = value == null ? false : Boolean.valueOf(value);
            info.suffix = suffix;
            added = this.repositories.put(this.getKey(repository), info) == null;
        }
        this.remember(repository, suffix);
        if (added && signalAdd) {
            this.broadcastChangeEvent(repository.getLocation(), 0, 0, true);
        }
    }

    public void addRepository(URL location) {
        this.addRepository(location, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addRepository(URL location, boolean isEnabled, boolean signalAdd) {
        Assert.isNotNull((Object)location);
        RepositoryInfo info = new RepositoryInfo();
        info.location = location;
        info.isEnabled = isEnabled;
        boolean added = true;
        Object object = this.repositoryLock;
        synchronized (object) {
            block6: {
                if (this.repositories == null) {
                    this.restoreRepositories();
                }
                if (!this.contains(location)) break block6;
                return false;
            }
            added = this.repositories.put(this.getKey(location), info) == null;
        }
        this.remember(info);
        if (added && signalAdd) {
            this.broadcastChangeEvent(location, 0, 0, isEnabled);
        }
        return added;
    }

    protected void broadcastChangeEvent(URL location, int repositoryType, int kind, boolean isEnabled) {
        IProvisioningEventBus bus;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bus = (IProvisioningEventBus)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
            bus.publishEvent((EventObject)new RepositoryEvent(location, repositoryType, kind, isEnabled));
        }
    }

    private boolean checkNotFound(URL location) {
        if (this.unavailableRepositories == null) {
            return false;
        }
        List badRepos = (List)this.unavailableRepositories.get();
        if (badRepos == null) {
            return false;
        }
        return badRepos.contains(location);
    }

    private void clearNotFound(URL location) {
        List badRepos;
        if (this.unavailableRepositories != null && (badRepos = (List)this.unavailableRepositories.get()) != null) {
            badRepos.remove(location);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contains(URL location) {
        Object object = this.repositoryLock;
        synchronized (object) {
            String key;
            block5: {
                if (this.repositories == null) {
                    this.restoreRepositories();
                }
                if (!this.repositories.containsKey(key = this.getKey(location))) break block5;
                return true;
            }
            int len = key.length();
            key = key.charAt(len - 1) == '_' ? key.substring(0, len - 1) : String.valueOf(key) + '_';
            return this.repositories.containsKey(key);
        }
    }

    private Object createExecutableExtension(IExtension extension, String element) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        Throwable failure = null;
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equals(element)) {
                try {
                    return elements[i].createExecutableExtension("class");
                }
                catch (CoreException coreException) {
                    this.log("Error loading repository extension: " + extension.getUniqueIdentifier(), failure);
                    return null;
                }
            }
            ++i;
        }
        this.log("Malformed repository extension: " + extension.getUniqueIdentifier(), null);
        return null;
    }

    public IMetadataRepository createRepository(URL location, String name, String type, Map properties) throws ProvisionException {
        IMetadataRepository result;
        IMetadataRepositoryFactory factory;
        IExtension extension;
        Assert.isNotNull((Object)location);
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)type);
        boolean loaded = false;
        try {
            this.loadRepository(location, null, type, true);
            loaded = true;
        }
        catch (ProvisionException provisionException) {}
        if (loaded) {
            this.fail(location, 1001);
        }
        if ((extension = RegistryFactory.getRegistry().getExtension("org.eclipse.equinox.p2.metadata.repository.metadataRepositories", type)) == null) {
            this.fail(location, 1005);
        }
        if ((factory = (IMetadataRepositoryFactory)this.createExecutableExtension(extension, FACTORY)) == null) {
            this.fail(location, 1002);
        }
        if ((result = factory.create(location, name, type, properties)) == null) {
            this.fail(location, 1002);
        }
        this.clearNotFound(location);
        this.addRepository(result);
        return result;
    }

    private void fail(URL location, int code) throws ProvisionException {
        throw new ProvisionException(this.failStatus(location, code));
    }

    private IStatus failStatus(URL location, int code) {
        String msg = null;
        switch (code) {
            case 1001: {
                msg = NLS.bind((String)Messages.repoMan_exists, (Object)location);
                break;
            }
            case 1005: {
                msg = NLS.bind((String)Messages.repoMan_unknownType, (Object)location);
                break;
            }
            case 1002: {
                msg = NLS.bind((String)Messages.repoMan_failedRead, (Object)location);
                break;
            }
            case 1000: {
                msg = NLS.bind((String)Messages.repoMan_notExists, (Object)location);
                break;
            }
            case 1006: {
                msg = NLS.bind((String)Messages.repoMan_invalidLocation, (Object)location);
            }
        }
        if (msg == null) {
            msg = Messages.repoMan_internalError;
        }
        return new Status(4, "org.eclipse.equinox.p2.metadata.repository", code, msg, null);
    }

    private IExtension[] findMatchingRepositoryExtensions(String suffix, String type) {
        IExtension ext;
        IConfigurationElement[] elt = null;
        elt = type != null && type.length() > 0 ? ((ext = RegistryFactory.getRegistry().getExtension("org.eclipse.equinox.p2.metadata.repository.metadataRepositories", type)) != null ? ext.getConfigurationElements() : new IConfigurationElement[]{}) : RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.equinox.p2.metadata.repository.metadataRepositories");
        int count = 0;
        int i = 0;
        while (i < elt.length) {
            if (elt[i].getName().equals(EL_FILTER)) {
                if (!elt[i].getAttribute("suffix").equals(suffix)) {
                    elt[i] = null;
                } else {
                    ++count;
                }
            } else {
                elt[i] = null;
            }
            ++i;
        }
        IExtension[] results = new IExtension[count];
        int i2 = 0;
        while (i2 < elt.length) {
            if (elt[i2] != null) {
                results[--count] = elt[i2].getDeclaringExtension();
            }
            ++i2;
        }
        return results;
    }

    private String[] getAllSuffixes() {
        IConfigurationElement[] elements = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.equinox.p2.metadata.repository.metadataRepositories");
        ArrayList<String> result = new ArrayList<String>(elements.length);
        result.add(DEFAULT_SUFFIX);
        int i = 0;
        while (i < elements.length) {
            String suffix;
            if (elements[i].getName().equals(EL_FILTER) && !result.contains(suffix = elements[i].getAttribute("suffix"))) {
                result.add(suffix);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private String getKey(IMetadataRepository repository) {
        return this.getKey(repository.getLocation());
    }

    private String getKey(URL location) {
        return location.toExternalForm().replace('/', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getKnownRepositories(int flags) {
        Object object = this.repositoryLock;
        synchronized (object) {
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            ArrayList<URL> result = new ArrayList<URL>();
            int i = 0;
            Iterator it = this.repositories.values().iterator();
            while (it.hasNext()) {
                RepositoryInfo info = (RepositoryInfo)it.next();
                if (this.matchesFlags(info, flags)) {
                    result.add(info.location);
                }
                ++i;
            }
            return result.toArray(new URL[result.size()]);
        }
    }

    private Preferences getPreferences() {
        return new ConfigurationScope().getNode("org.eclipse.equinox.p2.metadata.repository").node(NODE_REPOSITORIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMetadataRepository getRepository(URL location) {
        Object object = this.repositoryLock;
        synchronized (object) {
            RepositoryInfo info;
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            Iterator it = this.repositories.values().iterator();
            do {
                if (!it.hasNext()) {
                    return null;
                }
                info = (RepositoryInfo)it.next();
            } while (!URLUtil.sameURL((URL)info.location, (URL)location));
            if (info.repository == null) {
                return null;
            }
            IMetadataRepository repo = (IMetadataRepository)info.repository.get();
            if (repo != null) {
                this.addRepository(repo);
            }
            return repo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRepositoryProperty(URL location, String key) {
        Object object = this.repositoryLock;
        synchronized (object) {
            RepositoryInfo info;
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            Iterator it = this.repositories.values().iterator();
            do {
                if (!it.hasNext()) {
                    return null;
                }
                info = (RepositoryInfo)it.next();
            } while (!URLUtil.sameURL((URL)info.location, (URL)location));
            if (KEY_DESCRIPTION.equals(key)) {
                return info.description;
            }
            if (KEY_NAME.equals(key)) {
                return info.name;
            }
            if ("p2.system".equals(key)) {
                return Boolean.toString(info.isSystem);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(URL location) {
        Object object = this.repositoryLock;
        synchronized (object) {
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            Iterator it = this.repositories.values().iterator();
            while (it.hasNext()) {
                RepositoryInfo info = (RepositoryInfo)it.next();
                if (!URLUtil.sameURL((URL)info.location, (URL)location)) continue;
                return info.isEnabled;
            }
            return false;
        }
    }

    public IMetadataRepository loadRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        return this.loadRepository(location, monitor, null, true);
    }

    private IMetadataRepository loadRepository(URL location, IProgressMonitor monitor, String type, boolean signalAdd) throws ProvisionException {
        Assert.isNotNull((Object)location);
        IMetadataRepository result = this.getRepository(location);
        if (result != null) {
            return result;
        }
        MultiStatus notFoundStatus = new MultiStatus("org.eclipse.equinox.p2.metadata.repository", 1000, NLS.bind((String)Messages.repoMan_notExists, (Object)location.toExternalForm()), null);
        if (this.checkNotFound(location)) {
            throw new ProvisionException((IStatus)notFoundStatus);
        }
        String[] suffixes = this.sortSuffixes(this.getAllSuffixes(), location);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.repoMan_adding, (int)(suffixes.length * 100));
        boolean added = this.addRepository(location, true, false);
        try {
            int i = 0;
            while (i < suffixes.length) {
                result = this.loadRepository(location, suffixes[i], type, sub.newChild(100), notFoundStatus);
                if (result != null) {
                    this.addRepository(result, false, suffixes[i]);
                    if (added && signalAdd) {
                        this.broadcastChangeEvent(location, 0, 0, true);
                    }
                    IMetadataRepository iMetadataRepository = result;
                    return iMetadataRepository;
                }
                ++i;
            }
        }
        finally {
            sub.done();
        }
        if (added) {
            this.removeRepository(location, false);
        }
        if (Boolean.valueOf(this.getRepositoryProperty(location, "p2.system")).booleanValue()) {
            this.removeRepository(location);
        } else {
            this.rememberNotFound(location);
        }
        throw new ProvisionException((IStatus)notFoundStatus);
    }

    private IMetadataRepository loadRepository(URL location, String suffix, String type, SubMonitor monitor, MultiStatus failures) {
        IExtension[] providers = this.findMatchingRepositoryExtensions(suffix, type);
        monitor.beginTask("", providers.length * 10);
        int i = 0;
        while (i < providers.length) {
            block4: {
                IMetadataRepositoryFactory factory = (IMetadataRepositoryFactory)this.createExecutableExtension(providers[i], FACTORY);
                try {
                    if (factory != null) {
                        return factory.load(location, (IProgressMonitor)monitor.newChild(10));
                    }
                }
                catch (ProvisionException e) {
                    if (e.getStatus().getCode() == 1000) break block4;
                    failures.add(e.getStatus());
                }
            }
            ++i;
        }
        return null;
    }

    protected void log(String message, Throwable t) {
        LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", message, t));
    }

    private boolean matchesFlags(RepositoryInfo info, int flags) {
        if ((flags & 1) == 1 && !info.isSystem) {
            return false;
        }
        if ((flags & 2) == 2 && info.isSystem) {
            return false;
        }
        if ((flags & 8) == 8 ? info.isEnabled : !info.isEnabled) {
            return false;
        }
        if ((flags & 4) == 4) {
            return "file".equals(info.location.getProtocol());
        }
        return true;
    }

    public void notify(EventObject o) {
        RepositoryEvent event;
        if (o instanceof RepositoryEvent && (event = (RepositoryEvent)o).getKind() == 4 && event.getRepositoryType() == 0) {
            this.addRepository(event.getRepositoryLocation(), event.isRepositoryEnabled(), true);
        }
    }

    private boolean putValue(Preferences node, String key, String newValue) {
        String oldValue = node.get(key, null);
        if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
            return false;
        }
        if (newValue == null) {
            node.remove(key);
        } else {
            node.put(key, newValue);
        }
        return true;
    }

    public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        URL[] locations = this.getKnownRepositories(0);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(locations.length * 10));
        int i = 0;
        while (i < locations.length) {
            try {
                this.loadRepository(locations[i], (IProgressMonitor)sub.newChild(9)).query(query, collector, (IProgressMonitor)sub.newChild(1));
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        sub.done();
        return collector;
    }

    public IMetadataRepository refreshRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        this.clearNotFound(location);
        boolean wasEnabled = this.isEnabled(location);
        if (!this.removeRepository(location)) {
            this.fail(location, 1000);
        }
        try {
            IMetadataRepository result = this.loadRepository(location, monitor, null, true);
            if (!wasEnabled) {
                this.setEnabled(location, false);
            }
            return result;
        }
        catch (ProvisionException e) {
            this.addRepository(location);
            if (!wasEnabled) {
                this.setEnabled(location, false);
            }
            throw e;
        }
    }

    private boolean remember(IMetadataRepository repository, String suffix) {
        boolean changed = false;
        Preferences node = this.getPreferences().node(this.getKey(repository));
        changed |= this.putValue(node, KEY_URL, repository.getLocation().toExternalForm());
        changed |= this.putValue(node, KEY_DESCRIPTION, repository.getDescription());
        changed |= this.putValue(node, KEY_NAME, repository.getName());
        changed |= this.putValue(node, KEY_PROVIDER, repository.getProvider());
        changed |= this.putValue(node, KEY_TYPE, repository.getType());
        changed |= this.putValue(node, KEY_VERSION, repository.getVersion());
        changed |= this.putValue(node, KEY_SYSTEM, (String)repository.getProperties().get("p2.system"));
        if (changed |= this.putValue(node, "suffix", suffix)) {
            this.saveToPreferences();
        }
        return changed;
    }

    private boolean remember(RepositoryInfo info) {
        boolean changed = false;
        Preferences node = this.getPreferences().node(this.getKey(info.location));
        changed |= this.putValue(node, KEY_URL, info.location.toExternalForm());
        changed |= this.putValue(node, KEY_SYSTEM, Boolean.toString(info.isSystem));
        changed |= this.putValue(node, KEY_DESCRIPTION, info.description);
        changed |= this.putValue(node, KEY_NAME, info.name);
        changed |= this.putValue(node, "suffix", info.suffix);
        if (changed |= this.putValue(node, KEY_ENABLED, Boolean.toString(info.isEnabled))) {
            this.saveToPreferences();
        }
        return changed;
    }

    private void rememberNotFound(URL location) {
        List<URL> badRepos;
        if (this.unavailableRepositories != null && (badRepos = (List)this.unavailableRepositories.get()) != null) {
            badRepos.add(location);
            return;
        }
        badRepos = new ArrayList();
        badRepos.add(location);
        this.unavailableRepositories = new SoftReference(badRepos);
    }

    public boolean removeRepository(URL toRemove) {
        return this.removeRepository(toRemove, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeRepository(URL toRemove, boolean signalRemove) {
        Assert.isNotNull((Object)toRemove);
        String repoKey = this.getKey(toRemove);
        Object object = this.repositoryLock;
        synchronized (object) {
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            if (this.repositories.remove(repoKey) == null) {
                return false;
            }
        }
        try {
            this.getPreferences().node(repoKey).removeNode();
            this.saveToPreferences();
        }
        catch (BackingStoreException e) {
            this.log("Error saving preferences", e);
        }
        if (signalRemove) {
            this.broadcastChangeEvent(toRemove, 0, 1, true);
        }
        return true;
    }

    private void restoreFromPreferences() {
        String[] children;
        Preferences node = this.getPreferences();
        try {
            children = node.childrenNames();
        }
        catch (BackingStoreException e) {
            this.log("Error restoring repositories from preferences", e);
            return;
        }
        int i = 0;
        while (i < children.length) {
            Preferences child = node.node(children[i]);
            String locationString = child.get(KEY_URL, null);
            if (locationString != null) {
                try {
                    RepositoryInfo info = new RepositoryInfo();
                    info.location = new URL(locationString);
                    info.name = child.get(KEY_NAME, null);
                    info.description = child.get(KEY_DESCRIPTION, null);
                    info.isSystem = child.getBoolean(KEY_SYSTEM, false);
                    info.isEnabled = child.getBoolean(KEY_ENABLED, true);
                    info.suffix = child.get("suffix", null);
                    this.repositories.put(this.getKey(info.location), info);
                }
                catch (MalformedURLException e) {
                    this.log("Error while restoring repository: " + locationString, e);
                }
            }
            ++i;
        }
    }

    private void restoreFromSystemProperty() {
        String locationString = Activator.getContext().getProperty("eclipse.p2.metadataRepository");
        if (locationString == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(locationString, ",");
        while (tokenizer.hasMoreTokens()) {
            String pathString = tokenizer.nextToken();
            try {
                RepositoryInfo info = new RepositoryInfo();
                info.location = new URL(pathString);
                this.repositories.put(this.getKey(info.location), info);
            }
            catch (MalformedURLException e) {
                this.log("Error while restoring repository " + pathString, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreRepositories() {
        Object object = this.repositoryLock;
        synchronized (object) {
            this.repositories = new HashMap();
            this.restoreFromSystemProperty();
            this.restoreFromPreferences();
        }
    }

    private void saveToPreferences() {
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            this.log("Error while saving repositories in preferences", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(URL location, boolean enablement) {
        Object object = this.repositoryLock;
        synchronized (object) {
            RepositoryInfo info;
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            if ((info = (RepositoryInfo)this.repositories.get(this.getKey(location))) == null || info.isEnabled == enablement) {
                return;
            }
            info.isEnabled = enablement;
            this.remember(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] sortSuffixes(String[] suffixes, URL location) {
        Object object = this.repositoryLock;
        synchronized (object) {
            RepositoryInfo info;
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            if ((info = (RepositoryInfo)this.repositories.get(this.getKey(location))) == null || info.suffix == null) {
                return suffixes;
            }
            String lastSuffix = info.suffix;
            int i = 0;
            while (i < suffixes.length) {
                if (lastSuffix.equals(suffixes[i])) {
                    System.arraycopy(suffixes, 0, suffixes, 1, i);
                    suffixes[0] = lastSuffix;
                    return suffixes;
                }
                ++i;
            }
        }
        return suffixes;
    }

    public IStatus validateRepositoryLocation(URL location, IProgressMonitor monitor) {
        Assert.isNotNull((Object)location);
        IMetadataRepository result = this.getRepository(location);
        if (result != null) {
            return Status.OK_STATUS;
        }
        String[] suffixes = this.getAllSuffixes();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.repo_loading, (int)(suffixes.length * 100));
        Status status = new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1000, NLS.bind((String)Messages.repoMan_notExists, (Object)location.toExternalForm()), null);
        int i = 0;
        while (i < suffixes.length) {
            SubMonitor loopMonitor = sub.newChild(100);
            IExtension[] providers = this.findMatchingRepositoryExtensions(suffixes[i], null);
            loopMonitor.beginTask("", providers.length * 10);
            int j = 0;
            while (j < providers.length) {
                IMetadataRepositoryFactory factory = (IMetadataRepositoryFactory)this.createExecutableExtension(providers[j], FACTORY);
                if (factory != null && (status = factory.validate(location, (IProgressMonitor)loopMonitor.newChild(10))).isOK()) {
                    sub.done();
                    return status;
                }
                ++j;
            }
            ++i;
        }
        sub.done();
        return status;
    }

    static class RepositoryInfo {
        String description;
        boolean isSystem = false;
        boolean isEnabled = true;
        URL location;
        String name;
        SoftReference repository;
        String suffix;

        RepositoryInfo() {
        }
    }
}

