/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ExternalFoldersManager;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;

public class ExternalFolderChange {
    private ScriptProject project;
    private IBuildpathEntry[] oldResolvedBuildpath;

    public ExternalFolderChange(ScriptProject project, IBuildpathEntry[] oldResolvedBuildpath) {
        this.project = project;
        this.oldResolvedBuildpath = oldResolvedBuildpath;
    }

    public void updateExternalFoldersIfNecessary(boolean refreshIfExistAlready, IProgressMonitor monitor) throws ModelException {
        HashSet oldFolders = ExternalFoldersManager.getExternalFolders(this.oldResolvedBuildpath);
        IBuildpathEntry[] newResolvedBuildpath = this.project.getResolvedBuildpath();
        HashSet newFolders = ExternalFoldersManager.getExternalFolders(newResolvedBuildpath);
        if (newFolders == null) {
            return;
        }
        ExternalFoldersManager foldersManager = ModelManager.getExternalManager();
        Iterator iterator = newFolders.iterator();
        while (iterator.hasNext()) {
            Object folderPath = iterator.next();
            if (oldFolders != null && oldFolders.remove(folderPath)) continue;
            try {
                foldersManager.createLinkFolder((IPath)folderPath, refreshIfExistAlready, monitor);
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
        }
    }

    public String toString() {
        return "ExternalFolderChange: " + this.project.getElementName();
    }
}

