/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.AbstractExternalSourceModule;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptFolder;

public class ExternalSourceModule
extends AbstractExternalSourceModule {
    private IStorage storage;

    public ExternalSourceModule(ScriptFolder parent, String name, WorkingCopyOwner owner, IStorage storage) {
        this(parent, name, owner, true, storage);
    }

    public ExternalSourceModule(ScriptFolder parent, String name, WorkingCopyOwner owner, boolean readOnly, IStorage storage) {
        super(parent, name, owner, readOnly);
        this.storage = storage;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExternalSourceModule)) {
            return false;
        }
        return super.equals(obj);
    }

    public InputStream getContents() throws CoreException {
        return this.storage.getContents();
    }

    public char[] getFileName() {
        return this.getPath().toOSString().toCharArray();
    }

    public IPath getFullPath() {
        if (this.storage != null) {
            return this.storage.getFullPath();
        }
        return this.getPath();
    }

    public String getName() {
        return this.storage.getName();
    }

    public IResource getResource() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected char[] getBufferContent() throws ModelException {
        char[] cArray;
        IFileHandle file = EnvironmentPathUtils.getFile(this.getPath());
        InputStream stream = null;
        try {
            try {
                char[] content;
                try {
                    if (file != null && file.exists()) {
                        stream = new BufferedInputStream(file.openInputStream(null));
                    } else {
                        boolean inProjectArchive = false;
                        ProjectFragment projectFragment = this.getProjectFragment();
                        if (projectFragment.isArchive() && projectFragment.getResource() != null) {
                            inProjectArchive = projectFragment.getResource().exists();
                        }
                        if (!inProjectArchive) {
                            throw this.newNotPresentException();
                        }
                        stream = new BufferedInputStream(this.storage.getContents());
                    }
                }
                catch (IOException e) {
                    throw new ModelException(e, 969);
                }
                catch (CoreException e) {
                    throw new ModelException(e, 969);
                }
                cArray = content = Util.getInputStreamAsCharArray(stream, -1, "utf-8");
                Object var5_10 = null;
                if (stream == null) return cArray;
            }
            catch (IOException e) {
                throw new ModelException(e, 985);
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        stream.close();
        return cArray;
    }

    protected String getModuleType() {
        return "DLTK External Source Moule: ";
    }

    protected String getNatureId() throws CoreException {
        IPath path = this.getFullPath();
        IDLTKLanguageToolkit toolkit = this.lookupLanguageToolkit(path);
        return toolkit != null ? toolkit.getNatureId() : null;
    }

    protected ISourceModule getOriginalSourceModule() {
        return new ExternalSourceModule((ScriptFolder)this.getParent(), this.getElementName(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, this.storage);
    }
}

