/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.core.builder.IScriptBuilderExtension;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.dltk.internal.core.builder.ScriptBuilderManager;
import org.eclipse.dltk.internal.core.builder.State;
import org.eclipse.osgi.util.NLS;

public class ScriptBuilder
extends IncrementalProjectBuilder {
    public static final boolean DEBUG = DLTKCore.DEBUG_SCRIPT_BUILDER;
    public static final boolean TRACE = DLTKCore.TRACE_SCRIPT_BUILDER;
    public IProject currentProject = null;
    ScriptProject scriptProject = null;
    State lastState;
    public long lastBuildResources = 0L;
    public long lastBuildSourceFiles = 0L;
    private static final QualifiedName PROPERTY_BUILDER_VERSION = new QualifiedName("org.eclipse.dltk.core", "builderVersion");
    private static final String CURRENT_VERSION = "200810012003-2123";
    private static final int WORK_RESOURCES = 50;
    private static final int WORK_EXTERNAL = 100;
    private static final int WORK_SOURCES = 100;
    private static final int WORK_BUILD = 750;
    private static final String NONAME = "";

    public static void buildStarting() {
    }

    public static void buildFinished() {
        if (DLTKCore.DEBUG) {
            System.out.println("build finished");
        }
    }

    private static void log(String message) {
        System.out.println(message);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return new IProject[0];
        }
        if (!DLTKLanguageManager.hasScriptNature(this.currentProject)) {
            return null;
        }
        long startTime = 0L;
        if (DEBUG || TRACE) {
            startTime = System.currentTimeMillis();
            ScriptBuilder.log("\nStarting build of " + this.currentProject.getName() + " @ " + new Date(startTime));
        }
        this.scriptProject = (ScriptProject)DLTKCore.create(this.currentProject);
        String version = this.currentProject.getPersistentProperty(PROPERTY_BUILDER_VERSION);
        if (version == null) {
            this.removeWrongTaskMarkers();
            this.currentProject.setPersistentProperty(PROPERTY_BUILDER_VERSION, CURRENT_VERSION);
            kind = 6;
        } else if (!CURRENT_VERSION.equals(version)) {
            if ("200810012003".equals(version)) {
                this.removeWrongTaskMarkers();
            }
            this.currentProject.setPersistentProperty(PROPERTY_BUILDER_VERSION, CURRENT_VERSION);
            kind = 6;
        }
        this.lastBuildResources = 0L;
        this.lastBuildSourceFiles = 0L;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (kind == 6) {
            if (DEBUG) {
                ScriptBuilder.log("Performing full build as requested by user");
            }
            this.fullBuild(monitor);
        } else {
            this.lastState = this.getLastState(this.currentProject, monitor);
            if (this.lastState == null) {
                if (DEBUG) {
                    ScriptBuilder.log("Performing full build since last saved state was not found");
                }
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    if (DEBUG) {
                        ScriptBuilder.log("Performing full build since deltas are missing after incremental request");
                    }
                    this.fullBuild(monitor);
                } else {
                    if (DEBUG) {
                        ScriptBuilder.log("Performing incremental build");
                    }
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        IProject[] requiredProjects = this.getRequiredProjects(true);
        long endTime = 0L;
        if (DEBUG || TRACE) {
            endTime = System.currentTimeMillis();
        }
        if (DEBUG) {
            ScriptBuilder.log("Finished build of " + this.currentProject.getName() + " @ " + new Date(endTime) + ", elapsed " + (endTime - startTime) + " ms");
        }
        if (TRACE) {
            System.out.println("-----SCRIPT-BUILDER-INFORMATION-TRACE----------------------------");
            System.out.println("Finished build of project:" + this.currentProject.getName() + "\n" + "Building time:" + Long.toString(endTime - startTime) + "\n" + "Resources count:" + this.lastBuildResources + "\n" + "Sources count:" + this.lastBuildSourceFiles + "\n" + "Build type:" + (kind == 6 ? "Full build" : "Incremental build"));
            System.out.println("-----------------------------------------------------------------");
        }
        monitor.done();
        return requiredProjects;
    }

    private void removeWrongTaskMarkers() throws CoreException {
        IMarker[] markers = this.currentProject.findMarkers("org.eclipse.core.resources.taskmarker", false, 2);
        int i = 0;
        while (i < markers.length) {
            Map attributes;
            IMarker marker = markers[i];
            IResource resource = marker.getResource();
            if (resource.getType() == 1 && DLTKContentTypeManager.isValidResourceForContentType(this.scriptProject.getLanguageToolkit(), resource) && (attributes = marker.getAttributes()) != null && Boolean.FALSE.equals(attributes.get("userEditable")) && attributes.containsKey("lineNumber") && attributes.containsKey("message") && attributes.containsKey("priority") && attributes.containsKey("charStart") && attributes.containsKey("charEnd")) {
                marker.delete();
            }
            ++i;
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        long start;
        block9: {
            start = 0L;
            if (TRACE) {
                start = System.currentTimeMillis();
            }
            this.currentProject = this.getProject();
            if (!DLTKLanguageManager.hasScriptNature(this.currentProject)) {
                return;
            }
            this.scriptProject = (ScriptProject)DLTKCore.create(this.currentProject);
            if (this.currentProject == null || !this.currentProject.isAccessible()) {
                return;
            }
            try {
                monitor.beginTask(MessageFormat.format(Messages.ScriptBuilder_cleaningScriptsIn, this.currentProject.getName()), 66);
                if (monitor.isCanceled()) {
                    return;
                }
                IScriptBuilder[] builders = this.getScriptBuilders();
                if (builders != null) {
                    int k = 0;
                    while (k < builders.length) {
                        SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
                        builders[k].clean(this.scriptProject, (IProgressMonitor)sub);
                        if (monitor.isCanceled()) break;
                        ++k;
                    }
                }
                this.resetBuilders(builders);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block9;
                e.printStackTrace();
            }
        }
        if (TRACE) {
            System.out.println("-----SCRIPT-BUILDER-INFORMATION-TRACE----------------------------");
            System.out.println("Finished clean of project:" + this.currentProject.getName() + "\n" + "Building time:" + Long.toString(System.currentTimeMillis() - start));
            System.out.println("-----------------------------------------------------------------");
        }
        monitor.done();
    }

    private IProject[] getRequiredProjects(boolean includeBinaryPrerequisites) {
        if (this.scriptProject == null) {
            return new IProject[0];
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IBuildpathEntry[] entries = this.scriptProject.getExpandedBuildpath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IBuildpathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        if (!((BuildpathEntry)entry).isOptional() || ScriptProject.hasScriptNature(p)) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 1 || !((resource = workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (ModelException modelException) {
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    public State getLastState(IProject project, IProgressMonitor monitor) {
        return (State)ModelManager.getModelManager().getLastBuiltState(project, monitor);
    }

    private State clearLastState() {
        State state = new State(this);
        State prevState = (State)ModelManager.getModelManager().getLastBuiltState(this.currentProject, null);
        if (prevState != null && prevState.noCleanExternalFolders) {
            state.externalFolderLocations = prevState.externalFolderLocations;
            return state;
        }
        ModelManager.getModelManager().setLastBuiltState(this.currentProject, null);
        return state;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fullBuild(IProgressMonitor monitor) {
        State newState;
        this.lastState = newState = this.clearLastState();
        IScriptBuilder[] builders = null;
        try {
            block11: {
                try {
                    int resourceTicks;
                    ArrayList localResources;
                    Set externalElements;
                    Set resources;
                    block14: {
                        block13: {
                            block12: {
                                monitor.setTaskName(NLS.bind((String)Messages.ScriptBuilder_buildingScriptsIn, (Object)this.currentProject.getName()));
                                monitor.beginTask(NONAME, 1000);
                                resources = this.getResourcesFrom(this.currentProject, monitor, 50);
                                if (!monitor.isCanceled()) break block12;
                                break block13;
                            }
                            externalElements = this.getExternalElementsFrom(this.scriptProject, monitor, 100, true);
                            HashSet externalFolders = new HashSet(this.lastState.externalFolderLocations);
                            if (monitor.isCanceled()) break block13;
                            int totalFiles = resources.size() + externalElements.size();
                            if (totalFiles == 0) {
                                totalFiles = 1;
                            }
                            builders = this.getScriptBuilders();
                            localResources = new ArrayList();
                            ArrayList localElements = new ArrayList();
                            this.locateSourceModules(monitor, 100, resources, localElements, localResources);
                            if (monitor.isCanceled()) break block13;
                            resourceTicks = 750 * (resources.size() - localElements.size()) / totalFiles;
                            resourceTicks = Math.min(resourceTicks, 187);
                            try {
                                this.buildElements(localElements, externalElements, monitor, 750 - resourceTicks, 1, Collections.EMPTY_SET, externalFolders, builders);
                                this.lastBuildSourceFiles += (long)externalElements.size();
                            }
                            catch (CoreException e) {
                                DLTKCore.error(Messages.ScriptBuilder_errorBuildElements, e);
                            }
                            if (!monitor.isCanceled()) break block14;
                        }
                        Object var12_6 = null;
                        this.resetBuilders(builders);
                        monitor.done();
                        ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
                        return;
                    }
                    this.buildResources(localResources, monitor, resourceTicks, 6, builders);
                    this.lastBuildResources = resources.size() + externalElements.size();
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block11;
                    e.printStackTrace();
                }
            }
            Object var12_8 = null;
            this.resetBuilders(builders);
        }
        catch (Throwable throwable) {
            Object var12_7 = null;
            this.resetBuilders(builders);
            monitor.done();
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            throw throwable;
        }
        monitor.done();
        ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
    }

    private void resetBuilders(IScriptBuilder[] builders) {
        if (builders != null) {
            int k = 0;
            while (k < builders.length) {
                builders[k].reset(this.scriptProject);
                ++k;
            }
        }
    }

    private Set getResourcesFrom(Object el, IProgressMonitor monitor, int ticks) throws CoreException {
        Set set;
        monitor.subTask(Messages.ScriptBuilder_scanningProject);
        try {
            ResourceVisitor resourceVisitor = new ResourceVisitor(monitor);
            if (el instanceof IProject) {
                IProject prj = (IProject)el;
                prj.accept((IResourceVisitor)resourceVisitor);
            } else if (el instanceof IResourceDelta) {
                IResourceDelta delta = (IResourceDelta)el;
                delta.accept((IResourceDeltaVisitor)resourceVisitor);
            }
            set = resourceVisitor.resources;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            monitor.worked(ticks);
            throw throwable;
        }
        monitor.worked(ticks);
        return set;
    }

    private Set getExternalElementsFrom(ScriptProject prj, IProgressMonitor monitor, int tiks, boolean updateState) throws ModelException {
        String name = Messages.ScriptBuilder_scanningExternalFolders;
        monitor.subTask(name);
        SubProgressMonitor mon = new SubProgressMonitor(monitor, tiks);
        IProjectFragment[] fragments = prj.getAllProjectFragments();
        ArrayList<IProjectFragment> extFragments = new ArrayList<IProjectFragment>(fragments.length);
        ArrayList<IPath> fragmentPaths = new ArrayList<IPath>(fragments.length);
        int i = 0;
        while (i < fragments.length) {
            IProjectFragment fragment = fragments[i];
            if (fragment instanceof ExternalProjectFragment || fragment instanceof BuiltinProjectFragment) {
                IPath path = fragment.getPath();
                if (!updateState || !this.lastState.externalFolderLocations.contains(path)) {
                    extFragments.add(fragment);
                } else {
                    fragmentPaths.add(path);
                }
            }
            ++i;
        }
        ExternalModuleVisitor visitor = new ExternalModuleVisitor((IProgressMonitor)mon);
        mon.beginTask(name, extFragments.size());
        Iterator iterator = extFragments.iterator();
        while (iterator.hasNext()) {
            IProjectFragment fragment = (IProjectFragment)iterator.next();
            fragment.accept(visitor);
            if (updateState) {
                fragmentPaths.add(fragment.getPath());
            }
            mon.worked(1);
        }
        mon.done();
        if (updateState) {
            this.lastState.externalFolderLocations.clear();
            this.lastState.externalFolderLocations.addAll(fragmentPaths);
        }
        return visitor.elements;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        State newState = new State(this);
        HashSet externalFoldersBefore = new HashSet();
        if (this.lastState != null) {
            newState.copyFrom(this.lastState);
            externalFoldersBefore.addAll(newState.getExternalFolders());
        }
        this.lastState = newState;
        IScriptBuilder[] builders = null;
        try {
            int resourceTicks;
            ArrayList localResources;
            Set externalElements;
            Set resources;
            block13: {
                block12: {
                    block11: {
                        monitor.setTaskName(NLS.bind((String)Messages.ScriptBuilder_buildingScriptsIn, (Object)this.currentProject.getName()));
                        monitor.beginTask(NONAME, 1000);
                        if (!monitor.isCanceled()) break block11;
                        break block12;
                    }
                    resources = this.getResourcesFrom(delta, monitor, 50);
                    if (monitor.isCanceled()) break block12;
                    if (DEBUG) {
                        ScriptBuilder.log("Number of changed resources in delta: " + resources.size());
                    }
                    externalElements = this.getExternalElementsFrom(this.scriptProject, monitor, 100, true);
                    HashSet externalFolders = new HashSet(this.lastState.externalFolderLocations);
                    if (monitor.isCanceled()) break block12;
                    int totalFiles = resources.size() + externalElements.size();
                    if (totalFiles == 0) {
                        totalFiles = 1;
                    }
                    builders = this.getScriptBuilders();
                    localResources = new ArrayList();
                    ArrayList localElements = new ArrayList();
                    this.locateSourceModules(monitor, 100, resources, localElements, localResources);
                    if (monitor.isCanceled()) break block12;
                    resourceTicks = 750 * (resources.size() - localElements.size()) / totalFiles;
                    if (monitor.isCanceled()) break block12;
                    try {
                        this.buildElements(localElements, externalElements, monitor, 750 - resourceTicks, 0, externalFoldersBefore, externalFolders, builders);
                    }
                    catch (CoreException e) {
                        DLTKCore.error(Messages.ScriptBuilder_errorBuildElements, e);
                    }
                    this.lastBuildSourceFiles += (long)externalElements.size();
                    if (!monitor.isCanceled()) break block13;
                }
                Object var14_6 = null;
                this.resetBuilders(builders);
                monitor.done();
                ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
                return;
            }
            this.buildResources(localResources, monitor, resourceTicks, 6, builders);
            this.lastBuildResources = resources.size() + externalElements.size();
            Object var14_8 = null;
            this.resetBuilders(builders);
        }
        catch (Throwable throwable) {
            Object var14_7 = null;
            this.resetBuilders(builders);
            monitor.done();
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            throw throwable;
        }
        monitor.done();
        ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
    }

    private IScriptBuilder[] getScriptBuilders() throws CoreException {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this.scriptProject);
        if (toolkit != null) {
            IScriptBuilder[] builders = ScriptBuilderManager.getScriptBuilders(toolkit.getNatureId());
            if (builders != null) {
                int k = 0;
                while (k < builders.length) {
                    builders[k].initialize(this.scriptProject);
                    ++k;
                }
            }
            return builders;
        }
        return null;
    }

    protected void locateSourceModules(IProgressMonitor monitor, int tiks, Set resources, List realElements, List realResources) {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, tiks / 3);
        sub.beginTask(NONAME, resources.size());
        int remainingWork = resources.size();
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            IResource res = (IResource)iterator.next();
            sub.subTask(NLS.bind((String)Messages.ScriptBuilder_Locating_source_modules, (Object)String.valueOf(remainingWork), (Object)res.getName()));
            sub.worked(1);
            if (sub.isCanceled()) {
                return;
            }
            IModelElement element = DLTKCore.create(res);
            if (element != null && element.getElementType() == 5 && element.exists()) {
                realElements.add(element);
            } else {
                realResources.add(res);
            }
            --remainingWork;
        }
        sub.done();
        this.lastBuildSourceFiles += (long)realElements.size();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void buildResources(List realResources, IProgressMonitor monitor, int tiks, int buildType, IScriptBuilder[] builders) {
        if (builders == null || builders.length == 0 || realResources.isEmpty()) {
            monitor.worked(tiks);
            return;
        }
        SubProgressMonitor ssub = new SubProgressMonitor(monitor, tiks);
        try {
            ssub.beginTask(Messages.ScriptBuilder_building, builders.length);
            int k = 0;
            while (k < builders.length) {
                builders[k].buildResources(this.scriptProject, realResources, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)ssub, 1), buildType);
                ++k;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ssub.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        ssub.done();
    }

    protected void buildElements(List localElements, Set externalElements, IProgressMonitor monitor, int ticks, int buildType, Set externalFoldersBefore, Set externalFolders, IScriptBuilder[] builders) throws CoreException {
        if (builders == null) {
            return;
        }
        int[] workEstimations = new int[builders.length];
        List[] builderToElements = new List[builders.length];
        List[] builderExternalElements = new List[builders.length];
        int[] buildTypes = new int[builders.length];
        Arrays.fill(buildTypes, buildType);
        this.estimateBuild(localElements, externalElements, externalFoldersBefore, externalFolders, builders, workEstimations, builderToElements, builderExternalElements, buildTypes);
        int total = 0;
        int k = 0;
        while (k < builders.length) {
            total += workEstimations[k];
            ++k;
        }
        k = 0;
        while (k < builders.length) {
            List buildElementsList;
            if (monitor.isCanceled()) {
                return;
            }
            IScriptBuilder builder = builders[k];
            int builderWork = workEstimations[k] * ticks / total;
            List buildExternalElements = builderExternalElements[k];
            if (buildExternalElements != null && buildExternalElements.size() > 0 && builder instanceof IScriptBuilderExtension) {
                int step = buildExternalElements.size() * ticks / total;
                builderWork -= step;
                monitor.subTask(NLS.bind((String)Messages.ScriptBuilder_building_N_externalModules, (Object)Integer.toString(buildExternalElements.size())));
                ((IScriptBuilderExtension)((Object)builder)).buildExternalElements(this.scriptProject, buildExternalElements, (IProgressMonitor)new SubProgressMonitor(monitor, step), buildTypes[k]);
            }
            if ((buildElementsList = builderToElements[k]).size() > 0) {
                int step = buildElementsList.size() * ticks / total;
                builderWork -= step;
                monitor.subTask(NLS.bind((String)Messages.ScriptBuilder_building_N_localModules, (Object)Integer.toString(buildElementsList.size())));
                builder.buildModelElements(this.scriptProject, buildElementsList, (IProgressMonitor)new SubProgressMonitor(monitor, step), buildTypes[k]);
            }
            if (builderWork > 0) {
                monitor.worked(builderWork);
            }
            ++k;
        }
    }

    private void estimateBuild(List localElements, Set externalElements, Set externalFoldersBefore, Set externalFolders, IScriptBuilder[] builders, int[] workEstimations, List[] builderToElements, List[] builderExternalElements, int[] buildTypes) throws CoreException {
        HashSet elementsAsSet = new HashSet(localElements);
        List projectElements = null;
        ArrayList projectExternalElements = null;
        int k = 0;
        while (k < builders.length) {
            ArrayList buildExternalElements;
            ArrayList buildElementsList;
            IScriptBuilder builder = builders[k];
            IScriptBuilder.DependencyResponse response = builder.getDependencies(this.scriptProject, buildTypes[k], elementsAsSet, externalElements, externalFoldersBefore, externalFolders);
            if (response == null) {
                buildElementsList = localElements;
                buildExternalElements = null;
            } else {
                HashSet e;
                Set dependencies;
                if (response.isFullLocalBuild()) {
                    if (buildTypes[k] == 1) {
                        buildElementsList = localElements;
                    } else {
                        if (projectElements == null) {
                            projectElements = this.collectLocalElements();
                        }
                        buildElementsList = projectElements;
                    }
                } else {
                    dependencies = response.getLocalDependencies();
                    if (dependencies != null && !dependencies.isEmpty() && !elementsAsSet.containsAll(dependencies)) {
                        e = new HashSet(elementsAsSet.size() + dependencies.size());
                        e.addAll(elementsAsSet);
                        e.addAll(dependencies);
                        buildElementsList = new ArrayList(e);
                    } else {
                        buildElementsList = localElements;
                    }
                }
                if (response.isFullExternalBuild()) {
                    if (buildTypes[k] == 1) {
                        buildExternalElements = new ArrayList(externalElements);
                    } else {
                        if (projectExternalElements == null) {
                            projectExternalElements = new ArrayList(this.getExternalElementsFrom(this.scriptProject, (IProgressMonitor)new NullProgressMonitor(), 1, false));
                        }
                        buildExternalElements = projectExternalElements;
                    }
                } else {
                    dependencies = response.getExternalDependencies();
                    if (dependencies != null && !dependencies.isEmpty() && !externalElements.containsAll(dependencies)) {
                        e = new HashSet(externalElements.size() + dependencies.size());
                        e.addAll(externalElements);
                        e.addAll(dependencies);
                        buildExternalElements = new ArrayList(e);
                    } else {
                        buildExternalElements = null;
                    }
                }
                if (response.isFullLocalBuild() || response.isFullExternalBuild()) {
                    buildTypes[k] = 1;
                }
            }
            builderToElements[k] = buildElementsList;
            builderExternalElements[k] = buildExternalElements;
            int work = buildElementsList.size();
            if (buildExternalElements != null) {
                work += buildExternalElements.size();
            }
            workEstimations[k] = Math.max(work, 1);
            ++k;
        }
    }

    private List collectLocalElements() throws CoreException {
        NullProgressMonitor nullMon = new NullProgressMonitor();
        Set resources = this.getResourcesFrom(this.currentProject, (IProgressMonitor)nullMon, 1);
        ArrayList elements = new ArrayList();
        this.locateSourceModules((IProgressMonitor)nullMon, 1, resources, elements, new ArrayList());
        return elements;
    }

    public static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.dltk.core.problem", false, 2);
                resource.deleteMarkers("org.eclipse.dltk.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {}
    }

    public static void writeState(Object state, DataOutputStream out) throws IOException {
        ((State)state).write(out);
    }

    public static State readState(IProject project, DataInputStream in) throws IOException {
        State state = State.read(project, in);
        return state;
    }

    static class ExternalModuleVisitor
    implements IModelElementVisitor {
        final Set elements = new HashSet();
        private final IProgressMonitor monitor;

        public ExternalModuleVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IModelElement element) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (element.getElementType() == 3) {
                if (!(element instanceof ExternalProjectFragment) && !(element instanceof BuiltinProjectFragment)) {
                    return false;
                }
                IProjectFragment fragment = (IProjectFragment)element;
                String localPath = EnvironmentPathUtils.getLocalPath(fragment.getPath()).toString();
                if (!localPath.startsWith("#")) {
                    this.monitor.subTask(String.valueOf(Messages.ScriptBuilder_scanningExternalFolder) + localPath);
                }
            } else {
                IScriptFolder folder;
                String localPath;
                if (element.getElementType() == 5) {
                    if (element instanceof ExternalSourceModule || element instanceof BuiltinSourceModule) {
                        this.elements.add(element);
                    }
                    return false;
                }
                if (element.getElementType() == 4 && !(localPath = EnvironmentPathUtils.getLocalPath((folder = (IScriptFolder)element).getPath()).toString()).startsWith("#")) {
                    this.monitor.subTask(String.valueOf(Messages.ScriptBuilder_scanningExternalFolder) + localPath);
                }
            }
            return true;
        }
    }

    static class ResourceVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        final Set resources = new HashSet();
        private final IProgressMonitor monitor;

        public ResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource.getType() == 2) {
                this.monitor.subTask(String.valueOf(Messages.ScriptBuilder_scanningProjectFolder) + resource.getProjectRelativePath().toString());
            }
            if (resource.getType() == 1) {
                switch (delta.getKind()) {
                    case 1: 
                    case 4: {
                        this.resources.add(resource);
                    }
                }
                return false;
            }
            return true;
        }

        public boolean visit(IResource resource) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (resource.getType() == 2) {
                this.monitor.subTask(String.valueOf(Messages.ScriptBuilder_scanningProjectFolder) + resource.getProjectRelativePath().toString());
            }
            if (resource.getType() == 1) {
                this.resources.add(resource);
                return false;
            }
            return true;
        }
    }
}

